/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.emf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.cde.emf.EMFPrototypeFactory;
import org.eclipse.ve.internal.cde.emf.IDomainedFactory;

public class EMFPrototypeCreationFactory
extends EMFPrototypeFactory
implements IDomainedFactory {
    protected URI prototypeURI;

    public EMFPrototypeCreationFactory(String prototypeURIString) {
        this.setPrototypeURI(URI.createURI((String)prototypeURIString));
    }

    public EMFPrototypeCreationFactory(String protoTypeFragment, Resource prototypeResource) {
        this.getPrototypes(protoTypeFragment, prototypeResource);
    }

    public void setPrototypeURI(URI prototypeURI) {
        this.prototypeURI = prototypeURI;
    }

    public void setEditDomain(EditDomain domain) {
        if (this.prototypeURI != null) {
            ResourceSet rset;
            Resource res;
            this.setPrototype(null, null);
            if (this.prototypeURI != null && (res = (rset = EMFEditDomainHelper.getResourceSet(domain)).getResource(this.prototypeURI.trimFragment(), true)) != null) {
                this.getPrototypes(this.prototypeURI.fragment(), res);
                rset.getResources().remove((Object)res);
            }
        }
    }

    private void getPrototypes(String prototypeFragment, Resource res) {
        EObject prototype = res.getEObject(prototypeFragment);
        if (prototype != null) {
            EList prototypes = null;
            if (prototype.eContainer() != null) {
                prototype = null;
                Logger logger = CDEPlugin.getPlugin().getLogger();
                if (logger.isLoggingLevel(Level.INFO)) {
                    logger.log((Object)("Prototype from URI is not contained directly by the Resource. Res=" + res.getURI() + " Fragment=" + prototypeFragment), Level.INFO);
                }
            } else {
                prototypes = res.getContents();
            }
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            if (prototypes == null || !prototypes.contains(prototype)) {
                copier.copy(prototype);
            }
            if (prototypes != null) {
                copier.copyAll((Collection)prototypes);
            }
            copier.copyReferences();
            ArrayList<Object> copyPrototypes = null;
            if (prototypes != null && !prototypes.isEmpty()) {
                copyPrototypes = new ArrayList<Object>(prototypes.size());
                int i = 0;
                while (i < prototypes.size()) {
                    copyPrototypes.add(copier.get(prototypes.get(i)));
                    ++i;
                }
            }
            this.setPrototype((EObject)copier.get((Object)prototype), copyPrototypes);
        }
    }
}

