/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.properties;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.decorators.PropertyDescriptorInformation;
import org.eclipse.ve.internal.cde.properties.AbstractPropertyDescriptorAdapter;
import org.eclipse.ve.internal.cde.properties.DecoratedPropertyDescriptorAdapter;
import org.osgi.framework.Bundle;

public class PropertyDescriptorAdapterFactory
extends AdapterFactoryImpl {
    protected AdapterType[] fTypes;

    public PropertyDescriptorAdapterFactory() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(CDEPlugin.getPlugin().getPluginID(), "adapter");
        if (point == null) {
            this.fTypes = new AdapterType[0];
            return;
        }
        IConfigurationElement[] elements = point.getConfigurationElements();
        ArrayList<AdapterType> types = new ArrayList<AdapterType>(elements.length);
        int i = 0;
        while (i < elements.length) {
            if (elements[i].getName().equals("adapter")) {
                String typeName = elements[i].getAttributeAsIs("typeclass");
                types.add(new AdapterType(typeName, elements[i]));
            }
            ++i;
        }
        this.fTypes = types.toArray(new AdapterType[types.size()]);
    }

    public Adapter createAdapter(Notifier target) {
        PropertyDescriptorInformation decor = this.findDecorator((EModelElement)target);
        if (decor != null && decor.isAdapter() && decor.getPropertyDescriptorClassname() != null) {
            String cname = decor.getPropertyDescriptorClassname();
            try {
                return (Adapter)CDEPlugin.createInstance(null, cname);
            }
            catch (Exception e) {
                String msg = MessageFormat.format(CDEMessages.Object_noinstantiate_EXC_, cname);
                CDEPlugin.getPlugin().getLog().log((IStatus)new Status(2, CDEPlugin.getPlugin().getPluginID(), 0, msg, (Throwable)e));
            }
        }
        Iterator itr = ((EModelElement)target).getEAnnotations().iterator();
        while (itr.hasNext()) {
            Object next = itr.next();
            int i = 0;
            while (i < this.fTypes.length) {
                if (this.fTypes[i].matches(next)) {
                    try {
                        return (Adapter)this.fTypes[i].fConfigElement.createExecutableExtension("adapterclass");
                    }
                    catch (CoreException e) {
                        String msg = MessageFormat.format(CDEMessages.Object_noinstantiate_EXC_, this.fTypes[i].fConfigElement.getAttributeAsIs("adapterclass"));
                        CDEPlugin.getPlugin().getLog().log((IStatus)new Status(2, CDEPlugin.getPlugin().getPluginID(), 0, msg, (Throwable)e));
                    }
                }
                ++i;
            }
        }
        return new DecoratedPropertyDescriptorAdapter();
    }

    protected PropertyDescriptorInformation findDecorator(EModelElement model) {
        Iterator itr = model.getEAnnotations().iterator();
        while (itr.hasNext()) {
            Object next = itr.next();
            if (!(next instanceof PropertyDescriptorInformation)) continue;
            return (PropertyDescriptorInformation)next;
        }
        return null;
    }

    public boolean isFactoryForType(Object type) {
        return AbstractPropertyDescriptorAdapter.IPROPERTYDESCRIPTOR_TYPE == type;
    }

    private static class AdapterType {
        protected Class fDecoratorType;
        protected String fDecoratorTypeName;
        protected Bundle decoratingTypeBundle;
        protected String fFullDecoratorTypeName;
        protected Bundle declaringBundle;
        public IConfigurationElement fConfigElement;

        public AdapterType(String typeName, IConfigurationElement config) {
            int slashNdx = typeName.indexOf(47);
            int colonNdx = typeName.indexOf(58, slashNdx + 1);
            this.fDecoratorTypeName = typeName.substring(slashNdx + 1, colonNdx == -1 ? typeName.length() : colonNdx);
            this.fFullDecoratorTypeName = typeName;
            this.fConfigElement = config;
            this.declaringBundle = Platform.getBundle((String)config.getDeclaringExtension().getNamespace());
            String decTypePlugin = typeName.substring(0, slashNdx == -1 ? 0 : slashNdx);
            if (decTypePlugin.length() == 0) {
                this.decoratingTypeBundle = this.declaringBundle;
            } else {
                this.decoratingTypeBundle = Platform.getBundle((String)decTypePlugin);
                if (this.decoratingTypeBundle == null) {
                    this.fDecoratorTypeName = null;
                }
            }
        }

        public boolean matches(Object instance) {
            if (this.fDecoratorTypeName == null) {
                return false;
            }
            if (this.fDecoratorType != null) {
                return this.fDecoratorType.isInstance(instance);
            }
            if (this.decoratingTypeBundle.getState() == 32) {
                try {
                    this.fDecoratorType = CDEPlugin.getClassFromString(this.declaringBundle, this.fFullDecoratorTypeName);
                    return this.fDecoratorType.isInstance(instance);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.fDecoratorTypeName = null;
                }
            }
            return false;
        }
    }
}

