/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.vm;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.ICallback;
import org.eclipse.jem.internal.proxy.common.ICallbackHandler;
import org.eclipse.jem.internal.proxy.common.ICallbackRunnable;
import org.eclipse.jem.internal.proxy.common.IVMCallbackServer;

public class ImageDataCollector
implements ImageConsumer,
ICallback {
    protected IVMCallbackServer fVMServer;
    protected int fCallbackID;
    protected DataOutputStream fos;
    protected int fWidth;
    protected int fHeight;
    protected IndexColorModel fStartingIndexModel;
    protected boolean fIndex;
    protected int fStatus = -1;
    protected static final int NO_MODEL = -1;
    protected int fDepth = -1;
    protected ImageProducer fProducer = null;
    protected boolean fEndProductionRequested = false;

    public void initializeCallback(IVMCallbackServer vmServer, int callbackID) {
        this.fVMServer = vmServer;
        this.fCallbackID = callbackID;
    }

    public boolean start(Image image) throws IllegalAccessException, IllegalArgumentException, CommandException {
        return this.start(image, -1);
    }

    protected boolean start(Image image, int startStatus) throws IllegalAccessException, IllegalArgumentException, CommandException {
        return this.start(image.getSource(), startStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(final Component component, final int maxWidth, final int maxHeight) throws IllegalAccessException, IllegalArgumentException, CommandException {
        ImageDataCollector imageDataCollector = this;
        synchronized (imageDataCollector) {
            block4: {
                if (this.fStatus == -1) break block4;
                return false;
            }
            this.fStatus = 6;
        }
        EventQueue.invokeLater(new Runnable(){

            /*
             * Exception decompiling
             */
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [5 : 384->387)] java.lang.Throwable
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            static /* synthetic */ ImageDataCollector access$0(1 var0) {
                return var0.ImageDataCollector.this;
            }
        });
        return true;
    }

    public boolean start(ImageProducer producer) throws IllegalAccessException, IllegalArgumentException, CommandException {
        return this.start(producer, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean start(final ImageProducer producer, final int initialStartStatus) throws IllegalAccessException, IllegalArgumentException, CommandException {
        ImageDataCollector imageDataCollector = this;
        synchronized (imageDataCollector) {
            if (this.fProducer != null) {
                throw new IllegalAccessException("Image collection already in progress.");
            }
            if (producer == null) {
                throw new IllegalArgumentException("ImageProducer is null");
            }
            this.fStartingIndexModel = null;
            this.fIndex = false;
            this.fHeight = -1;
            this.fWidth = -1;
            this.fDepth = -1;
            this.fStatus = 6;
            this.fProducer = producer;
            this.fEndProductionRequested = false;
            this.fos = null;
            try {
                this.fos = new DataOutputStream(this.fVMServer.requestStream(this.fCallbackID, 1));
                Object var4_6 = null;
                if (this.fos == null) {
                    this.fProducer = null;
                    this.fEndProductionRequested = true;
                    this.fStatus = 5;
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (this.fos == null) {
                    this.fProducer = null;
                    this.fEndProductionRequested = true;
                    this.fStatus = 5;
                }
                throw throwable;
            }
        }
        if (this.fos == null) {
            return false;
        }
        new Thread(new Runnable(){

            /*
             * Exception decompiling
             */
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [8 : 217->220)] java.lang.Throwable
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            static /* synthetic */ ImageDataCollector access$0(3 var0) {
                return var0.ImageDataCollector.this;
            }
        }).start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDimensions(int width, int height) {
        ImageDataCollector imageDataCollector = this;
        synchronized (imageDataCollector) {
            if (this.fEndProductionRequested) {
                return;
            }
        }
        if (width != this.fWidth || height != this.fHeight) {
            try {
                this.fos.writeByte(1);
                this.fos.writeInt(width);
                this.fos.writeInt(height);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.requestTerminate(1);
                return;
            }
            this.fWidth = width;
            this.fHeight = height;
        }
    }

    public void setProperties(Hashtable properties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorModel(ColorModel model) {
        ImageDataCollector imageDataCollector = this;
        synchronized (imageDataCollector) {
            if (this.fEndProductionRequested) {
                return;
            }
        }
        if (!(model instanceof IndexColorModel)) {
            if (this.fIndex) {
                this.sendClientDirectColorModel(model.getPixelSize());
            } else {
                int newDepth = model.getPixelSize();
                if (newDepth == 15) {
                    newDepth = 16;
                }
                if (this.fDepth != newDepth) {
                    this.sendClientDirectColorModel(newDepth);
                }
            }
        } else if (model != this.fStartingIndexModel) {
            if (this.fDepth == -1) {
                this.sendClientIndexColorModel((IndexColorModel)model);
            } else if (this.fIndex) {
                int oldLength;
                int newLength;
                boolean compatible = false;
                if (this.fStartingIndexModel.getPixelSize() == model.getPixelSize() && (newLength = ((IndexColorModel)model).getMapSize()) == (oldLength = this.fStartingIndexModel.getMapSize())) {
                    int[] oldRGBs = new int[oldLength];
                    int[] newRGBs = new int[newLength];
                    this.fStartingIndexModel.getRGBs(oldRGBs);
                    ((IndexColorModel)model).getRGBs(newRGBs);
                    compatible = Arrays.equals(oldRGBs, newRGBs);
                }
                if (!compatible) {
                    this.sendClientDirectColorModel(0);
                }
            }
        }
    }

    protected void sendClientDirectColorModel(int depth) {
        switch (depth) {
            case 0: {
                try {
                    depth = (Integer)this.fVMServer.doCallback(new ICallbackRunnable(){

                        public Object run(ICallbackHandler handler) throws CommandException {
                            return handler.callbackWithParms(ImageDataCollector.this.fCallbackID, 2, null);
                        }
                    });
                }
                catch (CommandException e) {
                    e.printStackTrace();
                    depth = 24;
                }
                break;
            }
            case 16: 
            case 24: {
                break;
            }
            default: {
                depth = 24;
            }
        }
        this.fDepth = depth;
        this.fStartingIndexModel = null;
        this.fIndex = false;
        try {
            this.fos.writeByte(2);
            this.fos.writeByte((byte)depth);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.requestTerminate(1);
            return;
        }
    }

    protected void sendClientIndexColorModel(IndexColorModel model) {
        this.fStartingIndexModel = model;
        this.fIndex = true;
        this.fDepth = model.getPixelSize();
        int length = model.getMapSize();
        int transparentPixel = model.getTransparentPixel();
        byte[] reds = new byte[length];
        byte[] greens = new byte[length];
        byte[] blues = new byte[length];
        model.getReds(reds);
        model.getGreens(greens);
        model.getBlues(blues);
        try {
            this.fos.writeByte(3);
            this.fos.writeByte((byte)this.fDepth);
            this.fos.writeInt(transparentPixel);
            this.fos.writeInt(length);
            int i = 0;
            while (i < length) {
                this.fos.writeByte(reds[i]);
                this.fos.writeByte(greens[i]);
                this.fos.writeByte(blues[i]);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.requestTerminate(1);
            return;
        }
    }

    public void setHints(int hintsFlags) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        ImageDataCollector imageDataCollector = this;
        synchronized (imageDataCollector) {
            if (this.fEndProductionRequested) {
                return;
            }
        }
        if (this.fIndex) {
            if (this.fStartingIndexModel != model) {
                this.sendClientDirectColorModel(0);
                this.setPixels(x, y, w, h, model, pixels, off, scansize);
            } else {
                int rowOffset = 0;
                int row = y;
                while (rowOffset < h) {
                    try {
                        int dupCnt;
                        int javaIndex;
                        this.fos.writeByte(4);
                        this.fos.writeInt(x);
                        this.fos.writeInt(row);
                        int startNonDup = javaIndex = off + scansize * rowOffset;
                        int startDup = javaIndex;
                        byte startDupPixel = pixels[javaIndex];
                        int stop = javaIndex + w;
                        while (javaIndex < stop) {
                            byte pixel = pixels[javaIndex];
                            if (pixel != startDupPixel) {
                                dupCnt = javaIndex - startDup;
                                if (dupCnt < 3) {
                                    startDup = javaIndex;
                                    startDupPixel = pixel;
                                } else {
                                    if (startNonDup < startDup) {
                                        this.fos.writeByte(7);
                                        this.fos.writeInt(startDup - startNonDup);
                                        while (startNonDup < startDup) {
                                            this.fos.writeByte(pixels[startNonDup++]);
                                        }
                                    }
                                    this.fos.writeByte(6);
                                    this.fos.writeInt(dupCnt);
                                    this.fos.writeByte(startDupPixel);
                                    startDup = startNonDup = javaIndex;
                                    startDupPixel = pixel;
                                }
                            }
                            ++javaIndex;
                        }
                        dupCnt = javaIndex - startDup;
                        if (dupCnt < 3) {
                            startDup = javaIndex;
                            dupCnt = 0;
                        }
                        if (startNonDup < startDup) {
                            this.fos.writeByte(7);
                            this.fos.writeInt(startDup - startNonDup);
                            while (startNonDup < startDup) {
                                this.fos.writeByte(pixels[startNonDup++]);
                            }
                        }
                        if (dupCnt > 0) {
                            this.fos.writeByte(6);
                            this.fos.writeInt(dupCnt);
                            this.fos.writeByte(startDupPixel);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.requestTerminate(1);
                        return;
                    }
                    ++rowOffset;
                    ++row;
                }
            }
        } else {
            if (w <= 0) {
                return;
            }
            int rowOffset = 0;
            int row = y;
            while (rowOffset < h) {
                try {
                    int dupCnt;
                    int javaIndex;
                    this.fos.writeByte(5);
                    this.fos.writeInt(x);
                    this.fos.writeInt(row);
                    int startNonDup = javaIndex = off + scansize * rowOffset;
                    int startDup = javaIndex;
                    byte startDupPixel = pixels[javaIndex];
                    int stop = javaIndex + w;
                    while (javaIndex < stop) {
                        byte pixel = pixels[javaIndex];
                        if (pixel != startDupPixel) {
                            dupCnt = javaIndex - startDup;
                            if (dupCnt < 3) {
                                startDup = javaIndex;
                                startDupPixel = pixel;
                            } else {
                                if (startNonDup < startDup) {
                                    this.fos.writeByte(7);
                                    this.fos.writeInt(startDup - startNonDup);
                                    while (startNonDup < startDup) {
                                        this.writeIntPixel(model, pixels[startNonDup++]);
                                    }
                                }
                                this.fos.writeByte(6);
                                this.fos.writeInt(dupCnt);
                                this.writeIntPixel(model, startDupPixel);
                                startDup = startNonDup = javaIndex;
                                startDupPixel = pixel;
                            }
                        }
                        ++javaIndex;
                    }
                    dupCnt = javaIndex - startDup;
                    if (dupCnt < 3) {
                        startDup = javaIndex;
                        dupCnt = 0;
                    }
                    if (startNonDup < startDup) {
                        this.fos.writeByte(7);
                        this.fos.writeInt(startDup - startNonDup);
                        while (startNonDup < startDup) {
                            this.writeIntPixel(model, pixels[startNonDup++]);
                        }
                    }
                    if (dupCnt > 0) {
                        this.fos.writeByte(6);
                        this.fos.writeInt(dupCnt);
                        this.writeIntPixel(model, startDupPixel);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.requestTerminate(1);
                    return;
                }
                ++rowOffset;
                ++row;
            }
        }
    }

    private void writeIntPixel(ColorModel model, int pixel) throws IOException {
        if (this.fDepth == 16) {
            int red = model.getRed(pixel) >> 3 & 0x1F;
            int green = model.getGreen(pixel) >> 3 & 0x1F;
            int blue = model.getBlue(pixel) >> 3 & 0x1F;
            this.fos.writeInt(red << 10 | green << 5 | blue);
        } else {
            this.fos.writeInt((model.getBlue(pixel) & 0xFF) << 16 | (model.getGreen(pixel) & 0xFF) << 8 | model.getRed(pixel) & 0xFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        ImageDataCollector imageDataCollector = this;
        synchronized (imageDataCollector) {
            if (this.fEndProductionRequested) {
                return;
            }
        }
        if (this.fIndex) {
            if (this.fStartingIndexModel != model) {
                this.sendClientDirectColorModel(0);
                this.setPixels(x, y, w, h, model, pixels, off, scansize);
            } else {
                int rowOffset = 0;
                int row = y;
                while (rowOffset < h) {
                    try {
                        int dupCnt;
                        int javaIndex;
                        this.fos.writeByte(5);
                        this.fos.writeInt(x);
                        this.fos.writeInt(row);
                        int startNonDup = javaIndex = off + scansize * rowOffset;
                        int startDup = javaIndex;
                        int startDupPixel = pixels[javaIndex];
                        int stop = javaIndex + w;
                        while (javaIndex < stop) {
                            int pixel = pixels[javaIndex];
                            if (pixel != startDupPixel) {
                                dupCnt = javaIndex - startDup;
                                if (dupCnt < 3) {
                                    startDup = javaIndex;
                                    startDupPixel = pixel;
                                } else {
                                    if (startNonDup < startDup) {
                                        this.fos.writeByte(7);
                                        this.fos.writeInt(startDup - startNonDup);
                                        while (startNonDup < startDup) {
                                            this.fos.writeInt(pixels[startNonDup++]);
                                        }
                                    }
                                    this.fos.writeByte(6);
                                    this.fos.writeInt(dupCnt);
                                    this.fos.writeInt(startDupPixel);
                                    startDup = startNonDup = javaIndex;
                                    startDupPixel = pixel;
                                }
                            }
                            ++javaIndex;
                        }
                        dupCnt = javaIndex - startDup;
                        if (dupCnt < 3) {
                            startDup = javaIndex;
                            dupCnt = 0;
                        }
                        if (startNonDup < startDup) {
                            this.fos.writeByte(7);
                            this.fos.writeInt(startDup - startNonDup);
                            while (startNonDup < startDup) {
                                this.fos.writeInt(pixels[startNonDup++]);
                            }
                        }
                        if (dupCnt > 0) {
                            this.fos.writeByte(6);
                            this.fos.writeInt(dupCnt);
                            this.fos.writeInt(startDupPixel);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.requestTerminate(1);
                        return;
                    }
                    ++rowOffset;
                    ++row;
                }
            }
        } else {
            int rowOffset = 0;
            int row = y;
            while (rowOffset < h) {
                try {
                    int dupCnt;
                    int javaIndex;
                    this.fos.writeByte(5);
                    this.fos.writeInt(x);
                    this.fos.writeInt(row);
                    int startNonDup = javaIndex = off + scansize * rowOffset;
                    int startDup = javaIndex;
                    int startDupPixel = pixels[javaIndex];
                    int stop = javaIndex + w;
                    while (javaIndex < stop) {
                        int pixel = pixels[javaIndex];
                        if (pixel != startDupPixel) {
                            dupCnt = javaIndex - startDup;
                            if (dupCnt < 3) {
                                startDup = javaIndex;
                                startDupPixel = pixel;
                            } else {
                                if (startNonDup < startDup) {
                                    this.fos.writeByte(7);
                                    this.fos.writeInt(startDup - startNonDup);
                                    while (startNonDup < startDup) {
                                        this.writeIntPixel(model, pixels[startNonDup++]);
                                    }
                                }
                                this.fos.writeByte(6);
                                this.fos.writeInt(dupCnt);
                                this.writeIntPixel(model, startDupPixel);
                                startDup = startNonDup = javaIndex;
                                startDupPixel = pixel;
                            }
                        }
                        ++javaIndex;
                    }
                    dupCnt = javaIndex - startDup;
                    if (dupCnt < 3) {
                        startDup = javaIndex;
                        dupCnt = 0;
                    }
                    if (startNonDup < startDup) {
                        this.fos.writeByte(7);
                        this.fos.writeInt(startDup - startNonDup);
                        while (startNonDup < startDup) {
                            this.writeIntPixel(model, pixels[startNonDup++]);
                        }
                    }
                    if (dupCnt > 0) {
                        this.fos.writeByte(6);
                        this.fos.writeInt(dupCnt);
                        this.writeIntPixel(model, startDupPixel);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.requestTerminate(1);
                    return;
                }
                ++rowOffset;
                ++row;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imageComplete(int status) {
        try {
            ImageProducer producer = null;
            DataOutputStream os = null;
            boolean justClose = false;
            ImageDataCollector imageDataCollector = this;
            synchronized (imageDataCollector) {
                if (this.fProducer == null) {
                    return;
                }
                producer = this.fProducer;
                os = this.fos;
                if (!this.fEndProductionRequested) {
                    switch (status) {
                        case 1: {
                            this.fStatus = 1;
                            break;
                        }
                        case 2: {
                            this.fStatus = 2;
                            break;
                        }
                        case 3: {
                            this.fStatus = 3;
                            break;
                        }
                        case 4: {
                            this.fStatus = 4;
                            break;
                        }
                        case -2: {
                            this.fStatus = -2;
                            break;
                        }
                        default: {
                            this.fStatus = 5;
                            break;
                        }
                    }
                } else {
                    justClose = true;
                }
                this.fEndProductionRequested = false;
                this.fos = null;
            }
            producer.removeConsumer(this);
            try {
                if (!justClose) {
                    os.writeByte(8);
                    os.writeInt(this.fStatus);
                }
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void waitForCompletion() {
        if (this.fStatus == -1) {
            return;
        }
        while (true) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public synchronized boolean isCollecting() {
        return this.fProducer != null;
    }

    public void abort() {
        this.requestTerminate(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestTerminate(final int status) {
        boolean sendNotice = false;
        ImageDataCollector imageDataCollector = this;
        synchronized (imageDataCollector) {
            if (!this.fEndProductionRequested && this.fStatus == 6) {
                this.fEndProductionRequested = true;
                this.fStatus = status;
                sendNotice = true;
            }
        }
        if (sendNotice) {
            try {
                this.fVMServer.doCallback(new ICallbackRunnable(){

                    public Object run(ICallbackHandler handler) throws CommandException {
                        return handler.callbackWithParms(ImageDataCollector.this.fCallbackID, 3, new Object[]{new Integer(status)});
                    }
                });
            }
            catch (CommandException e) {
                e.printStackTrace();
            }
        }
    }
}

