/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.vm;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.eclipse.ve.internal.jfc.vm.PreviewTableModel;

public class JTableManager {
    static /* synthetic */ Class class$0;

    public static void initializeTableModel(JTable jtable) {
        TableModel tm = jtable.getModel();
        Class<?> clazz = tm.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("javax.swing.table.DefaultTableModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2 && tm.getColumnCount() == 0 && tm.getRowCount() == 0) {
            jtable.setModel(new PreviewTableModel());
        }
    }

    public static void addColumnBefore(JTable jtable, TableColumn addColumn, TableColumn beforeColumn) {
        int ndx = JTableManager.indexOfColumn(jtable, beforeColumn);
        jtable.addColumn(addColumn);
        if (ndx != -1) {
            jtable.moveColumn(jtable.getColumnCount() - 1, ndx);
        }
    }

    protected static int indexOfColumn(JTable jtable, TableColumn column) {
        if (column != null) {
            TableColumnModel cm = jtable.getColumnModel();
            Enumeration<TableColumn> e = cm.getColumns();
            int index = -1;
            while (e.hasMoreElements()) {
                ++index;
                if (e.nextElement() != column) continue;
                return index;
            }
            return -1;
        }
        return -1;
    }

    public static void removeAllColumns(JTable jtable) {
        TableColumnModel cm = jtable.getColumnModel();
        while (cm.getColumnCount() > 0) {
            cm.removeColumn(cm.getColumn(0));
        }
    }

    public static void resetHeaderValue(JTable jtable, TableColumn column) {
        int modelColumn = column.getModelIndex();
        String columnName = jtable.getModel().getColumnName(modelColumn);
        column.setHeaderValue(columnName);
    }

    public static Rectangle getColumnRect(JTable jtable, TableColumn column) {
        int i = 0;
        Enumeration<TableColumn> enumer = jtable.getColumnModel().getColumns();
        while (enumer.hasMoreElements()) {
            if (enumer.nextElement() == column) {
                return jtable.getTableHeader().getHeaderRect(i);
            }
            ++i;
        }
        return null;
    }

    public static Object[] getColumnRects(JTable jtable) {
        TableColumnModel columnModel = jtable.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        if (columnCount == 0) {
            return null;
        }
        JTableHeader tableHeader = jtable.getTableHeader();
        ArrayList<Serializable> result = new ArrayList<Serializable>(5 * columnCount);
        int i = 0;
        Enumeration<TableColumn> enumer = columnModel.getColumns();
        while (enumer.hasMoreElements()) {
            TableColumn column = enumer.nextElement();
            result.add(column);
            Rectangle rect = tableHeader.getHeaderRect(i);
            result.add(new Integer(rect.x));
            result.add(new Integer(rect.y));
            result.add(new Integer(rect.width));
            result.add(new Integer(rect.height));
            ++i;
        }
        return result.toArray();
    }
}

