/* @(#) DisplayModeEditor.java        Ver 1.0    01,April,1998
 *
 * Copyright (c) 1998 International Business Machines.
 * All Rights Reserved.
 *
 * Author : Sunanda Bera & P.Sushma
 * Last Modified : 01,April,1998
 *
 * Purpose : Defines class DisplayModeEditor.
 *
 *
 * Revision History 
 * ======== ======= 
 *
 * Date        By            Description
 * ----        --            -----------
 *
 *
 */
package com.ibm.clock.editors;

import com.ibm.clock.IClock;

import java.beans.PropertyEditorSupport;

public class DisplayModeEditor
extends PropertyEditorSupport
{
    private static final String [] NAMES = {
            "DIGITAL",
            "ANALOG" };
    private static final int [] VALUES = {
            IClock.DIGITAL,
            IClock.ANALOG };
    
    private int getIndex( int value )
    {
        int index = -1;
        for( int i = 0; i < VALUES.length; i++ )
        {
            if( VALUES[i] == value )
            {
                index = i;
                break;
            }//end if
        }//end for
        
        return index;
    }//end of getIndex
    
    private int getIndex( String name )
    {
        int index = -1;
        for( int i = 0; i < NAMES.length; i++ )
        {
            if( NAMES[i].equals( name ) )
            {
                index = i;
                break;
            }//end if
        }//end for
        
        return index;        
    }//end of getName
    
    public String getAsText()
    {
        int value = ( ( Integer )getValue() ).intValue();
        int index = getIndex( value );
        
        return NAMES[index];
    }//end of getAsText
    
    public String [] getTags()
    {
        return NAMES;
    }//end of getTags
    
    public boolean supportsCustomEditor()
    {
        return false;
    }//end supportsCustomEditor
    
    public void setAsText( String name )
    {
        int index = getIndex( name );
        int value = VALUES[index];
        
        setValue( new Integer( value ) );
    }//end of setAsText
    
    public String getJavaInitializationString()
    {
        int value = ( (Integer)getValue() ).intValue();
        return "" + value;
    }//end of getJavaInitializationString
}//end of DisplayModeEditor
