package com.ibm.calendar.editors;

import java.awt.*;
import java.text.DateFormat;
import java.util.*;
import java.beans.*;

public class DateEditor extends PropertyEditorSupport
{  
   public String getAsText()
   {  
		DateFormat df = DateFormat.getDateInstance(DateFormat.LONG);
		return df.format((java.util.Date) getValue());
   }                  
public Component getCustomEditor()
   {  return new DateEditorPanel(this);
   }                  
public String getJavaInitializationString() {
	 return "new java.util.Date(" + ((java.util.Date) getValue()).getTime()+ "L)";
}
   public boolean isPaintable()
   {  return true;
   }                  
   public void paintValue(Graphics g, Rectangle box)
   {  
	  String s = ((Date)getValue()).toString();
	  FontMetrics fm = g.getFontMetrics();
	  int x = box.x;
	  int y = box.y + (box.height - fm.getHeight()) / 2
		 + fm.getAscent() - 2;

	  java.util.Calendar tempCal = java.util.Calendar.getInstance();
	  tempCal.setTime((Date)getValue());
	  	
// in the case of setting a holiday, getValue() may return "Mar 3 04:05:06 1799". We only set the choices when this is not the case.
	  if (!(tempCal.get(java.util.Calendar.YEAR) == -100 && tempCal.get(java.util.Calendar.MONTH)== 2 
   		 && tempCal.get(java.util.Calendar.DATE) == 3    && tempCal.get(java.util.Calendar.HOUR) == 4
		 && tempCal.get(java.util.Calendar.MINUTE)== 5   && tempCal.get(java.util.Calendar.SECOND) == 6))
	  		g.drawString(s, x, y);
	  else
	  		g.drawString("no holiday added yet", x, y);
   }                                 
   public boolean supportsCustomEditor()
   {  return true;
   }                  
}