/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.ui;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jem.internal.beaninfo.ui.BeanInfoUIMessages;
import org.eclipse.jem.internal.beaninfo.ui.IStatusChangeListener;
import org.eclipse.jem.internal.beaninfo.ui.StatusHelper;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class VariableSelectionBlock {
    private List fExistingPaths;
    private Label variableFieldLabel;
    private Text variableFieldText;
    private Button variableFieldButton;
    private String variableFieldTextContent;
    private Label extensionFieldLabel;
    private Text extensionFieldText;
    private Button extensionFieldButton;
    private String extensionFieldTextContent;
    private CLabel fFullPath;
    private IStatus fVariableStatus;
    private IStatus fExistsStatus;
    private IStatus fExtensionStatus;
    private String fVariable;
    private IStatusChangeListener fContext;
    private boolean fIsEmptyAllowed;

    public VariableSelectionBlock(IStatusChangeListener context, List existingPaths, IPath varPath, String lastVarSelection, boolean emptyAllowed) {
        this.fContext = context;
        this.fExistingPaths = existingPaths;
        this.fIsEmptyAllowed = emptyAllowed;
        this.fExistsStatus = StatusHelper.OK_STATUS;
        if (varPath != null) {
            this.variableFieldTextContent = varPath.segment(0);
            this.extensionFieldTextContent = varPath.removeFirstSegments(1).toString();
        } else {
            this.variableFieldTextContent = "";
            this.extensionFieldTextContent = "";
        }
        this.updateFullTextField();
        this.fVariableStatus = this.variableUpdated();
        this.fExtensionStatus = this.extensionUpdated();
    }

    public IPath getVariablePath() {
        if (this.fVariable != null) {
            return new Path(this.fVariable).append(this.extensionFieldTextContent);
        }
        return null;
    }

    public IPath getResolvedPath() {
        IPath entryPath;
        if (this.fVariable != null && (entryPath = JavaCore.getClasspathVariable((String)this.fVariable)) != null) {
            return entryPath.append(this.extensionFieldTextContent);
        }
        return null;
    }

    public void setFocus(Display display) {
        display.asyncExec(new Runnable(){

            public void run() {
                VariableSelectionBlock.this.variableFieldText.setFocus();
            }
        });
    }

    public Control createControl(Composite parent) {
        Composite inner = new Composite(parent, 0);
        inner.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(1808);
        inner.setLayoutData((Object)gd);
        this.variableFieldLabel = new Label(inner, 0);
        this.variableFieldLabel.setText(BeanInfoUIMessages.VariableSelectionBlock_variable_label);
        this.variableFieldLabel.setLayoutData((Object)new GridData());
        this.variableFieldText = new Text(inner, 2052);
        this.variableFieldText.setText(this.variableFieldTextContent);
        gd = new GridData(768);
        gd.widthHint = 200;
        this.variableFieldText.setLayoutData((Object)gd);
        this.variableFieldText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VariableSelectionBlock.this.variableFieldTextContent = VariableSelectionBlock.this.variableFieldText.getText();
                VariableSelectionBlock.this.fVariableStatus = VariableSelectionBlock.this.variableUpdated();
                VariableSelectionBlock.this.fExistsStatus = VariableSelectionBlock.this.getExistsStatus();
                VariableSelectionBlock.this.updateFullTextField();
                VariableSelectionBlock.this.fContext.statusChanged(StatusHelper.getMostSevere(new IStatus[]{VariableSelectionBlock.this.fVariableStatus, VariableSelectionBlock.this.fExtensionStatus, VariableSelectionBlock.this.fExistsStatus}));
            }
        });
        this.variableFieldButton = new Button(inner, 8);
        this.variableFieldButton.setText(BeanInfoUIMessages.VariableSelectionBlock_variable_button);
        this.variableFieldButton.setLayoutData((Object)new GridData());
        this.variableFieldButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String variable = VariableSelectionBlock.this.chooseVariable();
                if (variable != null) {
                    VariableSelectionBlock.this.variableFieldText.setText(variable);
                }
            }
        });
        this.extensionFieldLabel = new Label(inner, 0);
        this.extensionFieldLabel.setText(BeanInfoUIMessages.VariableSelectionBlock_extension_label);
        this.extensionFieldLabel.setLayoutData((Object)new GridData());
        this.extensionFieldText = new Text(inner, 2052);
        this.extensionFieldText.setText(this.variableFieldTextContent);
        this.extensionFieldText.setLayoutData((Object)new GridData(768));
        this.extensionFieldText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VariableSelectionBlock.this.extensionFieldTextContent = VariableSelectionBlock.this.extensionFieldText.getText();
                VariableSelectionBlock.this.fExtensionStatus = VariableSelectionBlock.this.extensionUpdated();
                VariableSelectionBlock.this.fExistsStatus = VariableSelectionBlock.this.getExistsStatus();
                VariableSelectionBlock.this.updateFullTextField();
                VariableSelectionBlock.this.fContext.statusChanged(StatusHelper.getMostSevere(new IStatus[]{VariableSelectionBlock.this.fVariableStatus, VariableSelectionBlock.this.fExtensionStatus, VariableSelectionBlock.this.fExistsStatus}));
            }
        });
        this.extensionFieldButton = new Button(inner, 8);
        this.extensionFieldButton.setText(BeanInfoUIMessages.VariableSelectionBlock_extension_button);
        this.extensionFieldButton.setLayoutData((Object)new GridData());
        this.extensionFieldButton.setEnabled(this.fVariable != null);
        this.extensionFieldButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPath filePath = VariableSelectionBlock.this.chooseExtJar();
                if (filePath != null) {
                    VariableSelectionBlock.this.extensionFieldText.setText(filePath.toString());
                }
            }
        });
        Label label = new Label(inner, 16384);
        label.setLayoutData((Object)new GridData());
        label.setText(BeanInfoUIMessages.VariableSelectionBlock_fullpath_label);
        this.fFullPath = new CLabel(inner, 0);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.fFullPath.setLayoutData((Object)gd);
        this.updateFullTextField();
        this.setFocus(parent.getDisplay());
        return inner;
    }

    private IStatus variableUpdated() {
        this.fVariable = null;
        IStatus status = StatusHelper.OK_STATUS;
        String name = this.variableFieldTextContent;
        if (name.length() == 0) {
            if (!this.fIsEmptyAllowed) {
                status = StatusHelper.createStatus(4, BeanInfoUIMessages.VariableSelectionBlock_error_entername_ERROR_);
            } else {
                this.fVariable = "";
            }
        } else if (JavaCore.getClasspathVariable((String)name) == null) {
            status = StatusHelper.createStatus(4, BeanInfoUIMessages.VariableSelectionBlock_error_namenotexists_ERROR_);
        } else {
            this.fVariable = name;
        }
        if (this.extensionFieldButton != null) {
            this.extensionFieldButton.setEnabled(this.fVariable != null);
        }
        return status;
    }

    private IStatus extensionUpdated() {
        IStatus status = StatusHelper.OK_STATUS;
        String extension = this.extensionFieldTextContent;
        if (extension.length() > 0 && !Path.ROOT.isValidPath(extension)) {
            status = StatusHelper.createStatus(4, BeanInfoUIMessages.VariableSelectionBlock_error_invalidextension_ERROR_);
        }
        return status;
    }

    private IStatus getExistsStatus() {
        IStatus status = StatusHelper.OK_STATUS;
        IPath path = this.getResolvedPath();
        if (path != null) {
            if (this.findPath(path)) {
                status = StatusHelper.createStatus(4, BeanInfoUIMessages.VariableSelectionBlock_error_pathexists_ERROR_);
            } else if (!path.toFile().isFile()) {
                status = StatusHelper.createStatus(2, BeanInfoUIMessages.VariableSelectionBlock_warning_pathnotexists_WARN_);
            }
        } else {
            status = StatusHelper.createStatus(2, BeanInfoUIMessages.VariableSelectionBlock_warning_pathnotexists_WARN_);
        }
        return status;
    }

    private boolean findPath(IPath path) {
        int i = this.fExistingPaths.size() - 1;
        while (i >= 0) {
            IPath curr = (IPath)this.fExistingPaths.get(i);
            if (curr.equals((Object)path)) {
                return true;
            }
            --i;
        }
        return false;
    }

    private void updateFullTextField() {
        if (this.fFullPath != null && !this.fFullPath.isDisposed()) {
            IPath resolvedPath = this.getResolvedPath();
            if (resolvedPath != null) {
                this.fFullPath.setText(resolvedPath.toOSString());
            } else {
                this.fFullPath.setText("");
            }
        }
    }

    private Shell getShell() {
        if (this.fFullPath != null) {
            return this.fFullPath.getShell();
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static boolean isArchivePath(IPath path) {
        String[] archiveExtensions = new String[]{"jar", "zip"};
        String ext = path.getFileExtension();
        if (ext != null && ext.length() != 0) {
            int i = 0;
            while (i < archiveExtensions.length) {
                if (ext.equalsIgnoreCase(archiveExtensions[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private IPath chooseExtJar() {
        String lastUsedPath = "";
        IPath entryPath = this.getResolvedPath();
        if (entryPath != null) {
            lastUsedPath = VariableSelectionBlock.isArchivePath(entryPath) ? entryPath.removeLastSegments(1).toOSString() : entryPath.toOSString();
        }
        FileDialog dialog = new FileDialog(this.getShell(), 4);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        dialog.setFilterPath(lastUsedPath);
        dialog.setText(BeanInfoUIMessages.VariableSelectionBlock_ExtJarDialog_title);
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        IPath resPath = new Path(res).makeAbsolute();
        IPath varPath = JavaCore.getClasspathVariable((String)this.fVariable);
        if (!varPath.isPrefixOf(resPath)) {
            return new Path(resPath.lastSegment());
        }
        return resPath.removeFirstSegments(varPath.segmentCount()).setDevice(null);
    }

    private String chooseVariable() {
        IPath[] varPaths = BuildPathDialogAccess.chooseVariableEntries((Shell)this.variableFieldButton.getShell(), (IPath[])new IPath[0]);
        String variable = null;
        if (varPaths != null && varPaths.length > 0) {
            variable = varPaths[0].toString();
        }
        return variable;
    }
}

