/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.commands;

import java.util.Collections;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.gef.commands.Command;
import org.eclipse.ve.internal.cde.commands.ApplyKeyedValueCommand;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.AnnotationPolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.propertysheet.common.commands.CommandWrapper;

public class ApplyAnnotationCommand
extends CommandWrapper {
    protected Object modelObject;
    protected EditDomain domain;
    protected BasicEMap.Entry newSetting;

    public ApplyAnnotationCommand(Object modelObject, EditDomain domain) {
        this.modelObject = modelObject;
        this.domain = domain;
    }

    public ApplyAnnotationCommand(Object modelObject, BasicEMap.Entry newValue, EditDomain domain) {
        this(modelObject, domain);
        this.setValue(newValue);
    }

    public void setValue(BasicEMap.Entry newSetting) {
        this.newSetting = newSetting;
    }

    protected boolean prepare() {
        return this.modelObject != null && this.domain != null && this.newSetting != null;
    }

    public void execute() {
        if (this.command != null) {
            super.execute();
        }
        CommandBuilder cb = new CommandBuilder(null);
        Annotation annotation = this.domain.getAnnotationLinkagePolicy().getAnnotation(this.modelObject);
        boolean createdAnnotation = false;
        if (annotation == null) {
            createdAnnotation = true;
            annotation = AnnotationPolicy.createAnnotation(this.modelObject);
        }
        ApplyKeyedValueCommand c = new ApplyKeyedValueCommand();
        c.setTarget(annotation);
        c.setValue(this.newSetting);
        cb.append((Command)c);
        if (createdAnnotation) {
            cb.append(AnnotationPolicy.getDefaultAddAnnotationsCommand(Collections.singletonList(annotation), this.domain));
            cb.append(AnnotationPolicy.getApplyModelToAnnotationCommand(this.modelObject, annotation, this.domain.getAnnotationLinkagePolicy()));
        }
        this.command = cb.getCommand();
        this.command.execute();
    }
}

