/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.commands;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.ve.internal.cde.commands.AbstractAttributeCommand;
import org.eclipse.ve.internal.cde.commands.ApplyAttributeSettingCommand;
import org.eclipse.ve.internal.cde.commands.ApplyAttributeSettingListCommand;
import org.eclipse.ve.internal.cde.commands.ApplyKeyedValueCommand;
import org.eclipse.ve.internal.cde.commands.CancelAttributeSettingCommand;
import org.eclipse.ve.internal.cde.commands.CancelKeyedValueCommand;
import org.eclipse.ve.internal.cde.commands.ClearAttributeSettingListCommand;
import org.eclipse.ve.internal.cde.commands.ReplaceAttributeSettingCommand;
import org.eclipse.ve.internal.cdm.KeyedValueHolder;
import org.eclipse.ve.internal.propertysheet.command.ForwardUndoCompoundCommand;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class CommandBuilder {
    private CompoundCommand cmpCmd;
    private boolean appendAndExecute;
    private boolean dead;
    private String reasonDead;

    public CommandBuilder(String name, boolean regularCmd) {
        this.cmpCmd = regularCmd ? new CompoundCommand(name) : new ForwardUndoCompoundCommand(name);
    }

    public CommandBuilder(String name) {
        this(name, true);
    }

    public CommandBuilder() {
        this(null, true);
    }

    public CommandBuilder(boolean regularCmd) {
        this(null, regularCmd);
    }

    public boolean isEmpty() {
        return this.cmpCmd.isEmpty();
    }

    public final boolean isDead() {
        return this.dead;
    }

    public final void markDead() {
        if (!this.dead) {
            this.dead = true;
            if (this.appendAndExecute && !this.cmpCmd.isEmpty()) {
                this.cmpCmd.undo();
                this.cmpCmd.dispose();
            }
            this.cmpCmd.append((Command)UnexecutableCommand.INSTANCE);
        }
    }

    public final void markDead(String reason) {
        if (!this.dead) {
            this.reasonDead = reason;
            this.markDead();
        } else if (this.reasonDead == null) {
            this.reasonDead = reason;
        }
    }

    public final String getReason() {
        return this.reasonDead;
    }

    public Command getCommand() {
        if (!this.isDead()) {
            return this.cmpCmd.isEmpty() ? null : this.cmpCmd.unwrap();
        }
        return UnexecutableCommand.INSTANCE;
    }

    public CompoundCommand getCompoundCommand() {
        return this.cmpCmd;
    }

    public void append(Command cmd) {
        this.internalAppend(cmd);
    }

    public void applyAttributeSetting(EObject target, EStructuralFeature feature, Object value, int index) {
        this.internalAppend(this.internalApplyAttributeSetting(target, feature, value, index));
    }

    protected Command internalApplyAttributeSetting(EObject target, EStructuralFeature feature, Object value, int index) {
        ApplyAttributeSettingCommand applyCmd = new ApplyAttributeSettingCommand();
        applyCmd.setTarget(target);
        applyCmd.setAttribute(feature);
        applyCmd.setAttributeSettingValue(value);
        applyCmd.setInsertionIndex(index);
        return applyCmd;
    }

    public void applyAttributeSetting(EObject target, EStructuralFeature feature, Object value, Object before) {
        this.internalAppend(this.internalApplyAttributeSetting(target, feature, value, before));
    }

    protected Command internalApplyAttributeSetting(EObject target, EStructuralFeature feature, Object value, Object before) {
        ApplyAttributeSettingCommand applyCmd = new ApplyAttributeSettingCommand();
        applyCmd.setTarget(target);
        applyCmd.setAttribute(feature);
        applyCmd.setAttributeSettingValue(value);
        applyCmd.setInsertBeforeValue(before);
        return applyCmd;
    }

    public void applyAttributeSettings(EObject target, EStructuralFeature feature, List values, int index) {
        this.internalAppend(this.internalApplyAttributeSettings(target, feature, values, index));
    }

    protected Command internalApplyAttributeSettings(EObject target, EStructuralFeature feature, List values, int index) {
        ApplyAttributeSettingCommand applyCmd = new ApplyAttributeSettingCommand();
        applyCmd.setTarget(target);
        applyCmd.setAttribute(feature);
        applyCmd.setAttributeSettingValue(values);
        applyCmd.setInsertionIndex(index);
        return applyCmd;
    }

    public void applyAttributeSettings(EObject target, EStructuralFeature feature, List values, Object before) {
        this.internalAppend(this.internalApplyAttributeSettings(target, feature, values, before));
    }

    protected Command internalApplyAttributeSettings(EObject target, EStructuralFeature feature, List values, Object before) {
        ApplyAttributeSettingCommand applyCmd = new ApplyAttributeSettingCommand();
        applyCmd.setTarget(target);
        applyCmd.setAttribute(feature);
        applyCmd.setAttributeSettingValue(values);
        applyCmd.setInsertBeforeValue(before);
        return applyCmd;
    }

    public void applyAttributeSetting(EObject target, EStructuralFeature feature, Object value) {
        this.internalAppend(this.internalApplyAttributeSetting(target, feature, value));
    }

    protected Command internalApplyAttributeSetting(EObject target, EStructuralFeature feature, Object value) {
        ApplyAttributeSettingCommand applyCmd = new ApplyAttributeSettingCommand();
        applyCmd.setTarget(target);
        applyCmd.setAttribute(feature);
        applyCmd.setAttributeSettingValue(value);
        return applyCmd;
    }

    public void applyAttributeSetting(KeyedValueHolder holder, BasicEMap.Entry value) {
        ApplyKeyedValueCommand applyCmd = new ApplyKeyedValueCommand();
        applyCmd.setTarget(holder);
        applyCmd.setValue(value);
        this.internalAppend((Command)applyCmd);
    }

    public void applyAttributeSettings(EObject target, EStructuralFeature feature, List values) {
        this.internalAppend(this.internalApplyAttributeSettings(target, feature, values));
    }

    protected Command internalApplyAttributeSettings(EObject target, EStructuralFeature feature, List values) {
        ApplyAttributeSettingCommand applyCmd = new ApplyAttributeSettingCommand();
        applyCmd.setTarget(target);
        applyCmd.setAttribute(feature);
        applyCmd.setAttributeSettingValue(values);
        return applyCmd;
    }

    public void replaceEntireAttributeSettingList(EObject target, EStructuralFeature feature, List list) {
        this.internalAppend(this.internalReplaceEntireAttributeSettingList(target, feature, list));
    }

    protected Command internalReplaceEntireAttributeSettingList(EObject target, EStructuralFeature feature, List list) {
        ApplyAttributeSettingListCommand applyCmd = new ApplyAttributeSettingListCommand();
        applyCmd.setTarget(target);
        applyCmd.setAttribute(feature);
        applyCmd.setAttributeSettingValue(list);
        return applyCmd;
    }

    public void cancelAttributeSetting(EObject target, EStructuralFeature feature) {
        AbstractAttributeCommand cmd = !feature.isMany() ? new CancelAttributeSettingCommand() : new ClearAttributeSettingListCommand();
        cmd.setTarget(target);
        cmd.setAttribute(feature);
        this.internalAppend((Command)cmd);
    }

    public void cancelAttributeSetting(EObject target, EStructuralFeature feature, Object value) {
        CancelAttributeSettingCommand cancelCmd = new CancelAttributeSettingCommand();
        cancelCmd.setTarget(target);
        cancelCmd.setAttribute(feature);
        cancelCmd.setAttributeSettingValue(value);
        this.internalAppend((Command)cancelCmd);
    }

    public void cancelKeyedAttributeSetting(KeyedValueHolder holder, Object key) {
        CancelKeyedValueCommand cancelCmd = new CancelKeyedValueCommand();
        cancelCmd.setTarget(holder);
        cancelCmd.setKey(key);
        this.internalAppend((Command)cancelCmd);
    }

    public void cancelAttributeSettings(EObject target, EStructuralFeature feature, List values) {
        CancelAttributeSettingCommand cancelCmd = new CancelAttributeSettingCommand();
        cancelCmd.setTarget(target);
        cancelCmd.setAttribute(feature);
        cancelCmd.setAttributeSettingValue(values);
        this.internalAppend((Command)cancelCmd);
    }

    public void cancelGroupAttributeSetting(List targets, EStructuralFeature feature) {
        Iterator iter = targets.iterator();
        while (iter.hasNext()) {
            EObject object = (EObject)iter.next();
            this.cancelAttributeSetting(object, feature);
        }
    }

    public void replaceAttributeSetting(EObject target, EStructuralFeature feature, Object newValue, int index) {
        this.internalAppend(this.internalReplaceAttributeSetting(target, feature, newValue, index));
    }

    protected Command internalReplaceAttributeSetting(EObject target, EStructuralFeature feature, Object newValue, int index) {
        ReplaceAttributeSettingCommand replaceCmd = new ReplaceAttributeSettingCommand();
        replaceCmd.setTarget(target);
        replaceCmd.setAttribute(feature);
        replaceCmd.setAttributeSettingValue(newValue);
        replaceCmd.setReplaceIndex(index);
        return replaceCmd;
    }

    protected void internalAppend(Command cmd) {
        if (cmd != null && !this.isDead()) {
            if (cmd.canExecute()) {
                if (this.appendAndExecute) {
                    this.cmpCmd.appendAndExecute(cmd);
                } else {
                    this.cmpCmd.append(cmd);
                }
            } else {
                this.markDead();
            }
        }
    }

    public void setExecuteAndAppend(boolean appendAndExecute) {
        if (!this.isDead() && (appendAndExecute || this.appendAndExecute && this.cmpCmd.isEmpty())) {
            if (!this.appendAndExecute && !this.cmpCmd.isEmpty()) {
                this.cmpCmd.execute();
            }
            this.appendAndExecute = appendAndExecute;
        }
    }

    public boolean isExecuteAndAppend() {
        return this.appendAndExecute;
    }
}

