/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.propertysheet;

import java.util.Arrays;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ve.internal.propertysheet.AbstractPropertySheetEntry;
import org.eclipse.ve.internal.propertysheet.IDescriptorPropertySheetEntry;

public class StandardPropertySheetEntry
extends AbstractPropertySheetEntry {
    public StandardPropertySheetEntry(StandardPropertySheetEntry parent, IPropertySourceProvider provider) {
        super(parent, provider);
    }

    protected IDescriptorPropertySheetEntry createPropertySheetEntry(IPropertySourceProvider provider) {
        return new StandardPropertySheetEntry(this, provider);
    }

    protected boolean isPropertySet() {
        IPropertySource[] propSources = this.parent.getPropertySources();
        return propSources[0].isPropertySet(this.fDescriptors[0].getId());
    }

    protected boolean primResetPropertyValues() {
        IPropertySource[] propSources = this.parent.getPropertySources();
        boolean changed = false;
        int i = 0;
        while (i < propSources.length) {
            Object id = this.fDescriptors[i].getId();
            if (propSources[i].isPropertySet(id)) {
                propSources[i].resetPropertyValue(id);
                changed = true;
            }
            ++i;
        }
        ((StandardPropertySheetEntry)this.parent).childChanged();
        return changed;
    }

    public void childChanged() {
        if (this.parent != null) {
            this.primApplyValues();
        }
    }

    protected void primApplyValues() {
        IPropertySource[] propSources = this.parent.getPropertySources();
        int i = 0;
        while (i < propSources.length) {
            Object id = this.fDescriptors[i].getId();
            propSources[i].setPropertyValue(id, this.getEditValue(i));
            ++i;
        }
        ((StandardPropertySheetEntry)this.parent).childChanged();
    }

    protected Object[] primGetValues() {
        IPropertySource[] propSources = this.parent.getPropertySources();
        Object[] newValues = new Object[propSources.length];
        int i = 0;
        while (i < propSources.length) {
            Object id = this.fDescriptors[i].getId();
            if (propSources[i].isPropertySet(id)) {
                newValues[i] = propSources[i].getPropertyValue(id);
            }
            ++i;
        }
        return newValues;
    }

    protected void primFillValues(Object newEditValue, Object[] valuesArray) {
        Arrays.fill(valuesArray, newEditValue);
    }
}

