/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 *  $RCSfile: GridLayoutNumColumnsPropertyDescriptor.java,v $
 *  $Revision: 1.1 $  $Date: 2005/12/09 22:44:19 $ 
 */
package org.eclipse.ve.internal.swt;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.views.properties.IPropertySource;

import org.eclipse.jem.internal.instantiation.ImplicitAllocation;
import org.eclipse.jem.internal.instantiation.base.*;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;

import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.InverseMaintenanceAdapter;

import org.eclipse.ve.internal.java.core.*;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;

import org.eclipse.ve.internal.propertysheet.command.ICommandPropertyDescriptor;
 

/**
 * Property descriptor for GridLayout numCols settings. This adapter makes sure that when setting a numcol value that it 
 * will create/delete fillers and columns as needed.
 *  
 * @since 1.2.0
 */
public class GridLayoutNumColumnsPropertyDescriptor extends BeanPropertyDescriptorAdapter implements ICommandPropertyDescriptor {

	/* (non-Javadoc)
	 * @see org.eclipse.ve.internal.propertysheet.command.ICommandPropertyDescriptor#setValue(org.eclipse.ui.views.properties.IPropertySource, java.lang.Object)
	 */
	public Command setValue(IPropertySource source, Object setValue) {
		IJavaObjectInstance gridlayout = (IJavaObjectInstance) source.getEditableValue();
		IBeanProxyHost griddataProxyHost = BeanProxyUtilities.getBeanProxyHost(gridlayout);	
		Object oldNumColsValue = source.getPropertyValue(getTarget());
		IJavaInstance oldNumCols = (IJavaInstance) (oldNumColsValue instanceof IPropertySource ? (IJavaObjectInstance) ((IPropertySource) oldNumColsValue).getEditableValue() : oldNumColsValue);
		EditDomain domain = griddataProxyHost.getBeanProxyDomain().getEditDomain();
		
		if (oldNumCols != setValue) {
			IBeanProxy numColsValue = BeanProxyUtilities.getBeanProxy((IJavaInstance) setValue);
			if (numColsValue instanceof IIntegerBeanProxy) {
				CompositeContainerPolicy cp = new CompositeContainerPolicy(domain);
				CommandBuilder cb = new CommandBuilder();
				// KLUDGE: We need to get the composite that the gridlayout (which is the source) is set on.
				// But the gridlayout may be implicit. So if not implicit, we get the composite through the inverse adapter. GridLayout is not meant
				// to be shared so we will use the first one for the layout setting. If implicit, then we get the composite through
				// the implicit allocation. If we don't have the composite we can't tell
				// what other controls will be affected by the numCols request and so the helper can't create the correct commands.
				IJavaObjectInstance composite;
				boolean implicitGridLayout = gridlayout.isImplicitAllocation();
				if (!implicitGridLayout) {
					// It is set, so we can use the inverse adapter.
					composite = (IJavaObjectInstance) InverseMaintenanceAdapter.getFirstReferencedBy(gridlayout, 
							(EReference) JavaInstantiation.getSFeature(JavaEditDomainHelper.getResourceSet(domain), 
									SWTConstants.SF_COMPOSITE_LAYOUT)); 
				} else {
					// It is implicit, so we can get it out of the allocation. We need to do this when implicit because it could of
					// been just a fluffed up entry for the property sheet. In that case it will not have a composite through the inverse adapter.
					composite = (IJavaObjectInstance) ((ImplicitAllocation) gridlayout.getAllocation()).getParent();
					
					// KLUDGE: We also have to morph it into an explicit. We assume it uses default ctor.
					// This is because by default there is no implicit gridlayout. The gridlayout will fluff one up
					// after it runs once. But in real code it can't be accessed implicitly during initialization because
					// it will still be null. Also we don't handle implicit correctly AND we need to apply the numCol
					// to this gridlayout, NOT the fluffed up one that the helper would normally do.
					// By canceling the allocation, it becomes a create with null ctor. And it will then promote correctly.
					cb.cancelAttributeSetting(gridlayout, JavaInstantiation.getAllocationFeature(gridlayout));
				}
				
				if (composite != null) {
					cp.setContainer(composite);
					GridLayoutPolicyHelper helper = new GridLayoutPolicyHelper(cp);
					helper.startRequest();
					helper.changeNumberOfColumns(((IIntegerBeanProxy) numColsValue).intValue());
					cb.append(helper.stopRequest());
					return cb.getCommand();
				}
			}
		}
		
		// Same value, so we just apply the new setting so we have a touch.
		RuledCommandBuilder cbld = new RuledCommandBuilder(domain);
		cbld.applyAttributeSetting(gridlayout, (EStructuralFeature) getTarget(), setValue);
		return cbld.getCommand();
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ve.internal.propertysheet.command.ICommandPropertyDescriptor#resetValue(org.eclipse.ui.views.properties.IPropertySource)
	 */
	public Command resetValue(IPropertySource source) {
		// Resetting on numcols doesn't mean anything. It is determined graphically.
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.impl.AdapterImpl#setTarget(org.eclipse.emf.common.notify.Notifier)
	 */
	public void setTarget(Notifier newTarget) {
		super.setTarget(newTarget);
	}
}
