/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 *  $RCSfile: ConcreteEditorPart.java,v $
 *  $Revision: 1.1 $  $Date: 2005/06/15 20:19:21 $ 
 */
package org.eclipse.ve.internal.jface.targetvm;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.*;
import org.eclipse.ui.part.EditorPart;
 

/**
 * This is a dummy subclass of EditorPart used by EditorPartProxyAdapter when a EditorPart subclass is being edited
 * The Visual Editor instantiates the superclass of the class being edited as its prototype instance for the bean proxy
 * however because EditorPart is abstract and its immediate superclass WorkbenchPart also is this means the closest
 * non-abstract class is Object.
 * ConcreteEditorPart therefore is used if EditorPartProxyAdapter is unable to instantiate a class that inherits from
 * EditorPart 
 * @since 1.1.0
 */
public class ConcreteEditorPart extends EditorPart {

	/**
	 * 
	 * 
	 * @since 1.1.0
	 */
	public ConcreteEditorPart() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.part.EditorPart#doSave(org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void doSave(IProgressMonitor monitor) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.part.EditorPart#doSaveAs()
	 */
	public void doSaveAs() {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.part.EditorPart#init(org.eclipse.ui.IEditorSite, org.eclipse.ui.IEditorInput)
	 */
	public void init(IEditorSite site, IEditorInput input) throws PartInitException {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.part.EditorPart#isDirty()
	 */
	public boolean isDirty() {
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.part.EditorPart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.part.WorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createPartControl(Composite parent) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.part.WorkbenchPart#setFocus()
	 */
	public void setFocus() {
	}

}
