/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.cdm.dept.property;

import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.examples.cdm.dept.Company;
import org.eclipse.ve.examples.cdm.dept.Department;
import org.eclipse.ve.examples.cdm.dept.property.DepartmentPropertySource;
import org.eclipse.ve.examples.cdm.dept.property.PropertySupport;
import org.eclipse.ve.examples.cdm.dept.property.UniqueEmployeeName;
import org.eclipse.ve.internal.propertysheet.command.SetPropertyValueCommand;
import org.eclipse.ve.internal.propertysheet.common.commands.CommandWrapper;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class UniqueDepartmentName
extends CommandWrapper {
    protected Company company;
    protected List departments;

    public UniqueDepartmentName(Company company, List departments) {
        this.company = company;
        this.departments = departments;
    }

    protected boolean prepare() {
        return true;
    }

    public void execute() {
        CompoundCommand c = new CompoundCommand();
        Iterator deptItr = this.departments.iterator();
        while (deptItr.hasNext()) {
            Department dept = (Department)deptItr.next();
            String newName = PropertySupport.getUniqueDepartmentName(this.company, dept.getDepartmentName());
            if (!newName.equals(dept.getDepartmentName())) {
                SetPropertyValueCommand pcmd = new SetPropertyValueCommand();
                pcmd.setTarget((IPropertySource)new DepartmentPropertySource(dept));
                pcmd.setPropertyId((Object)"deptname");
                pcmd.setPropertyValue((Object)newName);
                c.append((Command)pcmd);
            }
            c.append((Command)new UniqueEmployeeName(this.company, dept.getEmployees()));
        }
        if (!c.isEmpty()) {
            this.command = c.unwrap();
            this.command.execute();
        }
    }

    public void undo() {
        if (this.command != null) {
            super.undo();
        }
    }
}

