/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.cdm.dept.property;

import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ve.examples.cdm.dept.Company;
import org.eclipse.ve.examples.cdm.dept.Employee;
import org.eclipse.ve.examples.cdm.dept.property.PropertySupport;
import org.eclipse.ve.internal.propertysheet.command.SetPropertyValueCommand;
import org.eclipse.ve.internal.propertysheet.common.commands.CommandWrapper;

public class UniqueEmployeeName
extends CommandWrapper {
    protected Company company;
    protected List employees;

    public UniqueEmployeeName(Company company, List employees) {
        this.company = company;
        this.employees = employees;
    }

    protected boolean prepare() {
        return true;
    }

    public void execute() {
        CompoundCommand cc = new CompoundCommand();
        Iterator itr = this.employees.iterator();
        while (itr.hasNext()) {
            Employee employee = (Employee)itr.next();
            String newName = PropertySupport.getUniqueEmployeeName(this.company, employee.getName());
            if (newName.equals(employee.getName())) continue;
            SetPropertyValueCommand pcmd = new SetPropertyValueCommand();
            pcmd.setTarget(PropertySupport.getPropertySource(employee));
            pcmd.setPropertyId((Object)"name");
            pcmd.setPropertyValue((Object)newName);
            cc.add((Command)pcmd);
        }
        this.command = cc.unwrap();
        this.command.execute();
    }

    public void undo() {
        if (this.command != null) {
            super.undo();
        }
    }
}

