/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.cdm.dept.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.ve.examples.cdm.dept.Company;
import org.eclipse.ve.examples.cdm.dept.Department;
import org.eclipse.ve.examples.cdm.dept.Employee;
import org.eclipse.ve.examples.cdm.dept.property.PropertySupport;
import org.eclipse.ve.examples.cdm.dept.property.UniqueDepartmentName;
import org.eclipse.ve.examples.cdm.dept.ui.AddDepartmentsCommand;
import org.eclipse.ve.examples.cdm.dept.ui.CompanyAnnotationLinkagePolicy;
import org.eclipse.ve.examples.cdm.dept.ui.RemoveDepartmentsCommand;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.AnnotationLinkagePolicy;
import org.eclipse.ve.internal.cde.core.AnnotationPolicy;
import org.eclipse.ve.internal.cde.core.ContainerPolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.cdm.DiagramData;
import org.eclipse.ve.internal.propertysheet.command.RestoreDefaultPropertyValueCommand;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class CompanyContainerPolicy
extends ContainerPolicy {
    public CompanyContainerPolicy(EditDomain domain) {
        super(domain);
    }

    public ContainerPolicy.Result getAddCommand(List children, Object position) {
        ContainerPolicy.Result result = new ContainerPolicy.Result(children);
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            Object child = itr.next();
            if (child instanceof Department) continue;
            result.setCommand((Command)UnexecutableCommand.INSTANCE);
            return result;
        }
        result.setCommand((Command)new AddDepartmentsCommand((Company)this.container, children, (Department)position));
        return result;
    }

    public ContainerPolicy.Result getCreateCommand(List children, Object position) {
        ContainerPolicy.Result result = new ContainerPolicy.Result(children);
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            if (itr.next() instanceof Department) continue;
            result.setCommand((Command)UnexecutableCommand.INSTANCE);
            return result;
        }
        Company parent = (Company)this.container;
        CompoundCommand cc = new CompoundCommand();
        cc.append((Command)new UniqueDepartmentName(parent, children));
        cc.append((Command)new AddDepartmentsCommand(parent, children, (Department)position));
        result.setCommand(AnnotationPolicy.getCreateRequestCommand((List)AnnotationPolicy.getAllAnnotations(new ArrayList(), (List)children, (AnnotationLinkagePolicy)this.domain.getAnnotationLinkagePolicy()), (Command)cc, (EditDomain)this.domain));
        return result;
    }

    public ContainerPolicy.Result getDeleteDependentCommand(List children) {
        ContainerPolicy.Result result = new ContainerPolicy.Result(children);
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            if (itr.next() instanceof Department) continue;
            result.setCommand((Command)UnexecutableCommand.INSTANCE);
            return result;
        }
        List annotations = AnnotationPolicy.getAllAnnotations(new ArrayList(), (List)children, (AnnotationLinkagePolicy)this.domain.getAnnotationLinkagePolicy());
        CompoundCommand cmd = new CompoundCommand();
        Company parent = (Company)this.container;
        cmd.append((Command)new RemoveDepartmentsCommand(parent, children));
        Iterator itr2 = children.iterator();
        while (itr2.hasNext()) {
            Department child = (Department)itr2.next();
            if (child.getManager() != null) {
                RestoreDefaultPropertyValueCommand reset = new RestoreDefaultPropertyValueCommand();
                reset.setTarget(PropertySupport.getPropertySource(child));
                reset.setPropertyId((Object)"manager");
                cmd.append((Command)reset);
            }
            Iterator itrEmployees = child.getEmployees().iterator();
            while (itrEmployees.hasNext()) {
                Employee emp = (Employee)itrEmployees.next();
                if (emp.getManages() == null) continue;
                RestoreDefaultPropertyValueCommand reset = new RestoreDefaultPropertyValueCommand();
                reset.setTarget(PropertySupport.getPropertySource(emp.getManages()));
                reset.setPropertyId((Object)"manager");
                cmd.append((Command)reset);
                Annotation mgrConn = this.domain.getAnnotationLinkagePolicy().getAnnotation((Object)new CompanyAnnotationLinkagePolicy.ManagedConnection(emp.getManages()));
                if (mgrConn == null) continue;
                annotations.add(mgrConn);
            }
            Annotation mgrConn = this.domain.getAnnotationLinkagePolicy().getAnnotation((Object)new CompanyAnnotationLinkagePolicy.ManagedConnection(child));
            if (mgrConn == null) continue;
            annotations.add(mgrConn);
        }
        result.setCommand(AnnotationPolicy.getDeleteDependentCommand((List)annotations, (Command)cmd.unwrap(), (DiagramData)this.domain.getDiagramData()));
        return result;
    }

    public Command getMoveChildrenCommand(List children, Object position) {
        CommandBuilder cBld = new CommandBuilder("");
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            Object child = itr.next();
            if (child instanceof Department) continue;
            return UnexecutableCommand.INSTANCE;
        }
        if (children.contains(position)) {
            return UnexecutableCommand.INSTANCE;
        }
        Company parent = (Company)this.container;
        cBld.append((Command)new RemoveDepartmentsCommand(parent, children));
        cBld.append((Command)new AddDepartmentsCommand(parent, children, (Department)position));
        return cBld.getCommand();
    }

    protected ContainerPolicy.Result getOrphanTheChildrenCommand(List children) {
        ContainerPolicy.Result result = new ContainerPolicy.Result(children);
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            Object child = itr.next();
            if (child instanceof Department) continue;
            result.setCommand((Command)UnexecutableCommand.INSTANCE);
            return result;
        }
        result.setCommand((Command)new RemoveDepartmentsCommand((Company)this.container, children));
        return result;
    }
}

