/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.IZoomListener;
import org.eclipse.ve.internal.cde.core.KeyedValueNotificationHelper;
import org.eclipse.ve.internal.cde.core.VisualInfoPolicy;
import org.eclipse.ve.internal.cde.core.ZoomController;
import org.eclipse.ve.internal.cdm.CDMFactory;
import org.eclipse.ve.internal.cdm.CDMPackage;
import org.eclipse.ve.internal.cdm.VisualInfo;
import org.eclipse.ve.internal.cdm.impl.KeyedPointsImpl;
import org.eclipse.ve.internal.cdm.model.Point;

public class VisualBendpointEditPolicy
extends BendpointEditPolicy
implements IZoomListener {
    private static final Object REFRESH_BENDPOINTS = new Object();
    protected ZoomController zoomController;
    protected VisualInfoPolicy.VisualInfoListener viListener;
    static /* synthetic */ Class class$0;

    public void activate() {
        super.activate();
        this.zoomController = ZoomController.getZoomController(this.getHost());
        if (this.zoomController != null) {
            this.zoomController.addZoomListener(this);
            this.zoomChanged(this.zoomController.getZoomValue(), 0);
        }
        EditPartViewer viewer = this.getHost().getRoot().getViewer();
        EditDomain dom = (EditDomain)viewer.getEditDomain();
        this.viListener = new VisualInfoPolicy.VisualInfoListener(this.getHost().getModel(), dom.getDiagram(viewer), dom){

            public void notifyVisualInfoChanges(Notification msg) {
                Notification kvMsg;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ve.internal.cdm.VisualInfo");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (msg.getFeatureID((Class)clazz) == 0 && (kvMsg = KeyedValueNotificationHelper.notifyChanged(msg, "org.eclipse.ve.internal.cdm.model.visualbendpointskey")) != null) {
                    switch (kvMsg.getEventType()) {
                        case 1: 
                        case 2: {
                            CDEUtilities.displayExec(VisualBendpointEditPolicy.this.getHost(), REFRESH_BENDPOINTS, new Runnable(this, kvMsg){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ Notification val$kvMsg;
                                {
                                    this.this$1 = var1_1;
                                    this.val$kvMsg = notification;
                                }

                                public void run() {
                                    if (this.this$1.diagram != null && 1.access$0(this.this$1).getHost() != null && 1.access$0(this.this$1).getHost().isActive()) {
                                        1.access$0(this.this$1).refreshBendpoints(((BasicEMap.Entry)this.val$kvMsg.getNewValue()).getValue());
                                    }
                                }
                            });
                        }
                    }
                }
            }

            public void notifyVisualInfo(int eventType, VisualInfo oldVI, VisualInfo newVI) {
                CDEUtilities.displayExec(VisualBendpointEditPolicy.this.getHost(), REFRESH_BENDPOINTS, new Runnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        if (this.this$1.diagram != null && 1.access$0(this.this$1).getHost() != null && 1.access$0(this.this$1).getHost().isActive()) {
                            1.access$0(this.this$1).refreshBendpoints();
                        }
                    }
                });
            }

            public void notifyAnnotationChanges(Notification msg) {
                CDEUtilities.displayExec(VisualBendpointEditPolicy.this.getHost(), REFRESH_BENDPOINTS, new Runnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        if (this.this$1.diagram != null && 1.access$0(this.this$1).getHost() != null && 1.access$0(this.this$1).getHost().isActive()) {
                            1.access$0(this.this$1).refreshBendpoints();
                        }
                    }
                });
            }

            static /* synthetic */ VisualBendpointEditPolicy access$0(1 var0) {
                return var0.VisualBendpointEditPolicy.this;
            }
        };
        this.refreshBendpoints();
    }

    public void deactivate() {
        if (this.zoomController != null) {
            this.zoomController.removeZoomListener(this);
            this.zoomController = null;
        }
        if (this.viListener != null) {
            this.viListener.removeListening();
        }
        this.viListener = null;
        this.setHost(null);
        super.deactivate();
    }

    public void zoomChanged(int newZoom, int oldZoom) {
        this.refreshBendpoints();
    }

    protected void refreshBendpoints() {
        Object kv = null;
        VisualInfo vi = VisualInfoPolicy.getVisualInfo(this.getHost());
        if (vi != null) {
            kv = vi.getKeyedValues().get((Object)"org.eclipse.ve.internal.cdm.model.visualbendpointskey");
        }
        this.refreshBendpoints(kv);
    }

    protected void refreshBendpoints(Object kv) {
        ArrayList<AbsoluteBendpoint> figureConstraint = Collections.EMPTY_LIST;
        if (kv instanceof List) {
            List modelConstraint = (List)kv;
            figureConstraint = new ArrayList<AbsoluteBendpoint>();
            int i = 0;
            while (i < modelConstraint.size()) {
                Point point = (Point)modelConstraint.get(i);
                AbsoluteBendpoint bp = new AbsoluteBendpoint(this.zoomCoordinate(point.x), this.zoomCoordinate(point.y));
                figureConstraint.add(bp);
                ++i;
            }
        }
        ((Connection)((GraphicalEditPart)this.getHost()).getFigure()).setRoutingConstraint(figureConstraint);
    }

    protected Command getCreateBendpointCommand(BendpointRequest request) {
        org.eclipse.draw2d.geometry.Point absoluteLocation = request.getLocation().getCopy();
        this.unzoomPoint(absoluteLocation);
        Point modelPoint = new Point(absoluteLocation.x, absoluteLocation.y);
        ArrayList<Point> currentPoints = this.getCurrentPoints();
        if (currentPoints == null) {
            currentPoints = new ArrayList<Point>(1);
            currentPoints.add(modelPoint);
        } else {
            currentPoints = new ArrayList(currentPoints);
            currentPoints.add(request.getIndex(), modelPoint);
        }
        return this.changeBendpointsCommand(currentPoints);
    }

    protected Command getMoveBendpointCommand(BendpointRequest request) {
        ArrayList<Point> currentPoints = this.getCurrentPoints();
        if (currentPoints == null) {
            return null;
        }
        currentPoints = new ArrayList<Point>(currentPoints);
        org.eclipse.draw2d.geometry.Point absoluteLocation = request.getLocation().getCopy();
        this.unzoomPoint(absoluteLocation);
        Point modelPoint = new Point(absoluteLocation.x, absoluteLocation.y);
        currentPoints.set(request.getIndex(), modelPoint);
        return this.changeBendpointsCommand(currentPoints);
    }

    protected Command getDeleteBendpointCommand(BendpointRequest request) {
        int index = request.getIndex();
        ArrayList currentPoints = this.getCurrentPoints();
        if (currentPoints == null || index >= currentPoints.size()) {
            return null;
        }
        currentPoints = new ArrayList(currentPoints);
        currentPoints.remove(index);
        return this.changeBendpointsCommand(currentPoints);
    }

    protected Command changeBendpointsCommand(List points) {
        EditPartViewer viewer = this.getHost().getRoot().getViewer();
        List oldPoints = this.getCurrentPoints();
        if (!points.equals(oldPoints)) {
            if (!points.isEmpty()) {
                KeyedPointsImpl newConstraint = (KeyedPointsImpl)CDMFactory.eINSTANCE.create(CDMPackage.eINSTANCE.getKeyedPoints());
                newConstraint.setKey("org.eclipse.ve.internal.cdm.model.visualbendpointskey");
                newConstraint.getTypedValue().addAll((Collection)points);
                EditDomain dom = EditDomain.getEditDomain(this.getHost());
                return VisualInfoPolicy.applyVisualInfoSetting(this.getHost().getModel(), (Object)newConstraint, dom, dom.getDiagram(viewer));
            }
            VisualInfo vi = VisualInfoPolicy.getVisualInfo(this.getHost());
            return VisualInfoPolicy.cancelVisualInfoSetting(vi, "org.eclipse.ve.internal.cdm.model.visualbendpointskey");
        }
        return null;
    }

    protected List getCurrentPoints() {
        EditPartViewer viewer = this.getHost().getRoot().getViewer();
        VisualInfo vi = VisualInfoPolicy.getVisualInfo(this.getHost().getModel(), viewer);
        Object bendpointsKV = vi != null ? vi.getKeyedValues().get((Object)"org.eclipse.ve.internal.cdm.model.visualbendpointskey") : null;
        List oldPoints = bendpointsKV instanceof List ? (List)bendpointsKV : null;
        return oldPoints;
    }

    protected void unzoomPoint(org.eclipse.draw2d.geometry.Point p) {
        if (this.zoomController != null) {
            p.setLocation(this.zoomController.unzoomCoordinate(p.x), this.zoomController.unzoomCoordinate(p.y));
        }
    }

    protected int zoomCoordinate(int coor) {
        return this.zoomController == null ? coor : this.zoomController.zoomCoordinate(coor);
    }
}

