/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.propertysheet.command;

import java.text.MessageFormat;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ve.internal.propertysheet.IEToolsPropertyDescriptor;
import org.eclipse.ve.internal.propertysheet.ISourcedPropertyDescriptor;
import org.eclipse.ve.internal.propertysheet.PropertysheetMessages;
import org.eclipse.ve.internal.propertysheet.command.ICommandPropertyDescriptor;
import org.eclipse.ve.internal.propertysheet.command.RestoreDefaultPropertyValueCommand;
import org.eclipse.ve.internal.propertysheet.command.SetPropertyValueCommand;

public final class WrapperedPropertyDescriptor
implements ICommandPropertyDescriptor,
ISourcedPropertyDescriptor,
IEToolsPropertyDescriptor {
    protected static final MessageFormat sApplyFormat = new MessageFormat(PropertysheetMessages.apply_value);
    protected static final MessageFormat sResetFormat = new MessageFormat(PropertysheetMessages.reset_value);
    protected IPropertyDescriptor fDescriptor;
    protected IPropertySource fSource;
    protected Object fID;
    private String fDisplayName;

    public WrapperedPropertyDescriptor(IPropertySource source, IPropertyDescriptor descriptor) {
        this(descriptor.getId(), source, descriptor);
    }

    public Object getHelpContextIds() {
        return this.fDescriptor.getHelpContextIds();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WrapperedPropertyDescriptor)) {
            return false;
        }
        WrapperedPropertyDescriptor wo = (WrapperedPropertyDescriptor)o;
        return this.fDescriptor.equals(wo.fDescriptor) && this.fSource.equals(wo.fSource) && this.fID.equals(wo.fID);
    }

    public int hashCode() {
        return this.fDescriptor.hashCode() ^ this.fSource.hashCode() ^ this.fID.hashCode();
    }

    public WrapperedPropertyDescriptor(Object anID, IPropertySource source, IPropertyDescriptor descriptor) {
        this(anID, null, source, descriptor);
    }

    public WrapperedPropertyDescriptor(Object anID, String displayName, IPropertySource source, IPropertyDescriptor descriptor) {
        this.fID = anID;
        this.fDisplayName = displayName;
        this.fSource = source;
        this.fDescriptor = descriptor;
    }

    public String getCategory() {
        return this.fDescriptor.getCategory();
    }

    public String getDescription() {
        return this.fDescriptor.getDescription();
    }

    public String getDisplayName() {
        return this.fDisplayName == null ? this.fDescriptor.getDisplayName() : this.fDisplayName;
    }

    public String[] getFilterFlags() {
        return this.fDescriptor.getFilterFlags();
    }

    public Object getId() {
        return this.fID;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        return this.fDescriptor.createPropertyEditor(parent);
    }

    public ILabelProvider getLabelProvider() {
        return this.fDescriptor.getLabelProvider();
    }

    public Object getValue(IPropertySource source) {
        if (this.fDescriptor instanceof ISourcedPropertyDescriptor) {
            return ((ISourcedPropertyDescriptor)this.fDescriptor).getValue(this.fSource);
        }
        return this.fSource.getPropertyValue(this.fDescriptor.getId());
    }

    public boolean isSet(IPropertySource source) {
        if (this.fDescriptor instanceof ISourcedPropertyDescriptor) {
            return ((ISourcedPropertyDescriptor)this.fDescriptor).isSet(this.fSource);
        }
        return this.fSource.isPropertySet(this.fDescriptor.getId());
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        return this.fDescriptor.isCompatibleWith(anotherProperty instanceof WrapperedPropertyDescriptor ? ((WrapperedPropertyDescriptor)anotherProperty).fDescriptor : anotherProperty);
    }

    public Command setValue(IPropertySource source, Object setValue) {
        if (this.fDescriptor instanceof ICommandPropertyDescriptor) {
            return ((ICommandPropertyDescriptor)this.fDescriptor).setValue(this.fSource, setValue);
        }
        SetPropertyValueCommand c = new SetPropertyValueCommand(sApplyFormat.format(new Object[]{this.fDescriptor.getDisplayName()}));
        c.setTarget(this.fSource);
        c.setPropertyValue(setValue);
        c.setPropertyId(this.fDescriptor.getId());
        return c;
    }

    public Command resetValue(IPropertySource source) {
        if (this.fDescriptor instanceof ICommandPropertyDescriptor) {
            return ((ICommandPropertyDescriptor)this.fDescriptor).resetValue(this.fSource);
        }
        RestoreDefaultPropertyValueCommand c = new RestoreDefaultPropertyValueCommand(sResetFormat.format(new Object[]{this.fDescriptor.getDisplayName()}));
        c.setTarget(this.fSource);
        c.setPropertyId(this.fDescriptor.getId());
        return c;
    }

    public boolean areNullsInvalid() {
        return this.fDescriptor instanceof IEToolsPropertyDescriptor ? ((IEToolsPropertyDescriptor)this.fDescriptor).areNullsInvalid() : false;
    }

    public boolean isExpandable() {
        return this.fDescriptor instanceof IEToolsPropertyDescriptor ? ((IEToolsPropertyDescriptor)this.fDescriptor).isExpandable() : true;
    }

    public boolean isReadOnly() {
        return this.fDescriptor instanceof IEToolsPropertyDescriptor ? ((IEToolsPropertyDescriptor)this.fDescriptor).isReadOnly() : false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.fDescriptor.toString() + ")";
    }

    public boolean isPropertyResettable(IPropertySource source) {
        if (this.fDescriptor instanceof ISourcedPropertyDescriptor) {
            return ((ISourcedPropertyDescriptor)this.fDescriptor).isPropertyResettable(this.fSource);
        }
        if (this.fSource instanceof IPropertySource2) {
            return ((IPropertySource2)this.fSource).isPropertyResettable(this.fDescriptor.getId());
        }
        return true;
    }
}

