/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMConstantBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanTypeProxyFactory;

class REMDoubleTypeBeanProxy
extends REMConstantBeanProxy
implements INumberBeanProxy {
    private final double fDouble;

    REMDoubleTypeBeanProxy(REMProxyFactoryRegistry aRegistry, double aDouble) {
        super(aRegistry);
        this.fDouble = aDouble;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof REMDoubleTypeBeanProxy) {
            return this.fDouble == ((REMDoubleTypeBeanProxy)anObject).doubleValue();
        }
        if (anObject instanceof Double) {
            return this.fDouble == (Double)anObject;
        }
        return false;
    }

    public boolean sameAs(IBeanProxy aBeanProxy) {
        if (this == aBeanProxy) {
            return true;
        }
        if (aBeanProxy instanceof REMDoubleTypeBeanProxy) {
            return this.fDouble == ((REMDoubleTypeBeanProxy)aBeanProxy).doubleValue();
        }
        return false;
    }

    public byte byteValue() {
        return (byte)this.fDouble;
    }

    public double doubleValue() {
        return this.fDouble;
    }

    public float floatValue() {
        return (float)this.fDouble;
    }

    public int intValue() {
        return (int)this.fDouble;
    }

    public long longValue() {
        return (long)this.fDouble;
    }

    public Number numberValue() {
        return new Double(this.fDouble);
    }

    public short shortValue() {
        return (short)this.fDouble;
    }

    public String toBeanString() {
        return String.valueOf(this.fDouble);
    }

    public IBeanTypeProxy getTypeProxy() {
        return ((REMStandardBeanTypeProxyFactory)this.fFactory.getBeanTypeProxyFactory()).doubleType;
    }

    public void renderBean(Commands.ValueObject value) {
        value.set(this.fDouble);
    }
}

