/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.cdm.dept.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.FrameBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LabeledContainer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.ve.examples.cdm.dept.Department;
import org.eclipse.ve.examples.cdm.dept.Employee;
import org.eclipse.ve.examples.cdm.dept.property.PropertySupport;
import org.eclipse.ve.examples.cdm.dept.ui.CompanyAnnotationLinkagePolicy;
import org.eclipse.ve.examples.cdm.dept.ui.DepartmentContainerPolicy;
import org.eclipse.ve.examples.cdm.dept.ui.EmployeeGraphicalEditPart;
import org.eclipse.ve.examples.cdm.dept.ui.ManagedConnectionEditPart;
import org.eclipse.ve.internal.cde.core.ContainerPolicy;
import org.eclipse.ve.internal.cde.core.DefaultComponentEditPolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.FlowLayoutEditPolicy;

public class DepartmentGraphicalEditPart
extends AbstractGraphicalEditPart
implements NodeEditPart {
    private String deptName;
    private String managerName;
    protected PropertyChangeListener departmentListener;
    protected PropertyChangeListener managerListener;
    protected Employee manager;
    static /* synthetic */ Class class$0;

    public DepartmentGraphicalEditPart(Department model) {
        this.setModel(model);
    }

    protected List getModelChildren() {
        return ((Department)this.getModel()).getEmployees();
    }

    public void activate() {
        super.activate();
        Department department = (Department)this.getModel();
        this.departmentListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("employees".equals(evt.getPropertyName())) {
                    DepartmentGraphicalEditPart.this.refreshChildren();
                } else if ("deptname".equals(evt.getPropertyName())) {
                    DepartmentGraphicalEditPart.this.refreshDeptName((String)evt.getNewValue());
                } else if ("manager".equals(evt.getPropertyName())) {
                    DepartmentGraphicalEditPart.this.refreshManager((Employee)evt.getNewValue());
                }
            }
        };
        department.addPropertyChangeListener(this.departmentListener);
        if (department.getManager() != null) {
            this.listenManager(department.getManager());
        }
    }

    protected void refreshSourceConnections() {
        super.refreshSourceConnections();
    }

    public void deactivate() {
        super.deactivate();
        ((Department)this.getModel()).removePropertyChangeListener(this.departmentListener);
        this.listenManager(null);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DefaultComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new FlowLayoutEditPolicy((ContainerPolicy)new DepartmentContainerPolicy(EditDomain.getEditDomain((EditPart)this))));
    }

    protected IFigure createFigure() {
        LabeledContainer f = new LabeledContainer((Border)new FrameBorder());
        ((TitleBarBorder)((FrameBorder)f.getBorder()).getInnerBorder()).setBackgroundColor(ColorConstants.lightGreen);
        f.setLayoutManager((LayoutManager)new FlowLayout(false));
        return f;
    }

    protected List getModelSourceConnections() {
        ArrayList<CompanyAnnotationLinkagePolicy.ManagedConnection> sources = new ArrayList<CompanyAnnotationLinkagePolicy.ManagedConnection>();
        Iterator employees = ((Department)this.getModel()).getEmployees().iterator();
        while (employees.hasNext()) {
            Employee emp = (Employee)employees.next();
            Department dept = emp.getManages();
            if (dept == null) continue;
            sources.add(new CompanyAnnotationLinkagePolicy.ManagedConnection(dept));
        }
        return sources;
    }

    protected List getModelTargetConnections() {
        Employee manager = ((Department)this.getModel()).getManager();
        if (manager == null || manager.getDepartment() == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<CompanyAnnotationLinkagePolicy.ManagedConnection> targets = new ArrayList<CompanyAnnotationLinkagePolicy.ManagedConnection>(1);
        targets.add(new CompanyAnnotationLinkagePolicy.ManagedConnection((Department)this.getModel()));
        return targets;
    }

    protected void refreshChildren() {
        super.refreshChildren();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        Employee manager = ((Department)this.getModel()).getManager();
        this.managerName = manager != null ? manager.getName() : null;
        this.deptName = ((Department)this.getModel()).getDepartmentName();
        this.setTitle();
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return PropertySupport.getPropertySource(this.getModel());
        }
        return super.getAdapter(key);
    }

    private void setTitle() {
        String deptString = this.deptName != null ? this.deptName : "?";
        String mngString = this.managerName != null ? this.managerName : "?";
        ((LabeledContainer)this.getFigure()).setLabel(String.valueOf(deptString) + ": " + mngString);
        this.getFigure().repaint();
    }

    private void refreshDeptName(String deptName) {
        this.deptName = deptName;
        this.setTitle();
    }

    private void listenManager(Employee manager) {
        if (this.managerListener != null) {
            this.manager.removePropertyChangeListener("name", this.managerListener);
            this.manager = null;
            this.managerListener = null;
        }
        this.manager = manager;
        if (manager != null) {
            this.managerListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("name".equals(evt.getPropertyName())) {
                        DepartmentGraphicalEditPart.this.refreshManagerName((String)evt.getNewValue());
                    }
                }
            };
            manager.addPropertyChangeListener("name", this.managerListener);
        }
    }

    private void refreshManager(Employee manager) {
        this.listenManager(manager);
        if (manager != null) {
            this.refreshManagerName(manager.getName());
        } else {
            this.refreshManagerName(null);
        }
        this.refreshTargetConnections();
    }

    private void refreshManagerName(String name) {
        this.managerName = name;
        this.setTitle();
    }

    protected EditPart createChild(Object child) {
        Employee childModel = (Employee)child;
        return new EmployeeGraphicalEditPart(childModel);
    }

    protected ConnectionEditPart createConnection(Object managedConnection) {
        Object connectionEP = (ConnectionEditPart)this.getRoot().getViewer().getEditPartRegistry().get(managedConnection);
        if (connectionEP == null) {
            connectionEP = new ManagedConnectionEditPart();
            connectionEP.setModel(managedConnection);
        }
        return connectionEP;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        return new ChopboxAnchor(this.getFigure());
    }
}

