/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.adapters;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoAdapterFactory;
import org.eclipse.jem.workbench.utility.JavaModelListener;

public class BeaninfoModelSynchronizer
extends JavaModelListener {
    protected BeaninfoAdapterFactory fAdapterFactory;
    protected IJavaProject fProject;
    private static final IPath BEANINFOCONFIG_PATH = new Path(".beaninfoConfig");
    private ThreadLocal markedAllStale = new ThreadLocal();

    public BeaninfoModelSynchronizer(BeaninfoAdapterFactory aFactory, IJavaProject aProject) {
        super(1);
        this.fAdapterFactory = aFactory;
        this.fProject = aProject;
    }

    protected IJavaProject getJavaProject() {
        return this.fProject;
    }

    protected boolean isAlsoClasspathChange(IPath path) {
        return path.equals((Object)BEANINFOCONFIG_PATH);
    }

    public void stopSynchronizer(boolean clearResults) {
        this.releaseListener();
        this.getAdapterFactory().closeAll(clearResults);
    }

    public BeaninfoAdapterFactory getAdapterFactory() {
        return this.fAdapterFactory;
    }

    protected void processJavaElementChanged(IJavaProject element, IJavaElementDelta delta) {
        if (this.isInClasspath(element)) {
            if (delta.getKind() == 2 || delta.getKind() == 1) {
                if (!element.equals(this.fProject)) {
                    this.getAdapterFactory().markAllStale();
                }
                return;
            }
            if (this.isClasspathResourceChange(delta)) {
                this.getAdapterFactory().markAllStale();
                return;
            }
            this.processChildren((IJavaElement)element, delta);
        }
    }

    protected void processJavaElementChanged(ICompilationUnit element, IJavaElementDelta delta) {
        switch (delta.getKind()) {
            case 4: {
                if ((delta.getFlags() & 0x40000) == 0) break;
                this.getAdapterFactory().markStaleIntrospectionPlusInner(this.getFullNameFromElement((IJavaElement)element), false);
                break;
            }
            case 1: 
            case 2: {
                this.getAdapterFactory().markStaleIntrospectionPlusInner(this.getFullNameFromElement((IJavaElement)element), true);
            }
        }
    }

    protected void processJavaElementChanged(IClassFile element, IJavaElementDelta delta) {
        if (delta.getKind() == 2) {
            this.getAdapterFactory().markStaleIntrospectionPlusInner(this.getFullNameFromElement((IJavaElement)element), true);
            return;
        }
        IJavaElementDelta[] children = delta.getAffectedChildren();
        int ii = 0;
        while (ii < children.length) {
            this.processDelta(children[ii]);
            ++ii;
        }
    }

    protected String getFullNameFromElement(IJavaElement element) {
        String name = element.getElementName();
        if (!(element instanceof ICompilationUnit) && !(element instanceof IClassFile)) {
            return name;
        }
        int periodNdx = name.lastIndexOf(46);
        if (periodNdx == -1) {
            return name;
        }
        String typeName = null;
        String parentName = element.getParent().getElementName();
        typeName = parentName == null || parentName.length() == 0 ? name.substring(0, periodNdx) : String.valueOf(parentName) + "." + name.substring(0, periodNdx);
        return typeName;
    }

    protected void processJavaElementChanged(IPackageFragmentRoot element, IJavaElementDelta delta) {
        if (this.isClassPathChange(delta)) {
            this.markAllStale();
        } else {
            super.processJavaElementChanged(element, delta);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void notifyProjectAddedRemovedFromClasspath(IJavaProject[] added, IJavaProject[] removed) {
        try {
            this.setMarkedAllStale(false);
            this.markAllStale();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.setMarkedAllStale(false);
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.setMarkedAllStale(false);
            return;
        }
    }

    private boolean isMarkedAllStale() {
        Boolean b = (Boolean)this.markedAllStale.get();
        if (b == null) {
            b = Boolean.FALSE;
            this.markedAllStale.set(b);
        }
        return b;
    }

    private void setMarkedAllStale(boolean b) {
        this.markedAllStale.set(b);
    }

    private void markAllStale() {
        if (!this.isMarkedAllStale()) {
            this.fAdapterFactory.markAllStale();
            this.setMarkedAllStale(true);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processElementChanged(ElementChangedEvent event) {
        this.setMarkedAllStale(false);
        try {
            super.processElementChanged(event);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.setMarkedAllStale(false);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.setMarkedAllStale(false);
            return;
        }
    }

    protected void processJavaElementChanged(IPackageFragment element, IJavaElementDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                break;
            }
            case 2: {
                if (delta.getAffectedChildren().length != 0) break;
                this.markAllStale();
                break;
            }
            default: {
                super.processJavaElementChanged(element, delta);
            }
        }
    }

    protected void processJavaElementChanged(IType element, IJavaElementDelta delta) {
        if (delta.getKind() == 2) {
            this.getAdapterFactory().markStaleIntrospection(element.getFullyQualifiedName(), true);
        } else {
            this.getAdapterFactory().markStaleIntrospection(element.getFullyQualifiedName(), false);
        }
        this.processChildren((IJavaElement)element, delta);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " " + this.fProject.getElementName();
    }
}

