/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMConstantBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanTypeProxyFactory;

final class REMBooleanTypeBeanProxy
extends REMConstantBeanProxy
implements IBooleanBeanProxy {
    private final boolean fBoolean;

    REMBooleanTypeBeanProxy(REMProxyFactoryRegistry aRegistry, boolean value) {
        super(aRegistry);
        this.fBoolean = value;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof REMBooleanTypeBeanProxy) {
            return this.fBoolean == ((REMBooleanTypeBeanProxy)anObject).booleanValue();
        }
        if (anObject instanceof Boolean) {
            return this.fBoolean == (Boolean)anObject;
        }
        return false;
    }

    public boolean sameAs(IBeanProxy aBeanProxy) {
        if (this == aBeanProxy) {
            return true;
        }
        if (aBeanProxy instanceof REMBooleanTypeBeanProxy) {
            return this.fBoolean == ((REMBooleanTypeBeanProxy)aBeanProxy).booleanValue();
        }
        return false;
    }

    public boolean booleanValue() {
        return this.fBoolean;
    }

    public Boolean getBooleanValue() {
        return this.fBoolean ? Boolean.TRUE : Boolean.FALSE;
    }

    public String toBeanString() {
        return this.fBoolean ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
    }

    public IBeanTypeProxy getTypeProxy() {
        return ((REMStandardBeanTypeProxyFactory)this.fFactory.getBeanTypeProxyFactory()).booleanType;
    }

    public void renderBean(Commands.ValueObject value) {
        value.set(this.fBoolean);
    }
}

