/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.adapters.jdom;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.adapters.jdom.JavaJDOMAdapterFactory;
import org.eclipse.jem.internal.plugin.JavaPlugin;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JavaModelListener;

public class JavaReflectionSynchronizer
extends JavaModelListener {
    protected JavaJDOMAdapterFactory fAdapterFactory;
    private ThreadLocal flushedAll = new ThreadLocal();
    private ThreadLocal flushTypes = new ThreadLocal();
    private ThreadLocal flushTypePlusInner = new ThreadLocal();
    private ThreadLocal notifications = new ThreadLocal();

    protected boolean isFlushedAll() {
        Boolean b = (Boolean)this.flushedAll.get();
        if (b == null) {
            b = Boolean.FALSE;
            this.flushedAll.set(b);
        }
        return b;
    }

    protected void setFlushedAll(boolean b) {
        this.flushedAll.set(b);
    }

    protected List getFlushTypes() {
        ArrayList ft = (ArrayList)this.flushTypes.get();
        if (ft == null) {
            ft = new ArrayList();
            this.flushTypes.set(ft);
        }
        return ft;
    }

    protected List getFlushTypePlusInner() {
        ArrayList ft = (ArrayList)this.flushTypePlusInner.get();
        if (ft == null) {
            ft = new ArrayList();
            this.flushTypePlusInner.set(ft);
        }
        return ft;
    }

    protected List getNotifications() {
        ArrayList note = (ArrayList)this.notifications.get();
        if (note == null) {
            note = new ArrayList();
            this.notifications.set(note);
        }
        return note;
    }

    public JavaReflectionSynchronizer(JavaJDOMAdapterFactory synchronizee) {
        this.fAdapterFactory = synchronizee;
    }

    protected IJavaProject getJavaProject() {
        return this.getAdapterFactory().getJavaProject();
    }

    protected Notification doFlush(IType element) {
        return this.getAdapterFactory().flushReflectionNoNotification(element.getFullyQualifiedName());
    }

    protected Notification doFlush(ICompilationUnit element) {
        return this.getAdapterFactory().flushReflectionPlusInnerNoNotification(this.getFullNameFromElement(element));
    }

    protected void flush(IType element) {
        List fTypes = this.getFlushTypes();
        if (!fTypes.contains(element)) {
            fTypes.add(element);
        }
    }

    protected void flush(ICompilationUnit element) {
        List ftp = this.getFlushTypePlusInner();
        if (!ftp.contains(element)) {
            ftp.add(element);
        }
    }

    protected void flushPackage(String packageName, boolean noFlushIfSourceFound) {
        this.getNotifications().addAll(this.getAdapterFactory().flushPackageNoNotification(packageName, true));
    }

    protected JavaJDOMAdapterFactory getAdapterFactory() {
        return this.fAdapterFactory;
    }

    protected void processJavaElementChanged(ICompilationUnit element, IJavaElementDelta delta) {
        switch (delta.getKind()) {
            case 4: {
                if ((delta.getFlags() & 0x40000) != 0) {
                    this.flush(element);
                    break;
                }
                if ((delta.getFlags() & 1) != 0 || (delta.getFlags() & 8) == 0) break;
                this.processChildren((IJavaElement)element, delta);
                break;
            }
            case 1: 
            case 2: {
                if (element.isWorkingCopy()) break;
                this.disAssociateSourcePlusInner(this.getFullNameFromElement(element));
            }
        }
    }

    protected void processJavaElementChanged(IJavaProject element, IJavaElementDelta delta) {
        if (this.isInClasspath(element)) {
            if (delta.getKind() == 2 || delta.getKind() == 4 && (delta.getFlags() & 0x400) != 0) {
                if (element.equals(this.getAdapterFactory().getJavaProject())) {
                    this.stopSynchronizer();
                } else {
                    this.flushAll();
                }
                return;
            }
            if (delta.getKind() == 1 || this.isClasspathResourceChange(delta)) {
                this.flushAll();
                return;
            }
            this.processChildren((IJavaElement)element, delta);
        }
    }

    protected void processJavaElementChanged(IClassFile element, IJavaElementDelta delta) {
        int kind = delta.getKind();
        if (kind == 2 || kind == 1) {
            this.disAssociateSourcePlusInner(this.getFullNameFromElement(element));
            return;
        }
        IJavaElementDelta[] children = delta.getAffectedChildren();
        int ii = 0;
        while (ii < children.length) {
            this.processDelta(children[ii]);
            ++ii;
        }
    }

    protected void processJavaElementChanged(IPackageFragmentRoot element, IJavaElementDelta delta) {
        if (this.isFlushedAll()) {
            return;
        }
        if (this.isClassPathChange(delta)) {
            this.flushAll();
        } else {
            super.processJavaElementChanged(element, delta);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void notifyProjectAddedRemovedFromClasspath(IJavaProject[] added, IJavaProject[] removed) {
        try {
            this.setFlushedAll(false);
            this.getFlushTypes().clear();
            this.getFlushTypePlusInner().clear();
            this.getNotifications().clear();
            this.flushAll();
            this.flushTypes();
            this.processNotifications();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.setFlushedAll(false);
            this.getFlushTypes().clear();
            this.getFlushTypePlusInner().clear();
            this.getNotifications().clear();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.setFlushedAll(false);
            this.getFlushTypes().clear();
            this.getFlushTypePlusInner().clear();
            this.getNotifications().clear();
            return;
        }
    }

    protected void processJavaElementChanged(IPackageFragment element, IJavaElementDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                if (delta.getAffectedChildren().length != 0) break;
                this.flushPackage(delta.getElement().getElementName(), true);
                break;
            }
            case 2: {
                if (delta.getAffectedChildren().length != 0) break;
                this.getAdapterFactory().flushPackage(delta.getElement().getElementName(), false);
                break;
            }
            default: {
                super.processJavaElementChanged(element, delta);
            }
        }
    }

    protected void processJavaElementChanged(IType element, IJavaElementDelta delta) {
        int kind = delta.getKind();
        if (kind == 2 || kind == 1) {
            this.disAssociateSourcePlusInner(element.getFullyQualifiedName());
        } else {
            this.flush(element);
            this.processChildren((IJavaElement)element, delta);
        }
    }

    protected void processRemoveOrAdd(ICompilationUnit element) {
        this.disAssociateSource(this.getFullNameFromElement(element));
    }

    protected String getFullNameFromElement(ICompilationUnit cu) {
        IType primary = cu.findPrimaryType();
        if (primary != null) {
            return primary.getFullyQualifiedName();
        }
        String filename = cu.getElementName();
        int idx = filename.lastIndexOf(46);
        if (idx != -1) {
            filename = filename.substring(0, idx);
        }
        return String.valueOf(((IPackageFragment)cu.getParent()).getElementName()) + '.' + filename;
    }

    protected String getFullNameFromElement(IClassFile cf) {
        try {
            return cf.getType().getFullyQualifiedName();
        }
        catch (JavaModelException e) {
            JavaPlugin.getDefault().getLogger().log((Throwable)e, Level.WARNING);
            String cfName = cf.getElementName();
            return cfName.substring(0, cfName.length() - ".class".length());
        }
    }

    protected String getFullNameFromElement(IJavaElement element) {
        String name = element.getElementName();
        if (element == null || name.length() <= 5 || !name.substring(name.length() - 5).equals(".java")) {
            int index;
            Logger logger = JavaPlugin.getDefault().getLogger();
            if (logger.isLoggingLevel(Level.FINE)) {
                logger.log((Object)("Invalid .java file: " + name), Level.FINE);
            }
            name = (index = name.lastIndexOf(".")) >= 0 ? String.valueOf(name.substring(0, index)) + ".java" : String.valueOf(name) + ".java";
        }
        if (element.getParent().getElementName() == null || element.getParent().getElementName().length() == 0) {
            return name.substring(0, name.length() - 5);
        }
        return String.valueOf(element.getParent().getElementName()) + "." + name.substring(0, name.length() - 5);
    }

    public void stopSynchronizer() {
        this.releaseListener();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processElementChanged(ElementChangedEvent event) {
        try {
            this.setFlushedAll(false);
            this.getFlushTypes().clear();
            this.getFlushTypePlusInner().clear();
            this.getNotifications().clear();
            super.processElementChanged(event);
            this.flushTypes();
            this.processNotifications();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.setFlushedAll(false);
            this.getFlushTypes().clear();
            this.getFlushTypePlusInner().clear();
            this.getNotifications().clear();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.setFlushedAll(false);
            this.getFlushTypes().clear();
            this.getFlushTypePlusInner().clear();
            this.getNotifications().clear();
            return;
        }
    }

    private void flushTypes() {
        List ftp;
        List ft = this.getFlushTypes();
        if (!ft.isEmpty()) {
            IType type = null;
            int i = 0;
            while (i < ft.size()) {
                type = (IType)ft.get(i);
                Notification not = this.doFlush(type);
                if (not != null) {
                    this.getNotifications().add(not);
                }
                ++i;
            }
        }
        if (!(ftp = this.getFlushTypePlusInner()).isEmpty()) {
            ICompilationUnit unit = null;
            int i = 0;
            while (i < ftp.size()) {
                unit = (ICompilationUnit)ftp.get(i);
                Notification not = this.doFlush(unit);
                if (not != null) {
                    this.getNotifications().add(not);
                }
                ++i;
            }
        }
    }

    private void processNotifications() {
        List notes = this.getNotifications();
        int i = 0;
        while (i < notes.size()) {
            Notification not = (Notification)notes.get(i);
            Notifier notifier = (Notifier)not.getNotifier();
            if (notifier != null) {
                try {
                    notifier.eNotify(not);
                }
                catch (Exception e) {
                    JavaPlugin.getDefault().getLogger().log((Throwable)e);
                }
            }
            ++i;
        }
    }

    protected void disAssociateSource(String qualifiedName) {
        Notification not = this.getAdapterFactory().disAssociateSource(qualifiedName, false);
        if (not != null) {
            this.getNotifications().add(not);
        }
    }

    protected void disAssociateSourcePlusInner(String qualifiedName) {
        Notification not = this.getAdapterFactory().disAssociateSourcePlusInner(qualifiedName, false);
        if (not != null) {
            this.getNotifications().add(not);
        }
    }

    protected void flushAll() {
        if (!this.isFlushedAll()) {
            this.getNotifications().addAll(this.getAdapterFactory().flushAllNoNotification());
            this.setFlushedAll(true);
        }
    }

    protected void processChildren(IJavaElement element, IJavaElementDelta delta) {
        if (!this.isFlushedAll()) {
            super.processChildren(element, delta);
        }
    }

    public void processDelta(IJavaElementDelta delta) {
        if (!this.isFlushedAll()) {
            super.processDelta(delta);
        }
    }
}

