/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.workbench.utility;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.core.JEMPlugin;

public abstract class JavaModelListener
implements IElementChangedListener {
    private static final IJavaProject[] EMPTY_PROJECTS = new IJavaProject[0];
    private IResourceChangeListener projectChangeListener;
    private Map projectsInClasspath = Collections.synchronizedMap(new HashMap(5));

    public JavaModelListener() {
        this(1);
    }

    public JavaModelListener(int eventsToListen) {
        JavaCore.addElementChangedListener((IElementChangedListener)this, (int)eventsToListen);
    }

    public void initializeClasspaths() {
        this.buildProjectsInClasspath(false);
        this.projectChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                try {
                    boolean[] rebuild = new boolean[1];
                    event.getDelta().accept(new IResourceDeltaVisitor(this, rebuild){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ boolean[] val$rebuild;
                        {
                            this.this$1 = var1_1;
                            this.val$rebuild = blArray;
                        }

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            boolean isProject;
                            IResource res = delta.getResource();
                            boolean bl = isProject = res.getType() == 4;
                            if (isProject && JavaModelListener.access$0(1.access$0(this.this$1)).containsKey(res.getName()) && (delta.getFlags() & 0x80000) != 0) {
                                this.val$rebuild[0] = true;
                            }
                            return res.getType() != 4;
                        }
                    });
                    if (rebuild[0]) {
                        JavaModelListener.this.buildProjectsInClasspath(true);
                    }
                }
                catch (CoreException coreException) {}
            }

            static /* synthetic */ JavaModelListener access$0(1 var0) {
                return var0.JavaModelListener.this;
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.projectChangeListener, 17);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildProjectsInClasspath(boolean notify) {
        IProject project = this.getJavaProject().getProject();
        String topProjectName = project.getName();
        IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
        HashMap newMap = new HashMap();
        this.traverseProjects(project, newMap, true);
        if (notify) {
            if (this.projectsInClasspath.size() > 1) {
                String[] oldProjectNames = this.projectsInClasspath.keySet().toArray(new String[this.projectsInClasspath.size()]);
                int oldProjectsLeft = oldProjectNames.length;
                String[] newProjectNames = newMap.keySet().toArray(new String[newMap.size()]);
                int newProjectsAdded = 0;
                int nndx = 0;
                while (nndx < newProjectNames.length) {
                    block17: {
                        String newProjectName = newProjectNames[nndx];
                        int ondx = 0;
                        while (ondx < oldProjectNames.length) {
                            if (newProjectName.equals(oldProjectNames[ondx])) {
                                oldProjectNames[ondx] = null;
                                newProjectNames[nndx] = null;
                                --oldProjectsLeft;
                                break block17;
                            }
                            ++ondx;
                        }
                        ++newProjectsAdded;
                    }
                    ++nndx;
                }
                IJavaProject[] added = EMPTY_PROJECTS;
                if (newProjectsAdded > 0) {
                    added = new IJavaProject[newProjectsAdded];
                    int addndx = 0;
                    int i = 0;
                    while (i < newProjectNames.length) {
                        if (newProjectNames[i] != null) {
                            added[addndx++] = JavaCore.create((IProject)wsroot.getProject(newProjectNames[i]));
                        }
                        ++i;
                    }
                }
                IJavaProject[] removed = EMPTY_PROJECTS;
                if (oldProjectsLeft > 0) {
                    removed = new IJavaProject[oldProjectsLeft];
                    int removedndx = 0;
                    int i = 0;
                    while (i < newProjectNames.length) {
                        String oldProjectName = oldProjectNames[i];
                        if (oldProjectName != null) {
                            removed[removedndx++] = JavaCore.create((IProject)wsroot.getProject(oldProjectName));
                        }
                        ++i;
                    }
                }
                this.notifyProjectAddedRemovedFromClasspath(added, removed);
            } else if (newMap.size() > 1) {
                IJavaProject[] added = new IJavaProject[newMap.size() - 1];
                int addedndx = 0;
                Iterator itr = newMap.keySet().iterator();
                while (itr.hasNext()) {
                    String newProjectName = (String)itr.next();
                    if (topProjectName.equals(newProjectName)) continue;
                    added[addedndx++] = JavaCore.create((IProject)wsroot.getProject(newProjectName));
                }
                this.notifyProjectAddedRemovedFromClasspath(added, EMPTY_PROJECTS);
            }
        }
        Map map = this.projectsInClasspath;
        synchronized (map) {
            this.projectsInClasspath.clear();
            this.projectsInClasspath.putAll(newMap);
        }
    }

    private void traverseProjects(IProject project, Map projectsProcessed, boolean topProject) {
        block4: {
            String projectName = project.getName();
            if (projectsProcessed.containsKey(projectName)) {
                return;
            }
            try {
                IProject[] dynProjects = project.getDescription().getDynamicReferences();
                projectsProcessed.put(projectName, dynProjects);
                int i = 0;
                while (i < dynProjects.length) {
                    this.traverseProjects(dynProjects[i], projectsProcessed, false);
                    ++i;
                }
            }
            catch (CoreException coreException) {
                if (!topProject) break block4;
                projectsProcessed.put(projectName, EMPTY_PROJECTS);
            }
        }
    }

    protected void notifyProjectAddedRemovedFromClasspath(IJavaProject[] added, IJavaProject[] removed) {
    }

    public void releaseListener() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        if (this.projectChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.projectChangeListener);
            this.projectChangeListener = null;
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        this.processElementChanged(event);
    }

    protected void processElementChanged(ElementChangedEvent event) {
        this.processDelta((IJavaElementDelta)event.getSource());
    }

    protected void processChildren(IJavaElement element, IJavaElementDelta delta) {
        IJavaElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processDelta(children[i]);
            ++i;
        }
    }

    protected void processContentChanged(IJavaElementDelta delta) {
    }

    public void processDelta(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        switch (element.getElementType()) {
            case 1: {
                this.processJavaElementChanged((IJavaModel)element, delta);
                break;
            }
            case 2: {
                this.processJavaElementChanged((IJavaProject)element, delta);
                break;
            }
            case 3: {
                this.processJavaElementChanged((IPackageFragmentRoot)element, delta);
                break;
            }
            case 4: {
                this.processJavaElementChanged((IPackageFragment)element, delta);
                break;
            }
            case 5: {
                this.processJavaElementChanged((ICompilationUnit)element, delta);
                this.processContentChanged(delta);
                break;
            }
            case 6: {
                this.processJavaElementChanged((IClassFile)element, delta);
                break;
            }
            case 7: {
                this.processJavaElementChanged((IType)element, delta);
            }
        }
    }

    protected void processJavaElementChanged(IClassFile element, IJavaElementDelta delta) {
    }

    protected void processJavaElementChanged(ICompilationUnit element, IJavaElementDelta delta) {
        this.processChildren((IJavaElement)element, delta);
    }

    protected void processJavaElementChanged(IJavaModel element, IJavaElementDelta delta) {
        this.processChildren((IJavaElement)element, delta);
    }

    protected void processJavaElementChanged(IJavaProject element, IJavaElementDelta delta) {
        this.processChildren((IJavaElement)element, delta);
    }

    protected void processJavaElementChanged(IPackageFragment element, IJavaElementDelta delta) {
        this.processChildren((IJavaElement)element, delta);
    }

    protected void processJavaElementChanged(IPackageFragmentRoot element, IJavaElementDelta delta) {
        this.processChildren((IJavaElement)element, delta);
    }

    protected void processJavaElementChanged(IType element, IJavaElementDelta delta) {
    }

    protected boolean isClassPathChange(IJavaElementDelta delta) {
        int flags = delta.getFlags();
        return delta.getKind() == 4 && (flags & 0x40) != 0 || (flags & 0x80) != 0 || (flags & 0x100) != 0;
    }

    protected boolean isClasspathResourceChange(IJavaElementDelta delta) {
        if ((delta.getFlags() & 0x20000) != 0) {
            return true;
        }
        IResourceDelta[] resources = delta.getResourceDeltas();
        if (resources == null) {
            return false;
        }
        IPath path = null;
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getKind() == 4 && this.isAlsoClasspathChange(path = resources[i].getProjectRelativePath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isAlsoClasspathChange(IPath path) {
        return false;
    }

    protected boolean isInClasspath(IJavaProject javaProject) {
        if (this.projectChangeListener == null) {
            IJavaProject listenerJavaProject = this.getJavaProject();
            if (javaProject.equals(listenerJavaProject)) {
                return true;
            }
            return this.isInClasspath(javaProject, listenerJavaProject, true, new HashSet());
        }
        return this.projectsInClasspath.containsKey(javaProject.getElementName());
    }

    protected abstract IJavaProject getJavaProject();

    protected boolean isInClasspath(IJavaProject testProject, IJavaProject targetProject, boolean isFirstLevel, Set visited) {
        if (visited.contains(targetProject)) {
            return false;
        }
        visited.add(targetProject);
        IClasspathEntry[] entries = null;
        try {
            entries = targetProject.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        ArrayList<IJavaProject> projects = null;
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            switch (entry.getEntryKind()) {
                case 2: {
                    IJavaProject entryProject = this.getVisibleJavaProject(entry, isFirstLevel);
                    if (entryProject == null) break;
                    if (entryProject.equals(testProject)) {
                        return true;
                    }
                    if (projects == null) {
                        projects = new ArrayList<IJavaProject>();
                    }
                    projects.add(entryProject);
                    break;
                }
                case 5: {
                    IClasspathContainer container = null;
                    try {
                        container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)targetProject);
                    }
                    catch (JavaModelException e) {
                        JEMPlugin.getPlugin().getLogger().logError((Throwable)e);
                    }
                    if (container == null || container.getKind() != 1) break;
                    IClasspathEntry[] containerEntries = container.getClasspathEntries();
                    int j = 0;
                    while (j < containerEntries.length) {
                        IJavaProject conEntryProject;
                        if (containerEntries[j].getEntryKind() == 2 && (conEntryProject = this.getVisibleJavaProject(containerEntries[j], isFirstLevel)) != null) {
                            if (conEntryProject.equals(testProject)) {
                                return true;
                            }
                            if (projects == null) {
                                projects = new ArrayList();
                            }
                            projects.add(conEntryProject);
                        }
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
        return this.isInClasspath(testProject, projects, false, visited);
    }

    private IJavaProject getVisibleJavaProject(IClasspathEntry entry, boolean isFirstLevel) {
        if (isFirstLevel || entry.isExported()) {
            IClasspathEntry resEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
            return this.getJavaProject(resEntry);
        }
        return null;
    }

    protected boolean isInClasspath(IJavaProject testProject, List someJavaProjects, boolean isFirstLevel, Set visited) {
        if (someJavaProjects == null) {
            return false;
        }
        int size = someJavaProjects.size();
        IJavaProject javaProj = null;
        int i = 0;
        if (i < size) {
            javaProj = (IJavaProject)someJavaProjects.get(i);
            return this.isInClasspath(testProject, javaProj, isFirstLevel, visited);
        }
        return false;
    }

    protected IJavaProject getJavaProject(IClasspathEntry entry) {
        IProject proj = this.getWorkspaceRoot().getProject(entry.getPath().segment(0));
        if (proj != null) {
            return JavaCore.create((IProject)proj);
        }
        return null;
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    static /* synthetic */ Map access$0(JavaModelListener javaModelListener) {
        return javaModelListener.projectsInClasspath;
    }
}

