/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ve.internal.cde.core.DistributeHandle;

public class DistributeFigure
extends Polyline
implements MouseMotionListener {
    protected Rectangle fBounds = new Rectangle();

    public DistributeFigure() {
        this.setBackgroundColor(ColorConstants.blue);
        this.setLineStyle(2);
        this.setForegroundColor(ColorConstants.white);
        this.setPointsBasedOnRectangle();
    }

    public void setBoundingBox(Rectangle rect) {
        this.fBounds.setBounds(rect);
        this.setPointsBasedOnRectangle();
    }

    protected void handleDrag(MouseEvent me) {
        int locType = ((DistributeHandle)((Object)me.getSource())).getLocatorType();
        Point p = me.getLocation();
        switch (locType) {
            case 1: {
                this.fBounds.height += this.fBounds.y - p.y;
                this.fBounds.y = p.y;
                break;
            }
            case 4: {
                this.fBounds.height = p.y - this.fBounds.y;
                break;
            }
            case 16: {
                this.fBounds.width = p.x - this.fBounds.x;
                break;
            }
            case 8: {
                this.fBounds.width += this.fBounds.x - p.x;
                this.fBounds.x = p.x;
                break;
            }
            case 9: {
                this.fBounds.width += this.fBounds.x - p.x;
                this.fBounds.x = p.x;
                this.fBounds.height += this.fBounds.y - p.y;
                this.fBounds.y = p.y;
                break;
            }
            case 17: {
                this.fBounds.width = p.x - this.fBounds.x;
                this.fBounds.height += this.fBounds.y - p.y;
                this.fBounds.y = p.y;
                break;
            }
            case 12: {
                this.fBounds.width += this.fBounds.x - p.x;
                this.fBounds.x = p.x;
                this.fBounds.height = p.y - this.fBounds.y;
                break;
            }
            case 20: {
                this.fBounds.width = p.x - this.fBounds.x;
                this.fBounds.height = p.y - this.fBounds.y;
                break;
            }
            default: {
                this.fBounds.height += this.fBounds.y - p.y;
                this.fBounds.y = p.y;
            }
        }
        this.setPointsBasedOnRectangle();
    }

    public void mouseHover(MouseEvent me) {
    }

    public void mouseMoved(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mouseDragged(MouseEvent me) {
        this.handleDrag(me);
    }

    protected void setPointsBasedOnRectangle() {
        PointList pl = new PointList(5);
        pl.addPoint(this.fBounds.getTopLeft());
        pl.addPoint(this.fBounds.getTopRight());
        pl.addPoint(this.fBounds.getBottomRight());
        pl.addPoint(this.fBounds.getBottomLeft());
        pl.addPoint(this.fBounds.getTopLeft());
        this.setPoints(pl);
        this.fireFigureMoved();
        if (this.isCoordinateSystem()) {
            this.fireCoordinateSystemChanged();
        }
    }

    protected void outlineShape(Graphics g) {
        g.setXORMode(true);
        super.outlineShape(g);
    }
}

