/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.CDEUtilities;

public interface IErrorHolder {
    public static final int ERROR_SEVERE = 3;
    public static final int ERROR_WARNING = 2;
    public static final int ERROR_INFO = 1;
    public static final int ERROR_NONE = 0;
    public static final Class ERROR_HOLDER_TYPE;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.ve.internal.cde.core.IErrorHolder");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ERROR_HOLDER_TYPE = clazz;
    }

    public int getErrorStatus();

    public List getErrors();

    public static class ErrorType {
        private int severity;
        protected static Image INFORMATION_IMAGE;
        protected static Image INFORMATION_OVERLAY_IMAGE;
        protected static Image WARNING_IMAGE;
        protected static Image WARNING_OVERLAY_IMAGE;
        protected static Image SEVERE_ERROR_IMAGE;
        protected static Image SEVERE_ERROR_OVERLAY_IMAGE;
        private ErrorType cause;

        public ErrorType(int severity) {
            this.severity = severity;
        }

        public ErrorType(int severity, ErrorType cause) {
            this(severity);
            this.cause = cause;
        }

        public ErrorType getCause() {
            return this.cause;
        }

        public String getMessage() {
            if (this.cause != null) {
                return this.cause.getMessage();
            }
            return "";
        }

        public int getSeverity() {
            return this.severity;
        }

        public Image getImage() {
            switch (this.severity) {
                case 3: {
                    return ErrorType.getSevereErrorImage();
                }
                case 2: {
                    return ErrorType.getWarningErrorImage();
                }
                case 1: {
                    return ErrorType.getInformationErrorImage();
                }
            }
            return null;
        }

        public static Image getSevereErrorImage() {
            if (SEVERE_ERROR_IMAGE == null) {
                SEVERE_ERROR_IMAGE = CDEPlugin.getImageFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/cview16/error_obj.gif");
            }
            return SEVERE_ERROR_IMAGE;
        }

        public static Image getWarningErrorImage() {
            if (WARNING_IMAGE == null) {
                WARNING_IMAGE = CDEPlugin.getImageFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/cview16/warning_obj.gif");
            }
            return WARNING_IMAGE;
        }

        public static Image getSevereErrorImageOverlay() {
            if (SEVERE_ERROR_OVERLAY_IMAGE == null) {
                SEVERE_ERROR_OVERLAY_IMAGE = CDEPlugin.getImageFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/cview16/error_overlay.gif");
            }
            return SEVERE_ERROR_OVERLAY_IMAGE;
        }

        public static Image getWarningErrorImageOverlay() {
            if (WARNING_OVERLAY_IMAGE == null) {
                WARNING_OVERLAY_IMAGE = CDEPlugin.getImageFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/cview16/warning_overlay.gif");
            }
            return WARNING_OVERLAY_IMAGE;
        }

        public static Image getInformationErrorImageOverlay() {
            if (INFORMATION_OVERLAY_IMAGE == null) {
                INFORMATION_OVERLAY_IMAGE = CDEPlugin.getImageFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/cview16/info_overlay.gif");
            }
            return INFORMATION_OVERLAY_IMAGE;
        }

        public static Image getInformationErrorImage() {
            if (INFORMATION_IMAGE == null) {
                Display display = Display.getCurrent();
                ImageData id = display.getSystemImage(2).getImageData();
                id = id.scaledTo(16, 16);
                INFORMATION_IMAGE = new Image((Device)display, id);
            }
            return INFORMATION_IMAGE;
        }
    }

    public static class MessageError
    extends ErrorType {
        private final String message;

        public MessageError(String message, int severity) {
            super(severity);
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class ExceptionError
    extends ErrorType {
        private Throwable error;

        public ExceptionError(Throwable error, int severity) {
            super(severity);
            this.error = error;
            CDEPlugin.getPlugin().getLogger().log(error, Level.INFO);
        }

        public ExceptionError(Throwable error) {
            this(error, 2);
        }

        public String getMessage() {
            return CDEUtilities.stripNewLineTabs(MessageFormat.format(CDEMessages.Exception_msg, this.getExceptionClassname(), this.getExceptionMessage()), ' ', '-');
        }

        protected String getExceptionClassname() {
            return this.error.getClass().getName();
        }

        protected String getExceptionMessage() {
            return this.error.getLocalizedMessage();
        }

        public Throwable getException() {
            return this.error;
        }
    }

    public static class PropertyError
    extends ErrorType {
        protected EStructuralFeature fStructuralFeature;
        protected Object fObjectInError;

        protected static String getPropertyMessageFormat() {
            return CDEMessages.PropertyError_msg;
        }

        protected String getPropertyName() {
            return this.fStructuralFeature.getName();
        }

        public PropertyError(Throwable error, int severity, EStructuralFeature sf) {
            this(severity, new ExceptionError(error, severity), sf, null);
        }

        public PropertyError(int severity, Throwable error, EStructuralFeature sf, Object objectInError) {
            this(severity, new ExceptionError(error, severity), sf, objectInError);
        }

        public PropertyError(int severity, ErrorType error, EStructuralFeature sf, Object objectInError) {
            super(severity, error);
            this.fStructuralFeature = sf;
            this.fObjectInError = objectInError;
        }

        public EStructuralFeature getFeature() {
            return this.fStructuralFeature;
        }

        public String getMessage() {
            return MessageFormat.format(PropertyError.getPropertyMessageFormat(), this.getPropertyName(), this.getCause().getMessage());
        }

        public Object getErrorObject() {
            return this.fObjectInError;
        }
    }
}

