/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public interface ToolTipProcessor {
    public IFigure createFigure();

    public void activate();

    public void deactivate();

    public static class ToolTipLabel
    implements ToolTipProcessor {
        String text = "";
        static final Font labelFont = new Font((Device)Display.getDefault(), "Arial", 8, 1);

        public ToolTipLabel(String text) {
            this.text = text;
        }

        public IFigure createFigure() {
            Label l = new Label(this.text);
            l.setFont(labelFont);
            return l;
        }

        public void activate() {
        }

        public void deactivate() {
        }
    }

    public static class ToolTipSeparator
    implements ToolTipProcessor {
        public IFigure createFigure() {
            return new Figure(this){
                final /* synthetic */ ToolTipSeparator this$1;
                {
                    this.this$1 = toolTipSeparator;
                }

                public void paint(Graphics graphics) {
                    Rectangle bounds = this.getBounds();
                    graphics.setForegroundColor(ColorConstants.lightGray);
                    graphics.drawLine(bounds.x, bounds.y + 1, bounds.x + bounds.width, bounds.y + 1);
                }

                public Dimension getPreferredSize(int wHint, int hHint) {
                    return new Dimension(this.getParent().getBounds().width, 2);
                }
            };
        }

        public void activate() {
        }

        public void deactivate() {
        }
    }
}

