/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.ForwardedRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.ve.internal.cde.commands.CancelVisualConstraintCommand;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.IConstraintHandler;
import org.eclipse.ve.internal.cde.core.IModelAdapterFactory;
import org.eclipse.ve.internal.cde.core.VisualInfoPolicy;
import org.eclipse.ve.internal.cdm.VisualInfo;

public abstract class ContainerPolicy {
    protected Object container;
    protected EditDomain domain;
    static /* synthetic */ Class class$0;

    public ContainerPolicy(EditDomain domain) {
        this.domain = domain;
    }

    public Object getContainer() {
        return this.container;
    }

    public EditDomain getEditDomain() {
        return this.domain;
    }

    public void setContainer(Object container) {
        this.container = container;
    }

    public abstract Result getAddCommand(List var1, Object var2);

    public Result getAddCommand(Object child, Object positionBeforeChild) {
        return this.getAddCommand(Collections.singletonList(child), positionBeforeChild);
    }

    public Result getCreateCommand(Object child, Object positionBeforeChild) {
        return this.getCreateCommand(Collections.singletonList(child), positionBeforeChild);
    }

    public abstract Result getCreateCommand(List var1, Object var2);

    public Result getDeleteDependentCommand(Object child) {
        return this.getDeleteDependentCommand(Collections.singletonList(child));
    }

    public abstract Result getDeleteDependentCommand(List var1);

    protected abstract Result getOrphanTheChildrenCommand(List var1);

    public final Result getOrphanChildrenCommand(List children) {
        Result result = this.getOrphanTheChildrenCommand(children);
        Command cmd = result.getCommand();
        if (cmd.canExecute()) {
            Iterator childrenItr = children.iterator();
            while (childrenItr.hasNext()) {
                IConstraintHandler constraintHandler;
                Object child = childrenItr.next();
                List vis = VisualInfoPolicy.getAllVisualInfos(child, this.getEditDomain());
                if (!vis.isEmpty()) {
                    Iterator viItr = vis.iterator();
                    while (viItr.hasNext()) {
                        VisualInfo vi = (VisualInfo)viItr.next();
                        if (!vi.getKeyedValues().containsKey((Object)"org.eclipse.ve.internal.cdm.model.visualconstraintkey")) continue;
                        CancelVisualConstraintCommand delCommand = new CancelVisualConstraintCommand();
                        delCommand.setTarget(vi);
                        cmd = cmd.chain((Command)delCommand);
                    }
                }
                if ((constraintHandler = this.getChildConstraintHandler(child)) == null) continue;
                cmd = cmd.chain(constraintHandler.contributeOrphanChildCommand());
            }
            result.setCommand(cmd);
        }
        return result;
    }

    protected IConstraintHandler getChildConstraintHandler(Object child) {
        IConstraintHandler iConstraintHandler;
        IModelAdapterFactory factory = CDEUtilities.getModelAdapterFactory(this.getEditDomain());
        if (factory != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.core.IConstraintHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iConstraintHandler = (IConstraintHandler)factory.getAdapter(child, clazz);
        } else {
            iConstraintHandler = null;
        }
        return iConstraintHandler;
    }

    public abstract Command getMoveChildrenCommand(List var1, Object var2);

    public static List getChildren(GroupRequest request) {
        List cEP = request.getEditParts();
        ArrayList<Object> children = new ArrayList<Object>(cEP.size());
        Iterator itr = cEP.iterator();
        while (itr.hasNext()) {
            Object child = ((EditPart)itr.next()).getModel();
            children.add(child);
        }
        return children;
    }

    public Command getCommand(Request request) {
        if (this.container == null) {
            return null;
        }
        if ("delete dependant".equals(request.getType())) {
            return this.getDeleteDependentCommand(((ForwardedRequest)request).getSender().getModel()).getCommand();
        }
        if ("create child".equals(request.getType())) {
            return this.getCreateCommand(((CreateRequest)request).getNewObject(), null).getCommand();
        }
        if ("add children".equals(request.getType())) {
            return this.getAddCommand(ContainerPolicy.getChildren((GroupRequest)request), null).getCommand();
        }
        if ("orphan children".equals(request.getType())) {
            return this.getOrphanChildrenCommand(ContainerPolicy.getChildren((GroupRequest)request)).getCommand();
        }
        return null;
    }

    public static class Result {
        protected Command command;
        protected List children;

        public Result(List children) {
            this.children = children;
        }

        public final Command getCommand() {
            return this.command;
        }

        public final List getChildren() {
            return this.children;
        }

        public void setCommand(Command command) {
            this.command = command;
        }

        public void setChildren(List children) {
            this.children = children;
        }
    }
}

