/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cdm.impl;

import com.ibm.icu.util.StringTokenizer;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.ve.internal.cdm.AnnotationEMF;
import org.eclipse.ve.internal.cdm.AnnotationGeneric;
import org.eclipse.ve.internal.cdm.CDMFactory;
import org.eclipse.ve.internal.cdm.CDMPackage;
import org.eclipse.ve.internal.cdm.Diagram;
import org.eclipse.ve.internal.cdm.DiagramData;
import org.eclipse.ve.internal.cdm.DiagramFigure;
import org.eclipse.ve.internal.cdm.VisualInfo;
import org.eclipse.ve.internal.cdm.impl.AnnotationEMFImpl;
import org.eclipse.ve.internal.cdm.impl.AnnotationGenericImpl;
import org.eclipse.ve.internal.cdm.impl.DiagramDataImpl;
import org.eclipse.ve.internal.cdm.impl.DiagramFigureImpl;
import org.eclipse.ve.internal.cdm.impl.DiagramImpl;
import org.eclipse.ve.internal.cdm.impl.KeyedBooleanImpl;
import org.eclipse.ve.internal.cdm.impl.KeyedConstraintImpl;
import org.eclipse.ve.internal.cdm.impl.KeyedDynamicImpl;
import org.eclipse.ve.internal.cdm.impl.KeyedGenericImpl;
import org.eclipse.ve.internal.cdm.impl.KeyedIntegerImpl;
import org.eclipse.ve.internal.cdm.impl.KeyedLocationImpl;
import org.eclipse.ve.internal.cdm.impl.KeyedPointsImpl;
import org.eclipse.ve.internal.cdm.impl.KeyedSizeImpl;
import org.eclipse.ve.internal.cdm.impl.VisualInfoImpl;
import org.eclipse.ve.internal.cdm.model.Dimension;
import org.eclipse.ve.internal.cdm.model.Point;
import org.eclipse.ve.internal.cdm.model.Rectangle;

public class CDMFactoryImpl
extends EFactoryImpl
implements CDMFactory {
    public static CDMFactory init() {
        try {
            CDMFactory theCDMFactory = (CDMFactory)EPackage.Registry.INSTANCE.getEFactory("http:///org/eclipse/ve/internal/cdm.ecore");
            if (theCDMFactory != null) {
                return theCDMFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new CDMFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createDiagramData();
            }
            case 1: {
                return this.createDiagram();
            }
            case 2: {
                return this.createVisualInfo();
            }
            case 4: {
                return (EObject)this.createKeyedLocation();
            }
            case 5: {
                return (EObject)this.createKeyedSize();
            }
            case 6: {
                return (EObject)this.createKeyedConstraint();
            }
            case 8: {
                return (EObject)this.createKeyedPoints();
            }
            case 9: {
                return this.createAnnotationEMF();
            }
            case 10: {
                return this.createAnnotationGeneric();
            }
            case 11: {
                return this.createDiagramFigure();
            }
            case 12: {
                return (EObject)this.createKeyedGeneric();
            }
            case 13: {
                return (EObject)this.createKeyedInteger();
            }
            case 15: {
                return (EObject)this.createKeyedDynamic();
            }
            case 16: {
                return (EObject)this.createKeyedBoolean();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 17: {
                return this.createViewDimensionFromString(eDataType, initialValue);
            }
            case 18: {
                return this.createViewPointFromString(eDataType, initialValue);
            }
            case 19: {
                return this.createViewRectangleFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 17: {
                return this.convertViewDimensionToString(eDataType, instanceValue);
            }
            case 18: {
                return this.convertViewPointToString(eDataType, instanceValue);
            }
            case 19: {
                return this.convertViewRectangleToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public DiagramData createDiagramData() {
        DiagramDataImpl diagramData = new DiagramDataImpl();
        return diagramData;
    }

    public Diagram createDiagram() {
        DiagramImpl diagram = new DiagramImpl();
        return diagram;
    }

    public VisualInfo createVisualInfo() {
        VisualInfoImpl visualInfo = new VisualInfoImpl();
        return visualInfo;
    }

    public Map.Entry createKeyedLocation() {
        KeyedLocationImpl keyedLocation = new KeyedLocationImpl();
        return keyedLocation;
    }

    public Map.Entry createKeyedSize() {
        KeyedSizeImpl keyedSize = new KeyedSizeImpl();
        return keyedSize;
    }

    public Map.Entry createKeyedConstraint() {
        KeyedConstraintImpl keyedConstraint = new KeyedConstraintImpl();
        return keyedConstraint;
    }

    public Map.Entry createKeyedPoints() {
        KeyedPointsImpl keyedPoints = new KeyedPointsImpl();
        return keyedPoints;
    }

    public AnnotationEMF createAnnotationEMF() {
        AnnotationEMFImpl annotationEMF = new AnnotationEMFImpl();
        return annotationEMF;
    }

    public AnnotationGeneric createAnnotationGeneric() {
        AnnotationGenericImpl annotationGeneric = new AnnotationGenericImpl();
        return annotationGeneric;
    }

    public DiagramFigure createDiagramFigure() {
        DiagramFigureImpl diagramFigure = new DiagramFigureImpl();
        return diagramFigure;
    }

    public Map.Entry createKeyedGeneric() {
        KeyedGenericImpl keyedGeneric = new KeyedGenericImpl();
        return keyedGeneric;
    }

    public Map.Entry createKeyedInteger() {
        KeyedIntegerImpl keyedInteger = new KeyedIntegerImpl();
        return keyedInteger;
    }

    public Map.Entry createKeyedDynamic() {
        KeyedDynamicImpl keyedDynamic = new KeyedDynamicImpl();
        return keyedDynamic;
    }

    public Map.Entry createKeyedBoolean() {
        KeyedBooleanImpl keyedBoolean = new KeyedBooleanImpl();
        return keyedBoolean;
    }

    public Dimension createViewDimensionFromString(EDataType eDataType, String initialValue) {
        int height;
        int width;
        StringTokenizer t = new StringTokenizer(initialValue, ",");
        try {
            if (!t.hasMoreTokens()) {
                return null;
            }
            width = Integer.parseInt(t.nextToken());
            if (!t.hasMoreTokens()) {
                return null;
            }
            height = Integer.parseInt(t.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new Dimension(width, height);
    }

    public String convertViewDimensionToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public Point createViewPointFromString(EDataType eDataType, String initialValue) {
        int y;
        int x;
        StringTokenizer t = new StringTokenizer(initialValue, ",");
        try {
            if (!t.hasMoreTokens()) {
                return null;
            }
            x = Integer.parseInt(t.nextToken());
            if (!t.hasMoreTokens()) {
                return null;
            }
            y = Integer.parseInt(t.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new Point(x, y);
    }

    public String convertViewPointToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public Rectangle createViewRectangleFromString(EDataType eDataType, String initialValue) {
        int height;
        int width;
        int y;
        int x;
        StringTokenizer t = new StringTokenizer(initialValue, ",");
        try {
            if (!t.hasMoreTokens()) {
                return null;
            }
            x = Integer.parseInt(t.nextToken());
            if (!t.hasMoreTokens()) {
                return null;
            }
            y = Integer.parseInt(t.nextToken());
            if (!t.hasMoreTokens()) {
                return null;
            }
            width = Integer.parseInt(t.nextToken());
            if (!t.hasMoreTokens()) {
                return null;
            }
            height = Integer.parseInt(t.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new Rectangle(x, y, width, height);
    }

    public String convertViewRectangleToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public CDMPackage getCDMPackage() {
        return (CDMPackage)this.getEPackage();
    }

    public static CDMPackage getPackage() {
        return CDMPackage.eINSTANCE;
    }
}

