/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.commands;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ve.internal.cde.commands.AbstractAttributeCommand;

public abstract class AbstractApplyAttributeCommand
extends AbstractAttributeCommand {
    protected Notifier[] containers;
    protected EReference[] containmentReferences;
    protected int[] containmentIndexes;

    public AbstractApplyAttributeCommand(String name) {
        super(name);
    }

    public AbstractApplyAttributeCommand() {
    }

    public boolean prepare() {
        List values = this.getAttributeSettingValues();
        if (!super.prepare() || values == null || values.isEmpty() || !this.feature.isMany() && values.size() > 1) {
            return false;
        }
        EClassifier mo = this.feature.getEType();
        Iterator itr = values.iterator();
        while (itr.hasNext()) {
            Object n = itr.next();
            if (n == null || mo.isInstance(n)) continue;
            return false;
        }
        return true;
    }

    protected void cancelOldContainment() {
        if (this.feature instanceof EReference && ((EReference)this.feature).isContainment()) {
            this.containers = new EObject[this.getAttributeSettingValues().size()];
            this.containmentReferences = new EReference[this.containers.length];
            this.containmentIndexes = new int[this.containers.length];
            List values = this.getAttributeSettingValues();
            int i = 0;
            while (i < this.containers.length) {
                EObject eo = (EObject)values.get(i);
                EObject container = eo.eContainer();
                if (container == null) {
                    container = eo.eResource();
                }
                if (container != null) {
                    if (container instanceof EObject) {
                        EReference containmentFeature = eo.eContainmentFeature();
                        if (container != this.getTarget() || containmentFeature != this.feature) {
                            this.containers[i] = container;
                            this.containmentReferences[i] = containmentFeature;
                            if (containmentFeature.isMany()) {
                                List s = (List)container.eGet((EStructuralFeature)containmentFeature);
                                this.containmentIndexes[i] = s.indexOf(eo);
                                int n = this.containmentIndexes[i];
                                if (n != -1) {
                                    s.remove(n);
                                } else {
                                    this.containers[i] = null;
                                    this.containmentReferences[i] = null;
                                }
                            } else {
                                this.containmentIndexes[i] = -1;
                                container.eUnset((EStructuralFeature)containmentFeature);
                            }
                        }
                    } else {
                        this.containers[i] = container;
                        EList s = ((Resource)container).getContents();
                        this.containmentIndexes[i] = s.indexOf(eo);
                        int n = this.containmentIndexes[i];
                        if (n != -1) {
                            s.remove(n);
                        } else {
                            this.containers[i] = null;
                            this.containmentReferences[i] = null;
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected void restoreOldContainment() {
        if (this.containers != null) {
            List values = this.getAttributeSettingValues();
            int i = this.containers.length - 1;
            while (i >= 0) {
                if (this.containers[i] != null) {
                    if (this.containers[i] instanceof EObject) {
                        if (this.containmentReferences[i].isMany()) {
                            ((List)((EObject)this.containers[i]).eGet((EStructuralFeature)this.containmentReferences[i])).add(this.containmentIndexes[i], values.get(i));
                        } else {
                            ((EObject)this.containers[i]).eSet((EStructuralFeature)this.containmentReferences[i], values.get(i));
                        }
                    } else {
                        ((Resource)this.containers[i]).getContents().add(this.containmentIndexes[i], values.get(i));
                    }
                }
                --i;
            }
            this.containers = null;
            this.containmentReferences = null;
            this.containmentIndexes = null;
        }
    }
}

