/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.AnnotationPolicy;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.cdm.AnnotationEMF;
import org.eclipse.ve.internal.cdm.AnnotationGeneric;
import org.eclipse.ve.internal.cdm.CDMPackage;
import org.eclipse.ve.internal.cdm.Diagram;
import org.eclipse.ve.internal.cdm.DiagramData;
import org.eclipse.ve.internal.cdm.VisualInfo;

public abstract class AnnotationLinkagePolicy {
    public Annotation getAnnotation(Object modelObject) {
        if (modelObject == null) {
            return null;
        }
        if (modelObject instanceof EObject) {
            EObject mo = (EObject)modelObject;
            AnnotationEMF.ParentAdapter a = (AnnotationEMF.ParentAdapter)EcoreUtil.getExistingAdapter((Notifier)mo, (Object)AnnotationEMF.ParentAdapter.PARENT_ANNOTATION_ADAPTER_KEY);
            return a != null ? a.getParentAnnotation() : null;
        }
        return this.getAnnotationFromGeneric(modelObject);
    }

    public abstract void dispose();

    protected abstract Annotation getAnnotationFromGeneric(Object var1);

    public void setModelOnAnnotation(Object model, Annotation annotation) {
        if (annotation instanceof AnnotationEMF) {
            ((AnnotationEMF)annotation).setAnnotates((EObject)model);
        } else {
            this.setModelOnAnnotationGeneric(model, (AnnotationGeneric)annotation);
        }
    }

    protected abstract void setModelOnAnnotationGeneric(Object var1, AnnotationGeneric var2);

    protected abstract void initializeAnnotationGeneric(AnnotationGeneric var1);

    public void initializeAnnotation(Annotation annotation) {
        if (annotation instanceof AnnotationEMF) {
            ((AnnotationEMF)annotation).getAnnotates();
        } else {
            this.initializeAnnotationGeneric((AnnotationGeneric)annotation);
        }
    }

    public void initializeLinkages(DiagramData data) {
        Iterator annotations = data.getAnnotations().iterator();
        while (annotations.hasNext()) {
            this.initializeAnnotation((Annotation)annotations.next());
        }
    }

    protected abstract boolean isAnnotationValidGeneric(AnnotationGeneric var1);

    public Command cleanupDiagramData(DiagramData data) {
        ArrayList<Annotation> delAnn = new ArrayList<Annotation>();
        Iterator annotations = data.getAnnotations().iterator();
        while (annotations.hasNext()) {
            Annotation annotation = (Annotation)annotations.next();
            boolean remove = false;
            if (annotation instanceof AnnotationEMF) {
                EObject model = ((AnnotationEMF)annotation).getAnnotates();
                if (model != null) {
                    if (model.eIsProxy()) {
                        remove = true;
                    } else if (model.eResource() == null) {
                        remove = true;
                    }
                } else {
                    remove = true;
                }
            } else {
                boolean bl = remove = !this.isAnnotationValidGeneric((AnnotationGeneric)annotation);
            }
            if (!remove) continue;
            delAnn.add(annotation);
        }
        CommandBuilder cmdBldr = new CommandBuilder(null);
        cmdBldr.append(AnnotationPolicy.getDeleteCommand(delAnn, data));
        ArrayList<VisualInfo> delVI = new ArrayList<VisualInfo>();
        Iterator diagrams = data.getDiagrams().iterator();
        while (diagrams.hasNext()) {
            Diagram diagram = (Diagram)diagrams.next();
            Iterator vis = diagram.getVisualInfos().iterator();
            while (vis.hasNext()) {
                VisualInfo vi = (VisualInfo)vis.next();
                if (vi.eResource() != null) continue;
                delVI.add(vi);
            }
        }
        if (!delVI.isEmpty()) {
            cmdBldr.cancelGroupAttributeSetting(delVI, (EStructuralFeature)CDMPackage.eINSTANCE.getVisualInfo_Diagram());
        }
        return cmdBldr.getCommand();
    }
}

