/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ve.internal.cde.core.IErrorHolder;

public class ErrorFigure
extends Figure {
    protected int fSev;
    protected Image fImage;

    public ErrorFigure() {
        this(0);
    }

    public ErrorFigure(int severity) {
        this.setSeverity(severity);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.fImage != null) {
            graphics.drawImage(this.fImage, this.getLocation().x, this.getLocation().y);
        }
    }

    public void setSeverity(int severity) {
        this.fSev = severity;
        switch (this.fSev) {
            case 3: {
                this.fImage = IErrorHolder.ErrorType.getSevereErrorImage();
                Rectangle bounds = this.fImage.getBounds();
                this.setSize(new Dimension(bounds.width, bounds.height));
                this.setVisible(true);
                break;
            }
            case 2: {
                this.fImage = IErrorHolder.ErrorType.getWarningErrorImage();
                Rectangle bounds = this.fImage.getBounds();
                this.setSize(new Dimension(bounds.width, bounds.height));
                this.setVisible(true);
                break;
            }
            case 1: {
                this.fImage = IErrorHolder.ErrorType.getInformationErrorImage();
                Rectangle bounds = this.fImage.getBounds();
                this.setSize(new Dimension(bounds.width, bounds.height));
                this.setVisible(true);
                break;
            }
            default: {
                this.setSize(0, 0);
                this.setVisible(false);
            }
        }
    }
}

