/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.Iterator;
import org.eclipse.gef.Disposable;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.PaletteToolEntryAction;

public class PaletteToolbarDropDownAction
extends PaletteToolEntryAction
implements Disposable,
IMenuCreator {
    protected PaletteRoot paletteRoot;
    protected MenuManager toolbarMenuManager;

    public PaletteToolbarDropDownAction() {
        super(4);
        this.setEnabled(false);
    }

    public PaletteToolbarDropDownAction(EditDomain editDomain) {
        super(4);
        this.setEditDomain(editDomain);
        this.setEnabled(false);
    }

    public void setPaletteRoot(PaletteRoot paletteRoot) {
        this.paletteRoot = paletteRoot;
        if (this.toolbarMenuManager != null) {
            this.initializeToolbarMenuManager();
        }
    }

    public void dispose() {
        if (this.toolbarMenuManager != null) {
            this.disposeToolbarMenuManager();
        }
    }

    protected void disposeToolbarMenuManager() {
        this.toolbarMenuManager.dispose();
        this.toolbarMenuManager = null;
    }

    public Menu getMenu(Control parent) {
        if (this.toolbarMenuManager == null) {
            this.initializeToolbarMenuManager();
        }
        return this.toolbarMenuManager.createContextMenu(parent);
    }

    protected void initializeToolbarMenuManager() {
        if (this.toolbarMenuManager == null) {
            this.toolbarMenuManager = new MenuManager();
        } else {
            this.toolbarMenuManager.removeAll();
        }
        Iterator iter = this.paletteRoot.getChildren().iterator();
        while (iter.hasNext()) {
            Object paletteChild = iter.next();
            if (paletteChild instanceof PaletteGroup || !(paletteChild instanceof PaletteDrawer)) continue;
            this.addContainerToMenu((PaletteContainer)paletteChild, (IMenuManager)this.toolbarMenuManager);
        }
    }

    protected void addToolEntryToMenu(ToolEntry toolEntry, IMenuManager aMenuManager) {
        PaletteToolEntryAction entryAction = new PaletteToolEntryAction(this, toolEntry);
        aMenuManager.add((IAction)entryAction);
    }

    protected void addContainerToMenu(PaletteContainer container, IMenuManager menuManager) {
        if (container instanceof PaletteDrawer) {
            IMenuManager parentMenuManager = menuManager;
            menuManager = new MenuManager(container.getLabel());
            parentMenuManager.add((IContributionItem)menuManager);
        } else {
            menuManager.add((IContributionItem)new Separator());
        }
        Iterator entries = container.getChildren().iterator();
        while (entries.hasNext()) {
            Object entry = entries.next();
            if (entry instanceof ToolEntry) {
                this.addToolEntryToMenu((ToolEntry)entry, menuManager);
                continue;
            }
            if (!(entry instanceof PaletteContainer)) continue;
            this.addContainerToMenu((PaletteContainer)entry, menuManager);
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public IMenuCreator getMenuCreator() {
        return this;
    }
}

