/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.emf;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.ve.internal.cde.emf.CDEEmfMessages;

public abstract class ClassDecoratorIterator
implements Iterator {
    protected ListIterator fSuperItr;
    protected EAnnotation fNext;

    protected ClassDecoratorIterator(EClassifier startWith) {
        if (startWith instanceof EClass) {
            EList allsupers = ((EClass)startWith).getEAllSuperTypes();
            this.fSuperItr = allsupers.listIterator(allsupers.size());
        }
    }

    protected void initialize(EClassifier startWith) {
        this.fNext = this.findDecorator(startWith);
        if (this.fNext == null) {
            this.fNext = this.findNext();
        }
    }

    protected abstract EAnnotation findDecorator(EClassifier var1);

    public boolean hasNext() {
        return this.fNext != null;
    }

    public Object next() {
        EAnnotation result = this.fNext;
        this.fNext = this.findNext();
        return result;
    }

    public void remove() {
        throw new UnsupportedOperationException(MessageFormat.format(CDEEmfMessages.ClassDecoratorIterator_UnsupportedRemove_Object__EXC_, this.getClass().getName()));
    }

    protected EAnnotation findNext() {
        if (this.fSuperItr == null) {
            return null;
        }
        if (this.fSuperItr.hasPrevious()) {
            EAnnotation next = this.findDecorator((EClassifier)this.fSuperItr.previous());
            if (next == null) {
                return this.findNext();
            }
            return next;
        }
        return null;
    }
}

