/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.emf;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.IModelAdapter;
import org.eclipse.ve.internal.cde.core.IModelAdapterFactory;
import org.eclipse.ve.internal.cde.emf.ClassDescriptorDecoratorPolicy;

public class DefaultModelAdapterFactory
implements IModelAdapterFactory {
    protected ClassDescriptorDecoratorPolicy policy;
    protected Map classStringToConstructor = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DefaultModelAdapterFactory(ClassDescriptorDecoratorPolicy policy) {
        this.policy = policy;
    }

    public IModelAdapter getAdapter(Object modelObject, Class adapterClass) {
        EditPart ep;
        IModelAdapter adapter;
        if (adapterClass.isInstance(modelObject)) {
            return (IModelAdapter)modelObject;
        }
        if (modelObject instanceof IAdaptable && (adapter = (IModelAdapter)((IAdaptable)modelObject).getAdapter(adapterClass)) != null) {
            return adapter;
        }
        adapter = this.createAdapter(modelObject, adapterClass);
        if (adapter != null) {
            return adapter;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.core.IConstraintHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapterClass == clazz && (ep = this.createEditPart(modelObject)) != null) {
            return (IModelAdapter)ep.getAdapter(adapterClass);
        }
        return null;
    }

    public boolean typeHasAdapter(Object type, Class adapter) {
        return type instanceof EClassifier && this.policy.getModelAdapterClassname((EClassifier)type) != null;
    }

    public IModelAdapter getSuperAdapter(Object superType, Object modelObject, Class adapter) {
        boolean cfr_ignored_0 = superType instanceof EClassifier;
        return null;
    }

    protected IModelAdapter createAdapter(Object modelObject, Class adaptTo) {
        if (!(modelObject instanceof EObject)) {
            return null;
        }
        return this.createAdapter((EClassifier)((EObject)modelObject).eClass(), modelObject, adaptTo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IModelAdapter createAdapter(EClassifier type, Object modelObject, Class adaptTo) {
        String classString = this.policy.getModelAdapterClassname(type);
        if (classString == null) {
            return null;
        }
        try {
            try {
                IModelAdapter adapter;
                Object ctorOrClass = this.getConstructor(classString);
                if (ctorOrClass instanceof Constructor) {
                    Constructor constructor = (Constructor)ctorOrClass;
                    if (!adaptTo.isAssignableFrom(constructor.getDeclaringClass())) {
                        return null;
                    }
                    adapter = (IModelAdapter)constructor.newInstance(modelObject);
                } else {
                    Class clazz = (Class)ctorOrClass;
                    if (!adaptTo.isAssignableFrom(clazz)) {
                        return null;
                    }
                    adapter = (IModelAdapter)clazz.newInstance();
                }
                CDEPlugin.setInitializationData(adapter, classString, null);
                return adapter;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        catch (Exception e) {
            String message = MessageFormat.format(CDEMessages.Object_noinstantiate_EXC_, classString);
            Status s = new Status(2, CDEPlugin.getPlugin().getPluginID(), 0, message, (Throwable)e);
            CDEPlugin.getPlugin().getLog().log((IStatus)s);
            return null;
        }
    }

    protected Object getConstructor(String classString) throws NoSuchMethodException {
        if (this.classStringToConstructor.containsKey(classString)) {
            Object ctorOrClass = this.classStringToConstructor.get(classString);
            if (ctorOrClass == null) {
                throw new NoSuchMethodException(classString);
            }
            return ctorOrClass;
        }
        try {
            Class adapterClass = CDEPlugin.getClassFromString(classString);
            GenericDeclaration ctorOrClass = null;
            try {
                Class[] classArray = new Class[1];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                ctorOrClass = adapterClass.getConstructor(classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    adapterClass.getConstructor(null);
                    ctorOrClass = adapterClass;
                }
                catch (NoSuchMethodException e1) {
                    String message = MessageFormat.format(CDEMessages.Object_noinstantiate_EXC_, classString);
                    Status s = new Status(2, CDEPlugin.getPlugin().getPluginID(), 0, message, (Throwable)e1);
                    CDEPlugin.getPlugin().getLog().log((IStatus)s);
                    this.classStringToConstructor.put(classString, null);
                    throw new NoSuchMethodException(classString);
                }
            }
            this.classStringToConstructor.put(classString, ctorOrClass);
            return ctorOrClass;
        }
        catch (ClassNotFoundException e) {
            String message = MessageFormat.format(CDEMessages.Object_noinstantiate_EXC_, classString);
            Status s = new Status(2, CDEPlugin.getPlugin().getPluginID(), 0, message, (Throwable)e);
            CDEPlugin.getPlugin().getLog().log((IStatus)s);
            this.classStringToConstructor.put(classString, null);
            throw new NoSuchMethodException(classString);
        }
    }

    protected EditPart createEditPart(Object modelObject) {
        if (!(modelObject instanceof EObject)) {
            return null;
        }
        String epClassString = this.policy.getGraphViewClassname((EClassifier)((EObject)modelObject).eClass());
        if (epClassString == null) {
            return null;
        }
        try {
            try {
                Object ctorOrClass = this.getConstructor(epClassString);
                EditPart editPart = null;
                if (ctorOrClass instanceof Constructor) {
                    editPart = (EditPart)((Constructor)ctorOrClass).newInstance(modelObject);
                } else {
                    editPart = (EditPart)((Class)ctorOrClass).newInstance();
                    editPart.setModel(modelObject);
                }
                CDEPlugin.setInitializationData(editPart, epClassString, null);
                return editPart;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        catch (Exception e) {
            String message = MessageFormat.format(CDEMessages.Object_noinstantiate_EXC_, epClassString);
            Status s = new Status(2, CDEPlugin.getPlugin().getPluginID(), 0, message, (Throwable)e);
            CDEPlugin.getPlugin().getLog().log((IStatus)s);
            return null;
        }
    }
}

