/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ve.internal.cde.core.ActionBarActionEditPart;
import org.eclipse.ve.internal.cde.core.ActionBarGraphicalEditPart;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.EditPartContributionChangeListener;
import org.eclipse.ve.internal.cde.core.EditPartContributor;
import org.eclipse.ve.internal.cde.core.EditPartContributorFactory;
import org.eclipse.ve.internal.cde.core.EditPartRunnable;
import org.eclipse.ve.internal.cde.core.GraphicalEditPartContributor;
import org.eclipse.ve.internal.cde.core.ToolTipContentHelper;
import org.eclipse.ve.internal.cde.core.ToolTipProcessor;

public abstract class CDEAbstractGraphicalEditPart
extends AbstractGraphicalEditPart {
    protected List fEditPartContributors;
    private ActionBarController fActionBarController = null;
    private ActionBarEditPartListener fActionBarEditPartListener = null;
    private ActionBarFigureListener fHostFigureListener = null;
    private ActionBarActionListener fActionListener = null;
    private EditPartContributionChangeListener fContributionChangeListener;
    private boolean actionBarEditpartSelected = false;
    private List actionBarChildren = Collections.EMPTY_LIST;
    private List figureOverlayCache;
    private List hoverOverlayCache;
    private IFigure figureOverlayPanel;

    private void addEditPartContributor(GraphicalEditPartContributor anEditPartContributor) {
        if (this.fEditPartContributors == null) {
            this.fEditPartContributors = new ArrayList(1);
        }
        this.fEditPartContributors.add(anEditPartContributor);
    }

    protected EditDomain getEditDomain() {
        return EditDomain.getEditDomain((EditPart)this);
    }

    public void activate() {
        List editPartContributorFactories;
        super.activate();
        ToolTipProcessor[] processors = this.createToolTipProcessors();
        if (processors != null && processors.length > 0) {
            ToolTipContentHelper contentHelper = new ToolTipContentHelper(processors);
            this.getFigure().setToolTip((IFigure)contentHelper);
        }
        if ((editPartContributorFactories = this.getEditDomain().getContributors((IAdaptable)this)) != null && !editPartContributorFactories.isEmpty()) {
            this.figureOverlayPanel = new Panel();
            this.figureOverlayPanel.setLayoutManager((LayoutManager)new FlowLayout());
            this.figureOverlayPanel.getBounds().translate(3, 3);
            this.getFigure().add(this.figureOverlayPanel);
            this.fContributionChangeListener = new EditPartContributionChangeListener(){

                public void contributionChanged(EditPartContributor editpartContributor) {
                    CDEAbstractGraphicalEditPart.this.refreshContributions();
                }
            };
            Iterator iter = editPartContributorFactories.iterator();
            while (iter.hasNext()) {
                GraphicalEditPartContributor graphicalEditPartContributor = ((EditPartContributorFactory)iter.next()).getGraphicalEditPartContributor((GraphicalEditPart)this);
                if (graphicalEditPartContributor == null) continue;
                this.addEditPartContributor(graphicalEditPartContributor);
                graphicalEditPartContributor.addContributionChangeListener(this.fContributionChangeListener);
            }
            this.fActionBarController = new ActionBarController();
            this.getFigure().addMouseMotionListener((MouseMotionListener)this.fActionBarController);
            this.fActionBarEditPartListener = new ActionBarEditPartListener();
            this.addEditPartListener((EditPartListener)this.fActionBarEditPartListener);
            this.fHostFigureListener = new ActionBarFigureListener();
            this.getFigure().addFigureListener((FigureListener)this.fHostFigureListener);
            this.fActionListener = new ActionBarActionListener();
            this.addContributions();
            if (this.getFigure().getToolTip() != null && this.getFigure().getToolTip() instanceof ToolTipContentHelper) {
                ((ToolTipContentHelper)this.getFigure().getToolTip()).activate();
            }
        }
    }

    public void deactivate() {
        if (this.fEditPartContributors != null) {
            if (this.fActionBarController != null) {
                this.fActionBarController.hideActionBar();
            }
            Iterator itr = this.fEditPartContributors.iterator();
            while (itr.hasNext()) {
                EditPartContributor contributor = (EditPartContributor)itr.next();
                contributor.dispose();
            }
            this.getFigure().removeMouseMotionListener((MouseMotionListener)this.fActionBarController);
            this.removeEditPartListener((EditPartListener)this.fActionBarEditPartListener);
            this.getFigure().removeFigureListener((FigureListener)this.fHostFigureListener);
            this.fEditPartContributors = null;
        }
        if (this.getFigure().getToolTip() != null && this.getFigure().getToolTip() instanceof ToolTipContentHelper) {
            ((ToolTipContentHelper)this.getFigure().getToolTip()).deactivate();
        }
        super.deactivate();
    }

    public void refresh() {
        super.refresh();
    }

    private void addContributions() {
        if (this.fEditPartContributors != null) {
            Iterator iter = this.fEditPartContributors.iterator();
            this.figureOverlayCache = new ArrayList();
            this.hoverOverlayCache = new ArrayList();
            IFigure toolTipFigure = this.getFigure().getToolTip();
            if (toolTipFigure instanceof ToolTipContentHelper) {
                ToolTipProcessor.ToolTipSeparator separator = new ToolTipProcessor.ToolTipSeparator();
                ((ToolTipContentHelper)toolTipFigure).addToolTipProcessor(separator);
                this.hoverOverlayCache.add(separator);
            }
            while (iter.hasNext()) {
                ToolTipProcessor processor;
                GraphicalEditPartContributor contrib = (GraphicalEditPartContributor)iter.next();
                IFigure figOverlay = contrib.getFigureOverLay();
                if (figOverlay != null) {
                    this.figureOverlayPanel.add(figOverlay);
                    this.figureOverlayPanel.setSize(this.figureOverlayPanel.getPreferredSize());
                    this.figureOverlayCache.add(figOverlay);
                }
                if ((processor = contrib.getHoverOverLay()) != null && toolTipFigure instanceof ToolTipContentHelper) {
                    ((ToolTipContentHelper)toolTipFigure).addToolTipProcessor(processor);
                    this.hoverOverlayCache.add(processor);
                }
                this.actionBarChildren = new ArrayList();
                GraphicalEditPart[] children = contrib.getActionBarChildren();
                if (children == null) continue;
                int i = 0;
                while (i < children.length) {
                    this.actionBarChildren.add(children[i]);
                    ++i;
                }
            }
            if (this.hoverOverlayCache != null && toolTipFigure instanceof ToolTipContentHelper) {
                ((ToolTipContentHelper)toolTipFigure).refresh();
            }
        }
    }

    private void removeContributions() {
        if (this.fEditPartContributors != null) {
            if (this.figureOverlayCache != null && this.figureOverlayPanel != null) {
                Iterator iterator = this.figureOverlayCache.iterator();
                while (iterator.hasNext()) {
                    this.figureOverlayPanel.remove((IFigure)iterator.next());
                }
                this.figureOverlayPanel.setSize(0, 0);
                this.figureOverlayCache = null;
            }
            if (this.hoverOverlayCache != null && this.getFigure().getToolTip() instanceof ToolTipContentHelper) {
                ToolTipContentHelper contentHelper = (ToolTipContentHelper)this.getFigure().getToolTip();
                Iterator iterator = this.hoverOverlayCache.iterator();
                while (iterator.hasNext()) {
                    contentHelper.removeToolTipProcessor((ToolTipProcessor)iterator.next());
                }
                this.hoverOverlayCache = null;
            }
            this.actionBarChildren = Collections.EMPTY_LIST;
        }
    }

    private void refreshContributions() {
        CDEUtilities.displayExec((EditPart)this, "refreshContributions", new EditPartRunnable((EditPart)this){

            protected void doRun() {
                CDEAbstractGraphicalEditPart.this.fActionBarController.hideActionBar();
                CDEAbstractGraphicalEditPart.this.actionBarEditpartSelected = false;
                CDEAbstractGraphicalEditPart.this.removeContributions();
                CDEAbstractGraphicalEditPart.this.addContributions();
            }
        });
    }

    protected abstract ToolTipProcessor[] createToolTipProcessors();

    private class ActionBarController
    extends MouseMotionListener.Stub {
        ActionBarGraphicalEditPart actionBarEditPart = null;
        IFigure actionBarFigure = null;
        boolean mouseInsideActionBar = false;
        boolean mouseInsideControlFigure = false;
        boolean actionBarVisible = false;
        public Runnable showActionBarRunnable = new Runnable(this){
            final /* synthetic */ ActionBarController this$1;
            {
                this.this$1 = actionBarController;
            }

            public void run() {
                if (this.this$1.mouseInsideActionBar || this.this$1.mouseInsideControlFigure) {
                    this.this$1.showActionBar();
                }
            }
        };
        public Runnable hideActionBarRunnable = new Runnable(this){
            final /* synthetic */ ActionBarController this$1;
            {
                this.this$1 = actionBarController;
            }

            public void run() {
                if (!(this.this$1.mouseInsideActionBar || this.this$1.mouseInsideControlFigure || CDEAbstractGraphicalEditPart.access$0(ActionBarController.access$1(this.this$1)))) {
                    this.this$1.hideActionBar();
                }
            }
        };
        static /* synthetic */ Class class$0;

        private ActionBarController() {
        }

        private ActionBarGraphicalEditPart getActionBarEditPart() {
            if (this.actionBarEditPart == null) {
                EditDomain editDomain = CDEAbstractGraphicalEditPart.this.getEditDomain();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.core.ActionBarGraphicalEditPart");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.actionBarEditPart = (ActionBarGraphicalEditPart)((Object)editDomain.getData(clazz));
            }
            return this.actionBarEditPart;
        }

        public void mouseEntered(MouseEvent me) {
            if (this.actionBarFigure == me.getSource() || this.mouseWithinActionBar(me)) {
                this.mouseInsideActionBar = true;
            }
            if (me.getSource() == CDEAbstractGraphicalEditPart.this.getFigure()) {
                this.mouseInsideControlFigure = true;
            }
            if (this.mouseInsideActionBar || this.mouseInsideControlFigure) {
                Display.getCurrent().timerExec(500, this.showActionBarRunnable);
            }
        }

        public void mouseExited(MouseEvent me) {
            if (me.getSource() == CDEAbstractGraphicalEditPart.this.getFigure()) {
                this.mouseInsideControlFigure = false;
            }
            if (!this.mouseWithinActionBar(me)) {
                this.mouseInsideActionBar = false;
            }
            if (!(this.mouseInsideActionBar || this.mouseInsideControlFigure || CDEAbstractGraphicalEditPart.this.actionBarEditpartSelected)) {
                Display.getCurrent().timerExec(500, this.hideActionBarRunnable);
            }
        }

        public void mouseMoved(MouseEvent me) {
            if (this.mouseWithinActionBar(me)) {
                this.highlightActionBarChildren(me);
            }
        }

        private boolean mouseWithinActionBar(MouseEvent me) {
            if (this.actionBarFigure == null) {
                return false;
            }
            Rectangle bounds = this.actionBarFigure.getBounds();
            return bounds.x < me.x && bounds.y < me.y && bounds.x + bounds.width > me.x && bounds.y + bounds.height > me.y;
        }

        private void highlightActionBarChildren(MouseEvent me) {
            if (this.actionBarFigure == null) {
                return;
            }
            List children = this.actionBarEditPart.getChildren();
            int i = 0;
            while (i < children.size()) {
                if (children.get(i) instanceof ActionBarActionEditPart) {
                    IFigure child = ((GraphicalEditPart)children.get(i)).getFigure();
                    Rectangle bounds = child.getBounds();
                    if (bounds.x < me.x && bounds.y < me.y && bounds.x + bounds.width > me.x && bounds.y + bounds.height > me.y) {
                        if (child.getBorder() == null) {
                            child.setBorder(new Border(this){
                                final /* synthetic */ ActionBarController this$1;
                                {
                                    this.this$1 = actionBarController;
                                }

                                public Insets getInsets(IFigure figure) {
                                    return new Insets();
                                }

                                public Dimension getPreferredSize(IFigure figure) {
                                    return null;
                                }

                                public boolean isOpaque() {
                                    return false;
                                }

                                public void paint(IFigure figure, Graphics graphics, Insets insets) {
                                    graphics.setForegroundColor(ColorConstants.black);
                                    Rectangle rect = figure.getBounds().getCopy();
                                    --rect.width;
                                    --rect.height;
                                    graphics.drawRectangle(rect);
                                }
                            });
                            child.repaint();
                        }
                    } else if (child.getBorder() != null) {
                        child.setBorder(null);
                        child.repaint();
                    }
                }
                ++i;
            }
        }

        public void showActionBar() {
            if (this.actionBarFigure == null && this.getActionBarEditPart().getChildren().isEmpty()) {
                this.actionBarFigure = this.getActionBarEditPart().getFigure();
                this.populateActionBar();
                if (CDEAbstractGraphicalEditPart.this.actionBarChildren != null && !CDEAbstractGraphicalEditPart.this.actionBarChildren.isEmpty()) {
                    this.actionBarFigure.addMouseMotionListener((MouseMotionListener)CDEAbstractGraphicalEditPart.this.fActionBarController);
                    if (!this.actionBarVisible) {
                        this.getActionBarEditPart().show(CDEAbstractGraphicalEditPart.this.getFigure().getBounds().getCopy(), 0);
                        this.actionBarVisible = true;
                    }
                }
            }
        }

        public void hideActionBar() {
            this.mouseInsideActionBar = false;
            if (this.actionBarVisible) {
                this.actionBarFigure.removeMouseMotionListener((MouseMotionListener)CDEAbstractGraphicalEditPart.this.fActionBarController);
                this.getActionBarEditPart().removeEditPartListener((EditPartListener)CDEAbstractGraphicalEditPart.this.fActionBarEditPartListener);
                int i = 0;
                while (i < CDEAbstractGraphicalEditPart.this.actionBarChildren.size()) {
                    ((EditPart)CDEAbstractGraphicalEditPart.this.actionBarChildren.get(i)).removeEditPartListener((EditPartListener)CDEAbstractGraphicalEditPart.this.fActionBarEditPartListener);
                    ++i;
                }
                this.actionBarVisible = false;
                this.getActionBarEditPart().hide();
                this.mouseInsideActionBar = false;
                this.getActionBarEditPart().addActionBarChildren(Collections.EMPTY_LIST);
                this.getActionBarEditPart().refresh();
                this.actionBarFigure = null;
                this.actionBarEditPart = null;
            }
        }

        private void populateActionBar() {
            if (!CDEAbstractGraphicalEditPart.this.actionBarChildren.isEmpty()) {
                this.getActionBarEditPart().addEditPartListener((EditPartListener)CDEAbstractGraphicalEditPart.this.fActionBarEditPartListener);
                this.getActionBarEditPart().addActionBarChildren(CDEAbstractGraphicalEditPart.this.actionBarChildren);
                this.getActionBarEditPart().refresh();
            }
        }

        static /* synthetic */ CDEAbstractGraphicalEditPart access$1(ActionBarController actionBarController) {
            return actionBarController.CDEAbstractGraphicalEditPart.this;
        }
    }

    class ActionBarEditPartListener
    extends EditPartListener.Stub {
        ActionBarEditPartListener() {
        }

        public void childAdded(EditPart editpart, int arg1) {
            if (editpart != null) {
                if (editpart instanceof ActionBarActionEditPart) {
                    ((ActionBarActionEditPart)editpart).addActionListener(CDEAbstractGraphicalEditPart.this.fActionListener);
                    ((ActionBarActionEditPart)editpart).getFigure().addMouseMotionListener((MouseMotionListener)CDEAbstractGraphicalEditPart.this.fActionBarController);
                }
                editpart.addEditPartListener((EditPartListener)CDEAbstractGraphicalEditPart.this.fActionBarEditPartListener);
            }
        }

        public void removingChild(EditPart child, int index) {
            if (child instanceof ActionBarActionEditPart) {
                ((ActionBarActionEditPart)child).removeActionListener(CDEAbstractGraphicalEditPart.this.fActionListener);
                ((ActionBarActionEditPart)child).getFigure().removeMouseMotionListener((MouseMotionListener)CDEAbstractGraphicalEditPart.this.fActionBarController);
            }
            child.removeEditPartListener((EditPartListener)CDEAbstractGraphicalEditPart.this.fActionBarEditPartListener);
        }

        public void selectedStateChanged(EditPart part) {
            if (part != null && part.getSelected() == 2 && (CDEAbstractGraphicalEditPart.this.actionBarChildren.contains(part) || part == CDEAbstractGraphicalEditPart.this)) {
                Display.getCurrent().asyncExec(((CDEAbstractGraphicalEditPart)CDEAbstractGraphicalEditPart.this).fActionBarController.showActionBarRunnable);
                if (CDEAbstractGraphicalEditPart.this.actionBarChildren.contains(part)) {
                    CDEAbstractGraphicalEditPart.this.actionBarEditpartSelected = true;
                }
            } else {
                CDEAbstractGraphicalEditPart.this.actionBarEditpartSelected = false;
                Display.getCurrent().asyncExec(((CDEAbstractGraphicalEditPart)CDEAbstractGraphicalEditPart.this).fActionBarController.hideActionBarRunnable);
            }
        }
    }

    class ActionBarFigureListener
    implements FigureListener {
        ActionBarFigureListener() {
        }

        public void figureMoved(IFigure source) {
            CDEAbstractGraphicalEditPart.this.fActionBarController.hideActionBar();
            Display.getCurrent().asyncExec(((CDEAbstractGraphicalEditPart)CDEAbstractGraphicalEditPart.this).fActionBarController.showActionBarRunnable);
        }
    }

    class ActionBarActionListener
    implements ActionListener {
        ActionBarActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            CDEAbstractGraphicalEditPart.this.fActionBarController.hideActionBar();
        }
    }
}

