/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ve.internal.cde.core.ToolTipProcessor;

public class ToolTipContentHelper
extends Panel {
    ArrayList fToolTipProcessors = new ArrayList();
    HashMap fProcessorFigures;

    public ToolTipContentHelper(ToolTipProcessor[] toolTipProcessors) {
        FlowLayout layout = new FlowLayout(false){

            protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
                Rectangle bounds = Display.getCurrent().getClientArea();
                bounds.width -= 100;
                bounds.height -= 100;
                Dimension prefSize = super.calculatePreferredSize(container, wHint == -1 ? bounds.width : Math.min(wHint, bounds.width), hHint == -1 ? bounds.height : Math.min(hHint, bounds.height));
                prefSize.width = Math.min(prefSize.width, bounds.width);
                prefSize.height = Math.min(prefSize.height, bounds.height);
                return prefSize;
            }
        };
        layout.setMajorSpacing(0);
        layout.setMinorSpacing(0);
        this.setLayoutManager((LayoutManager)layout);
        int i = 0;
        while (i < toolTipProcessors.length) {
            this.addToolTipProcessor(toolTipProcessors[i]);
            ++i;
        }
    }

    public void activate() {
        if (this.fProcessorFigures != null) {
            Iterator iter = this.fToolTipProcessors.iterator();
            while (iter.hasNext()) {
                ((ToolTipProcessor)iter.next()).activate();
            }
        }
    }

    public void deactivate() {
        if (this.fProcessorFigures != null) {
            Iterator iter = this.fToolTipProcessors.iterator();
            while (iter.hasNext()) {
                ((ToolTipProcessor)iter.next()).deactivate();
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.fProcessorFigures == null) {
            this.fProcessorFigures = new HashMap(this.fToolTipProcessors.size());
            Iterator iter = this.fToolTipProcessors.iterator();
            while (iter.hasNext()) {
                ToolTipProcessor processor = (ToolTipProcessor)iter.next();
                IFigure figure = processor.createFigure();
                if (figure == null) continue;
                this.add(figure);
                this.fProcessorFigures.put(processor, figure);
            }
        }
    }

    public void addToolTipProcessor(ToolTipProcessor p) {
        this.fToolTipProcessors.add(p);
    }

    public void removeToolTipProcessor(ToolTipProcessor p) {
        IFigure processorFigure;
        p.deactivate();
        if (this.fProcessorFigures != null && (processorFigure = (IFigure)this.fProcessorFigures.get(p)) != null) {
            this.remove(processorFigure);
            this.fProcessorFigures.remove(p);
        }
        this.fToolTipProcessors.remove(p);
    }

    public void refresh() {
        if (this.fProcessorFigures != null) {
            Iterator iter = this.fProcessorFigures.values().iterator();
            while (iter.hasNext()) {
                this.remove((IFigure)iter.next());
            }
            this.fProcessorFigures = null;
        }
    }
}

