/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.CustomizeLayoutWindow;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.LayoutList;
import org.eclipse.ve.internal.cde.core.ModelChangeController;

public class CustomizeLayoutWindowAction
extends Action
implements IMenuCreator {
    public static String ACTION_ID = "CustomizeLayoutWindowAction";
    protected static Point fDialogLoc;
    protected CustomizeLayoutWindow fDialog;
    protected IWorkbenchWindow workbenchWindow;
    protected IEditorPart editorPart;
    protected IEditorActionBarContributor contributor;
    protected MenuManager toolbarMenuManager;
    protected static final String WINDOW_TITLE;
    protected static final String CUSTOMIZE_LAYOUT_PAGE_KEY = "customizeLayoutPage_Key";
    public static final ImageDescriptor IMG_CUSTOMIZE_LAYOUT_BEAN_DISABLED;
    public static final ImageDescriptor IMG_CUSTOMIZE_LAYOUT_BEAN;
    private IPartListener alignmentWindowPartListener = new IPartListener(){
        private boolean currentEPBeingClosed = false;

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                this.currentEPBeingClosed = false;
                CustomizeLayoutWindowAction.this.setEditorPart((IEditorPart)part);
            } else if (this.currentEPBeingClosed) {
                this.currentEPBeingClosed = false;
                CustomizeLayoutWindowAction.this.setEditorPart(null);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == CustomizeLayoutWindowAction.this.editorPart) {
                this.currentEPBeingClosed = true;
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private ISelectionListener selListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            CustomizeLayoutWindowAction.this.update(selection);
        }
    };
    private ISelectionProvider selectionProvider = new ISelectionProvider(){
        private ISelection selection = StructuredSelection.EMPTY;

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
        }
    };
    protected ModelChangeController.ModelChangeListener changeListener = new ModelChangeController.ModelChangeListener(){

        public void transactionEvent(ModelChangeController.ModelChangeEvent event) {
            if (event.getEvent() == 1 && CustomizeLayoutWindowAction.this.fDialog != null && !CustomizeLayoutWindowAction.this.fDialog.isHidden()) {
                CustomizeLayoutWindowAction.this.fDialog.refresh();
            }
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        WINDOW_TITLE = CDEMessages.CustomizeLayoutWindow_title;
        IMG_CUSTOMIZE_LAYOUT_BEAN_DISABLED = CDEPlugin.getImageDescriptorFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/dlcl16/aligndialog_obj.gif");
        IMG_CUSTOMIZE_LAYOUT_BEAN = CDEPlugin.getImageDescriptorFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/elcl16/aligndialog_obj.gif");
    }

    public static void addLayoutCustomizationPage(EditPartViewer viewer, Class layoutPage) {
        org.eclipse.gef.EditDomain odom = viewer.getEditDomain();
        if (odom instanceof EditDomain) {
            EditDomain dom = (EditDomain)odom;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.core.CustomizeLayoutPage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isAssignableFrom(layoutPage)) {
                throw new IllegalArgumentException(layoutPage.toString());
            }
            CustomizeLayoutPageController pages = (CustomizeLayoutPageController)dom.getViewerData(viewer, CUSTOMIZE_LAYOUT_PAGE_KEY);
            if (pages == null) {
                pages = new CustomizeLayoutPageController();
                dom.setViewerData(viewer, CUSTOMIZE_LAYOUT_PAGE_KEY, pages);
            }
            pages.addLayoutPage(layoutPage);
        }
    }

    public static void addComponentCustomizationPage(EditPartViewer viewer, Class componentPage) {
        org.eclipse.gef.EditDomain odom = viewer.getEditDomain();
        if (odom instanceof EditDomain) {
            EditDomain dom = (EditDomain)odom;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.core.CustomizeLayoutPage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isAssignableFrom(componentPage)) {
                throw new IllegalArgumentException(componentPage.toString());
            }
            CustomizeLayoutPageController pages = (CustomizeLayoutPageController)dom.getViewerData(viewer, CUSTOMIZE_LAYOUT_PAGE_KEY);
            if (pages == null) {
                pages = new CustomizeLayoutPageController();
                dom.setViewerData(viewer, CUSTOMIZE_LAYOUT_PAGE_KEY, pages);
            }
            pages.addComponentPage(componentPage);
        }
    }

    void showCustomizeLayoutWindow() {
        if (this.fDialog == null) {
            this.run();
        } else {
            this.fDialog.getShell().forceActive();
        }
    }

    public CustomizeLayoutWindowAction(IWorkbenchWindow workbenchWindow, IEditorActionBarContributor contributor) {
        super(CDEMessages.CustomizeLayoutWindowAction_label, 1);
        this.workbenchWindow = workbenchWindow;
        this.contributor = contributor;
        this.setId(ACTION_ID);
        this.setImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/elcl16/aligndialog_obj.gif"));
        this.setDisabledImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/dlcl16/aligndialog_obj.gif"));
        this.setHoverImageDescriptor(this.getImageDescriptor());
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("checked".equals(event.getProperty())) {
                    CustomizeLayoutWindowAction.this.setTooltip();
                }
            }
        });
        this.setTooltip();
        workbenchWindow.getSelectionService().addSelectionListener(this.selListener);
        workbenchWindow.getPartService().addPartListener(this.alignmentWindowPartListener);
        this.toolbarMenuManager = new MenuManager();
        this.toolbarMenuManager.setRemoveAllWhenShown(true);
        this.toolbarMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object firstElement;
                LayoutList layoutList = null;
                ISelection selection = CustomizeLayoutWindowAction.this.workbenchWindow.getSelectionService().getSelection();
                if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof EditPart) {
                    EditPart editPart = (EditPart)firstElement;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.ve.internal.cde.core.LayoutList");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    layoutList = (LayoutList)editPart.getAdapter((Class)clazz);
                }
                if (layoutList != null) {
                    layoutList.fillMenuManager(CustomizeLayoutWindowAction.this.toolbarMenuManager);
                } else {
                    Action noAvailable = new Action(this, CDEMessages.CustomizeLayoutWindowAction_Action_NoLayouts){
                        final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                        }
                    };
                    CustomizeLayoutWindowAction.this.toolbarMenuManager.add((IAction)noAvailable);
                }
            }
        });
    }

    private void setTooltip() {
        this.setToolTipText(this.isChecked() ? CDEMessages.CustomizeLayoutWindowAction_tooltip_hide : CDEMessages.CustomizeLayoutWindowAction_tooltip_show);
    }

    protected void updateLayoutTab(final Class layoutPageClass) {
        this.workbenchWindow.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (CustomizeLayoutWindowAction.this.fDialog != null) {
                    CustomizeLayoutWindowAction.this.fDialog.addLayoutCustomizationPage(layoutPageClass);
                }
            }
        });
    }

    protected void updateComponentTab(final Class componentPageClass) {
        this.workbenchWindow.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (CustomizeLayoutWindowAction.this.fDialog != null) {
                    CustomizeLayoutWindowAction.this.fDialog.addComponentCustomizationPage(componentPageClass);
                }
            }
        });
    }

    protected void setEditorPart(IEditorPart anEditorPart) {
        if (this.editorPart == anEditorPart) {
            return;
        }
        this.removeModelChangeController();
        this.editorPart = anEditorPart;
        if (this.editorPart != null && this.editorPart.getEditorSite().getActionBarContributor() == this.contributor && this.fDialog != null) {
            this.runWithoutUpdate();
        } else if (this.fDialog != null) {
            this.fDialog.hide();
            this.fDialog.setEditorPart(null);
            this.update((ISelection)StructuredSelection.EMPTY);
        }
        if (this.editorPart != null) {
            ModelChangeController changeController;
            org.eclipse.gef.EditDomain domain;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.gef.EditDomain");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((domain = (org.eclipse.gef.EditDomain)this.editorPart.getAdapter((Class)clazz)) instanceof EditDomain && (changeController = (ModelChangeController)((EditDomain)domain).getData("org.eclipse.ve.internal.cde.core.ModelChangeController")) != null) {
                changeController.addModelChangeListener(this.changeListener);
            }
        }
    }

    private void removeModelChangeController() {
        if (this.editorPart != null) {
            ModelChangeController changeController;
            org.eclipse.gef.EditDomain domain;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.gef.EditDomain");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((domain = (org.eclipse.gef.EditDomain)this.editorPart.getAdapter((Class)clazz)) instanceof EditDomain && (changeController = (ModelChangeController)((EditDomain)domain).getData("org.eclipse.ve.internal.cde.core.ModelChangeController")) != null) {
                changeController.removeModelChangeListener(this.changeListener);
            }
        }
    }

    public void dispose() {
        this.toolbarMenuManager.dispose();
    }

    public void disposeAction() {
        this.workbenchWindow.getSelectionService().removeSelectionListener(this.selListener);
        this.workbenchWindow.getPartService().removePartListener(this.alignmentWindowPartListener);
        this.removeModelChangeController();
        this.editorPart = null;
        this.contributor = null;
        this.workbenchWindow = null;
        if (this.fDialog != null) {
            this.fDialog.close();
            this.fDialog = null;
        }
    }

    public void run() {
        this.runWithoutUpdate();
        this.update(this.workbenchWindow.getSelectionService().getSelection());
    }

    private void setDialogLoc() {
        Point shellLoc = this.workbenchWindow.getShell().getLocation();
        shellLoc.x += CustomizeLayoutWindowAction.fDialogLoc.x;
        shellLoc.y += CustomizeLayoutWindowAction.fDialogLoc.y;
        this.fDialog.setLocation(shellLoc);
    }

    protected void runWithoutUpdate() {
        if (this.fDialog == null) {
            this.fDialog = new CustomizeLayoutWindow(this.workbenchWindow.getShell(), this);
            if (fDialogLoc == null) {
                Preferences preferences = CDEPlugin.getPlugin().getPluginPreferences();
                fDialogLoc = new Point(preferences.getInt(CDEPlugin.CUSTOMIZELAYOUTWINDOW_X), preferences.getInt(CDEPlugin.CUSTOMIZELAYOUTWINDOW_Y));
            }
            this.setDialogLoc();
            this.fDialog.open();
            this.fDialog.getShell().addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent event) {
                    fDialogLoc = CustomizeLayoutWindowAction.this.fDialog.getShell().getLocation();
                    CustomizeLayoutWindowAction.this.fDialog.setLocation(fDialogLoc);
                    Point shellLoc = CustomizeLayoutWindowAction.this.workbenchWindow.getShell().getLocation();
                    CustomizeLayoutWindowAction.fDialogLoc.x -= shellLoc.x;
                    CustomizeLayoutWindowAction.fDialogLoc.y -= shellLoc.y;
                }

                public void controlResized(ControlEvent event) {
                }
            });
            this.fDialog.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    CustomizeLayoutWindowAction.this.persistPreferences();
                    CustomizeLayoutWindowAction.this.fDialog = null;
                    CustomizeLayoutWindowAction.this.update((ISelection)StructuredSelection.EMPTY);
                }
            });
        } else {
            this.fDialog.open();
        }
        this.fDialog.setEditorPart(this.editorPart);
    }

    protected void persistPreferences() {
        if (fDialogLoc != null) {
            Preferences preferences = CDEPlugin.getPlugin().getPluginPreferences();
            preferences.setValue(CDEPlugin.CUSTOMIZELAYOUTWINDOW_X, CustomizeLayoutWindowAction.fDialogLoc.x);
            preferences.setValue(CDEPlugin.CUSTOMIZELAYOUTWINDOW_Y, CustomizeLayoutWindowAction.fDialogLoc.y);
        }
    }

    protected void update(ISelection selection) {
        this.selectionProvider.setSelection(selection);
        if (this.fDialog != null && !this.fDialog.isHidden()) {
            this.fDialog.update(selection);
        }
    }

    public IMenuCreator getMenuCreator() {
        return this;
    }

    public Menu getMenu(Control parent) {
        return this.toolbarMenuManager.createContextMenu(parent);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    protected static class CustomizeLayoutPageController {
        private CustomizeLayoutWindowAction customizeLayoutWindowAction;
        private List layoutClasses = new ArrayList(1);
        private List componentClasses = new ArrayList(1);

        protected CustomizeLayoutPageController() {
        }

        public void setCustomizeLayoutWindowAction(CustomizeLayoutWindowAction alignWindowAction) {
            this.customizeLayoutWindowAction = alignWindowAction;
        }

        public CustomizeLayoutWindowAction getCustomizeLayoutWindowAction() {
            return this.customizeLayoutWindowAction;
        }

        public List getLayoutClasses() {
            return this.layoutClasses;
        }

        public List getComponentClasses() {
            return this.componentClasses;
        }

        public void addLayoutPage(Class layoutClass) {
            if (layoutClass != null && !this.layoutClasses.contains(layoutClass)) {
                this.layoutClasses.add(layoutClass);
                if (this.getCustomizeLayoutWindowAction() != null) {
                    this.getCustomizeLayoutWindowAction().updateLayoutTab(layoutClass);
                }
            }
        }

        public void addComponentPage(Class componentClass) {
            if (componentClass != null && !this.componentClasses.contains(componentClass)) {
                this.componentClasses.add(componentClass);
                if (this.getCustomizeLayoutWindowAction() != null) {
                    this.getCustomizeLayoutWindowAction().updateComponentTab(componentClass);
                }
            }
        }
    }
}

