/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.ContainerPolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.IConstraintHandler;
import org.eclipse.ve.internal.cde.core.IModelAdapterFactory;
import org.eclipse.ve.internal.cde.core.KeyedValueNotificationHelper;
import org.eclipse.ve.internal.cde.core.VisualInfoPolicy;
import org.eclipse.ve.internal.cde.core.XYLayoutEditPolicy;
import org.eclipse.ve.internal.cde.core.XYLayoutUtility;
import org.eclipse.ve.internal.cde.core.ZoomController;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.cdm.VisualInfo;
import org.eclipse.ve.internal.cdm.model.Dimension;
import org.eclipse.ve.internal.cdm.model.Point;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class VisualInfoXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected ContainerPolicy containerPolicy;
    public static final String VISUAL_CONSTRAINT_REFRESH_POLICY = "org.eclipse.ve.internal.cde.core.visualConstraintRefreshPolicy";
    static /* synthetic */ Class class$0;

    public VisualInfoXYLayoutEditPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
    }

    public void activate() {
        super.activate();
        this.containerPolicy.setContainer(this.getHost().getModel());
    }

    public void deactivate() {
        super.deactivate();
        this.containerPolicy.setContainer(null);
    }

    protected Command createAddCommand(EditPart childEditPart, Object constraint) {
        Object child = childEditPart.getModel();
        GroupRequest grpReq = new GroupRequest((Object)"add children");
        grpReq.setEditParts(childEditPart);
        Command addContributionCmd = this.containerPolicy.getCommand((Request)grpReq);
        if (addContributionCmd == null || !addContributionCmd.canExecute()) {
            return UnexecutableCommand.INSTANCE;
        }
        ((org.eclipse.ve.internal.cdm.model.Rectangle)constraint).width = -1;
        ((org.eclipse.ve.internal.cdm.model.Rectangle)constraint).height = -1;
        IConstraintHandler handler = this.getChildConstraintHandler(child);
        CompoundCommand command = new CompoundCommand();
        command.append(addContributionCmd);
        command.append(this.primChangeConstraintCommand(child, handler, (org.eclipse.ve.internal.cdm.model.Rectangle)constraint, true, false));
        return command.unwrap();
    }

    protected Command createChangeConstraintCommand(EditPart childEditPart, Object constraint, boolean moved, boolean resized) {
        return this.primChangeConstraintCommand(childEditPart.getModel(), this.getConstraintHandler(childEditPart), (org.eclipse.ve.internal.cdm.model.Rectangle)constraint, moved, resized);
    }

    protected Command getCreateCommand(CreateRequest aRequest) {
        Object child = aRequest.getNewObject();
        Command createContributionCmd = this.containerPolicy.getCommand((Request)aRequest);
        if (createContributionCmd == null || !createContributionCmd.canExecute()) {
            return UnexecutableCommand.INSTANCE;
        }
        org.eclipse.ve.internal.cdm.model.Rectangle constraint = (org.eclipse.ve.internal.cdm.model.Rectangle)this.translateToModelConstraint(this.getConstraintFor(aRequest));
        CompoundCommand command = new CompoundCommand();
        command.append(createContributionCmd);
        IConstraintHandler constraintHandler = this.getChildConstraintHandler(child);
        command.append(this.primChangeConstraintCommand(child, constraintHandler, constraint, true, this.isChildResizeable(constraintHandler) && (constraint.width != -1 || constraint.height != -1)));
        return command.unwrap();
    }

    protected IConstraintHandler getChildConstraintHandler(Object child) {
        IConstraintHandler iConstraintHandler;
        IModelAdapterFactory factory = CDEUtilities.getModelAdapterFactory(this.getHost());
        if (factory != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.core.IConstraintHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iConstraintHandler = (IConstraintHandler)factory.getAdapter(child, clazz);
        } else {
            iConstraintHandler = null;
        }
        return iConstraintHandler;
    }

    protected IConstraintHandler getConstraintHandler(EditPart editpart) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.core.IConstraintHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IConstraintHandler)editpart.getAdapter((Class)clazz);
    }

    protected Command getDeleteDependantCommand(Request aRequest) {
        Command deleteContributionCmd = this.containerPolicy.getCommand(aRequest);
        if (deleteContributionCmd == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return deleteContributionCmd;
    }

    protected Command getOrphanChildrenCommand(Request aRequest) {
        Command orphanContributionCmd = this.containerPolicy.getCommand(aRequest);
        if (orphanContributionCmd == null || !orphanContributionCmd.canExecute()) {
            return UnexecutableCommand.INSTANCE;
        }
        return orphanContributionCmd;
    }

    protected Command primChangeConstraintCommand(Object model, IConstraintHandler handler, org.eclipse.ve.internal.cdm.model.Rectangle constraint, boolean pointChanged, boolean sizeChanged) {
        EditPartViewer viewer = this.getHost().getRoot().getViewer();
        VisualInfo vi = VisualInfoPolicy.getVisualInfo(model, viewer);
        Object constraintKV = vi != null ? vi.getKeyedValues().get((Object)"org.eclipse.ve.internal.cdm.model.visualconstraintkey") : null;
        org.eclipse.ve.internal.cdm.model.Rectangle lConstraint = constraintKV instanceof org.eclipse.ve.internal.cdm.model.Rectangle ? (org.eclipse.ve.internal.cdm.model.Rectangle)constraintKV : null;
        if ((pointChanged |= lConstraint == null) || sizeChanged) {
            EditDomain dom = EditDomain.getEditDomain(this.getHost());
            Object newConstraint = null;
            Command sizeCommand = null;
            if (pointChanged && sizeChanged) {
                newConstraint = constraint;
                if (handler != null && (sizeCommand = handler.contributeSizeCommand(constraint.width, constraint.height, dom)) != null) {
                    constraint.height = -1;
                    constraint.width = -1;
                }
            } else if (pointChanged) {
                newConstraint = new Point(constraint.x, constraint.y);
            } else {
                if (handler != null && (sizeCommand = handler.contributeSizeCommand(constraint.width, constraint.height, dom)) != null) {
                    return sizeCommand;
                }
                newConstraint = new Dimension(constraint.width, constraint.height);
            }
            Command viCmd = VisualInfoPolicy.applyVisualInfoSetting(model, newConstraint, dom, dom.getDiagram(viewer));
            return sizeCommand == null ? viCmd : viCmd.chain(sizeCommand);
        }
        return null;
    }

    public Command getCommand(Request request) {
        if ("delete".equals(request.getType())) {
            return this.containerPolicy.getCommand(request);
        }
        return super.getCommand(request);
    }

    protected void refreshFromEditPart(EditPart child, Object constraintValue) {
        org.eclipse.ve.internal.cdm.model.Rectangle constraint = (org.eclipse.ve.internal.cdm.model.Rectangle)this.getChildConstraint(child, constraintValue);
        Rectangle rect = (Rectangle)this.modelToFigureConstraint(constraint);
        this.setConstraintToFigure(child, rect);
    }

    protected void setConstraintToFigure(EditPart child, Rectangle figureConstraint) {
        IConstraintHandler handler = this.getConstraintHandler(child);
        if (handler != null) {
            int x = figureConstraint.x;
            int y = figureConstraint.y;
            handler.contributeFigureSize(figureConstraint);
            figureConstraint.setLocation(x, y);
        }
        ((GraphicalEditPart)this.getHost()).setLayoutConstraint(child, ((GraphicalEditPart)child).getFigure(), (Object)figureConstraint);
    }

    private void setNewSize(EditPart child, int width, int height) {
        Rectangle rect = (Rectangle)((GraphicalEditPart)this.getHost()).getContentPane().getLayoutManager().getConstraint(((GraphicalEditPart)child).getFigure());
        rect = rect == null ? XYLayoutUtility.modifyPreferredRectangle(new Rectangle(0, 0, width, height), true, false, false) : rect.getCopy().setSize(width, height);
        this.setConstraintToFigure(child, rect);
    }

    protected Object translateToModelConstraint(Object figureConstraint) {
        if (figureConstraint instanceof Rectangle) {
            Rectangle rect = (Rectangle)figureConstraint;
            return new org.eclipse.ve.internal.cdm.model.Rectangle(rect.x, rect.y, rect.width, rect.height);
        }
        if (figureConstraint instanceof org.eclipse.draw2d.geometry.Point) {
            org.eclipse.draw2d.geometry.Point point = (org.eclipse.draw2d.geometry.Point)figureConstraint;
            return new Point(point.x, point.y);
        }
        return figureConstraint;
    }

    protected Object convertModelToDraw2D(Object modelconstraint) {
        if (modelconstraint instanceof org.eclipse.ve.internal.cdm.model.Rectangle) {
            org.eclipse.ve.internal.cdm.model.Rectangle rect = (org.eclipse.ve.internal.cdm.model.Rectangle)modelconstraint;
            return new Rectangle(rect.x, rect.y, rect.width, rect.height);
        }
        if (modelconstraint instanceof Point) {
            Point point = (Point)modelconstraint;
            return new org.eclipse.draw2d.geometry.Point(point.x, point.y);
        }
        return modelconstraint;
    }

    protected Object modelToFigureConstraint(Object modelConstraint) {
        if (modelConstraint == null) {
            modelConstraint = XYLayoutUtility.modifyPreferredCDMRectangle(new org.eclipse.ve.internal.cdm.model.Rectangle(), true, true, true);
        }
        org.eclipse.ve.internal.cdm.model.Rectangle r = (org.eclipse.ve.internal.cdm.model.Rectangle)modelConstraint;
        Rectangle figureConstraint = new Rectangle(r.x, r.y, r.width, r.height);
        ZoomController zoomController = this.getZoomController();
        if (zoomController != null) {
            if (figureConstraint.x != Integer.MIN_VALUE) {
                figureConstraint.x = zoomController.zoomCoordinate(figureConstraint.x);
            }
            if (figureConstraint.y != Integer.MIN_VALUE) {
                figureConstraint.y = zoomController.zoomCoordinate(figureConstraint.y);
            }
        }
        return figureConstraint;
    }

    protected boolean isChildResizeable(EditPart childEditpart) {
        return this.isChildResizeable(this.getConstraintHandler(childEditpart));
    }

    protected boolean isChildResizeable(IConstraintHandler handler) {
        return handler != null ? handler.isResizeable() : false;
    }

    protected Object getChildConstraint(EditPart child) {
        VisualInfo vi = VisualInfoPolicy.getVisualInfo(child);
        if (vi == null) {
            return null;
        }
        return this.getChildConstraint(child, vi.getKeyedValues().get((Object)"org.eclipse.ve.internal.cdm.model.visualconstraintkey"));
    }

    protected Object getChildConstraint(EditPart child, Object kv) {
        org.eclipse.ve.internal.cdm.model.Rectangle constraint = kv instanceof org.eclipse.ve.internal.cdm.model.Rectangle ? new org.eclipse.ve.internal.cdm.model.Rectangle((org.eclipse.ve.internal.cdm.model.Rectangle)kv) : XYLayoutUtility.modifyPreferredCDMRectangle(new org.eclipse.ve.internal.cdm.model.Rectangle(), true, true, true);
        IConstraintHandler handler = this.getConstraintHandler(child);
        if (handler != null) {
            int x = constraint.x;
            int y = constraint.y;
            handler.contributeModelSize(constraint);
            constraint.x = x;
            constraint.y = y;
        }
        return constraint;
    }

    protected void decorateChild(EditPart child) {
        super.decorateChild(child);
        child.installEditPolicy((Object)VISUAL_CONSTRAINT_REFRESH_POLICY, (EditPolicy)new VisualConstraintRefreshPolicy());
    }

    static /* synthetic */ void access$0(VisualInfoXYLayoutEditPolicy visualInfoXYLayoutEditPolicy, EditPart editPart, int n, int n2) {
        visualInfoXYLayoutEditPolicy.setNewSize(editPart, n, n2);
    }

    protected class VisualConstraintRefreshPolicy
    extends AbstractEditPolicy
    implements IConstraintHandler.IConstraintHandlerListener {
        private VisualInfoPolicy.VisualInfoListener viListener;
        private IConstraintHandler handler;
        static /* synthetic */ Class class$0;

        protected VisualConstraintRefreshPolicy() {
        }

        public void activate() {
            super.activate();
            EditPartViewer viewer = this.getHost().getRoot().getViewer();
            EditDomain dom = (EditDomain)viewer.getEditDomain();
            this.viListener = new VisualInfoPolicy.VisualInfoListener(this, this.getHost().getModel(), dom.getDiagram(viewer), dom){
                final /* synthetic */ VisualConstraintRefreshPolicy this$1;
                {
                    this.this$1 = visualConstraintRefreshPolicy;
                }

                public void notifyVisualInfoChanges(Notification msg) {
                    Notification kvMsg;
                    Class<?> clazz = VisualConstraintRefreshPolicy.class$0;
                    if (clazz == null) {
                        try {
                            clazz = VisualConstraintRefreshPolicy.class$0 = Class.forName("org.eclipse.ve.internal.cdm.VisualInfo");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (msg.getFeatureID((Class)clazz) == 0 && (kvMsg = KeyedValueNotificationHelper.notifyChanged(msg, "org.eclipse.ve.internal.cdm.model.visualconstraintkey")) != null) {
                        switch (kvMsg.getEventType()) {
                            case 1: {
                                VisualConstraintRefreshPolicy.access$0(this.this$1, ((BasicEMap.Entry)kvMsg.getNewValue()).getValue());
                                break;
                            }
                            case 2: {
                                VisualConstraintRefreshPolicy.access$0(this.this$1, null);
                            }
                        }
                    }
                }

                public void notifyVisualInfo(int eventType, VisualInfo oldVI, VisualInfo newVI) {
                    VisualConstraintRefreshPolicy.access$1(this.this$1);
                }

                public void notifyAnnotation(int eventType, Annotation oldAnnotation, Annotation newAnnotation) {
                    super.notifyAnnotation(eventType, oldAnnotation, newAnnotation);
                    VisualConstraintRefreshPolicy.access$1(this.this$1);
                }
            };
            this.handler = VisualInfoXYLayoutEditPolicy.this.getConstraintHandler(this.getHost());
            if (this.handler != null) {
                this.handler.addConstraintHandlerListener(this);
            }
            this.signalRefresh();
        }

        private void signalRefresh() {
            Object kv = this.getCurrentConstraint();
            this.queueRefreshFromEditPart(kv);
        }

        private Object getCurrentConstraint() {
            Object kv = null;
            VisualInfo vi = VisualInfoPolicy.getVisualInfo(this.getHost());
            if (vi != null) {
                kv = vi.getKeyedValues().get((Object)"org.eclipse.ve.internal.cdm.model.visualconstraintkey");
            }
            return kv;
        }

        private void queueRefreshFromEditPart(Object constraint) {
            if (this.getHost() != null) {
                CDEUtilities.displayExec(this.getHost(), "REFRESH_FROM_EDITPART", new Runnable(this){
                    final /* synthetic */ VisualConstraintRefreshPolicy this$1;
                    {
                        this.this$1 = visualConstraintRefreshPolicy;
                    }

                    public void run() {
                        if (this.this$1.getHost() != null && this.this$1.getHost().isActive()) {
                            VisualConstraintRefreshPolicy.access$3(this.this$1).refreshFromEditPart(this.this$1.getHost(), VisualConstraintRefreshPolicy.access$2(this.this$1));
                        }
                    }
                });
            }
        }

        public void deactivate() {
            super.deactivate();
            this.setHost(null);
            if (this.viListener != null) {
                this.viListener.removeListening();
            }
            this.viListener = null;
            if (this.handler != null) {
                this.handler.removeConstraintHandlerListener(this);
            }
            this.handler = null;
        }

        public EditPart getTargetEditPart(Request request) {
            return null;
        }

        public void sizeChanged(int width, int height) {
            CDEUtilities.displayExec(this.getHost(), new Runnable(this, width, height){
                final /* synthetic */ VisualConstraintRefreshPolicy this$1;
                private final /* synthetic */ int val$width;
                private final /* synthetic */ int val$height;
                {
                    this.this$1 = visualConstraintRefreshPolicy;
                    this.val$width = n;
                    this.val$height = n2;
                }

                public void run() {
                    if (this.this$1.getHost() != null && this.this$1.getHost().isActive()) {
                        VisualInfoXYLayoutEditPolicy.access$0(VisualConstraintRefreshPolicy.access$3(this.this$1), this.this$1.getHost(), this.val$width, this.val$height);
                    }
                }
            });
        }

        static /* synthetic */ void access$0(VisualConstraintRefreshPolicy visualConstraintRefreshPolicy, Object object) {
            visualConstraintRefreshPolicy.queueRefreshFromEditPart(object);
        }

        static /* synthetic */ void access$1(VisualConstraintRefreshPolicy visualConstraintRefreshPolicy) {
            visualConstraintRefreshPolicy.signalRefresh();
        }

        static /* synthetic */ Object access$2(VisualConstraintRefreshPolicy visualConstraintRefreshPolicy) {
            return visualConstraintRefreshPolicy.getCurrentConstraint();
        }

        static /* synthetic */ VisualInfoXYLayoutEditPolicy access$3(VisualConstraintRefreshPolicy visualConstraintRefreshPolicy) {
            return visualConstraintRefreshPolicy.VisualInfoXYLayoutEditPolicy.this;
        }
    }
}

