/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.propertysheet.common.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.ve.internal.propertysheet.command.ForwardUndoCompoundCommand;
import org.eclipse.ve.internal.propertysheet.common.commands.AbstractCommand;

public class CompoundCommand
extends AbstractCommand {
    protected List commandList;
    public static final int LAST_COMMAND_ALL = Integer.MIN_VALUE;
    public static final int MERGE_COMMAND_ALL = Integer.MAX_VALUE;
    protected int resultIndex = Integer.MAX_VALUE;

    public CompoundCommand() {
        this.commandList = new ArrayList();
    }

    public CompoundCommand(String label) {
        super(label);
        this.commandList = new ArrayList();
    }

    public CompoundCommand(String label, String description) {
        super(label, description);
        this.commandList = new ArrayList();
    }

    public CompoundCommand(List commandList) {
        this.commandList = commandList;
    }

    public CompoundCommand(String label, List commandList) {
        super(label);
        this.commandList = commandList;
    }

    public CompoundCommand(String label, String description, List commandList) {
        super(label, description);
        this.commandList = commandList;
    }

    public CompoundCommand(int resultIndex) {
        this.resultIndex = resultIndex;
        this.commandList = new ArrayList();
    }

    public CompoundCommand(int resultIndex, String label) {
        super(label);
        this.resultIndex = resultIndex;
        this.commandList = new ArrayList();
    }

    public CompoundCommand(int resultIndex, String label, String description) {
        super(label, description);
        this.resultIndex = resultIndex;
        this.commandList = new ArrayList();
    }

    public CompoundCommand(int resultIndex, List commandList) {
        this.resultIndex = resultIndex;
        this.commandList = commandList;
    }

    public CompoundCommand(int resultIndex, String label, List commandList) {
        super(label);
        this.resultIndex = resultIndex;
        this.commandList = commandList;
    }

    public CompoundCommand(int resultIndex, String label, String description, List commandList) {
        super(label, description);
        this.resultIndex = resultIndex;
        this.commandList = commandList;
    }

    public boolean isEmpty() {
        return this.commandList.isEmpty();
    }

    public Command chain(Command command) {
        this.append(command);
        return this;
    }

    protected boolean prepare() {
        if (this.commandList.isEmpty()) {
            return false;
        }
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            Command command = (Command)commands.next();
            if (command.canExecute()) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            try {
                Command command = (Command)commands.next();
                command.execute();
                continue;
            }
            catch (RuntimeException exception) {
                try {
                    commands.previous();
                    while (commands.hasPrevious()) {
                        Command command = (Command)commands.previous();
                        if (command.canUndo()) {
                            command.undo();
                        }
                    }
                }
                catch (RuntimeException e2) {
                    e2.printStackTrace();
                }
            }
            throw exception;
        }
    }

    public boolean canUndo() {
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            Command command = (Command)commands.next();
            if (command.canUndo()) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void undo() {
        commands = this.commandList.listIterator(this.commandList.size());
        while (commands.hasPrevious()) {
            try {
                command = (Command)commands.previous();
                command.undo();
                continue;
            }
            catch (RuntimeException exception) {
                commands.next();
                ** while (commands.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                command = (Command)commands.next();
                command.redo();
                continue;
            }
lbl14:
            // 1 sources

            throw exception;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void redo() {
        commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            try {
                command = (Command)commands.next();
                command.redo();
                continue;
            }
            catch (RuntimeException exception) {
                commands.previous();
                ** while (commands.hasPrevious())
            }
lbl-1000:
            // 1 sources

            {
                command = (Command)commands.previous();
                command.undo();
                continue;
            }
lbl14:
            // 1 sources

            throw exception;
        }
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        if (this.commandList.isEmpty()) {
            return CommonPlugin.INSTANCE.getString("_UI_CompoundCommand_label");
        }
        if (this.resultIndex == Integer.MIN_VALUE || this.resultIndex == Integer.MAX_VALUE) {
            return ((Command)this.commandList.get(this.commandList.size() - 1)).getLabel();
        }
        if (this.resultIndex < this.commandList.size()) {
            return ((Command)this.commandList.get(this.resultIndex)).getLabel();
        }
        return CommonPlugin.INSTANCE.getString("_UI_CompoundCommand_label");
    }

    public void append(Command command) {
        if (command != null) {
            if (command instanceof CompoundCommand && !(command instanceof ForwardUndoCompoundCommand)) {
                this.commandList.addAll(((CompoundCommand)command).commandList);
            } else {
                this.commandList.add(command);
            }
        }
    }

    public boolean appendAndExecute(Command command) {
        if (command != null) {
            if (!this.isPrepared) {
                if (this.commandList.isEmpty()) {
                    this.isPrepared = true;
                    this.isExecutable = true;
                } else {
                    this.isExecutable = this.prepare();
                    this.isPrepared = true;
                    if (this.isExecutable) {
                        this.execute();
                    }
                }
            }
            if (command.canExecute()) {
                try {
                    command.execute();
                    this.append(command);
                    return true;
                }
                catch (RuntimeException exception) {
                    CommonPlugin.INSTANCE.log((Object)new WrappedException(CommonPlugin.INSTANCE.getString("_UI_IgnoreException_exception"), (Exception)exception).fillInStackTrace());
                }
            }
            command.dispose();
        }
        return false;
    }

    public boolean appendIfCanExecute(Command command) {
        if (command == null) {
            return false;
        }
        if (command.canExecute()) {
            this.append(command);
            return true;
        }
        command.dispose();
        return false;
    }

    public void dispose() {
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            Command command = (Command)commands.next();
            command.dispose();
        }
    }

    public Command unwrap() {
        switch (this.commandList.size()) {
            case 0: {
                this.dispose();
                return UnexecutableCommand.INSTANCE;
            }
            case 1: {
                Command result = (Command)this.commandList.remove(0);
                this.dispose();
                return result;
            }
        }
        return this;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (commandList: #" + this.commandList.size() + ")");
        result.append(" (resultIndex: " + this.resultIndex + ")");
        return result.toString();
    }
}

