/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.core.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.viatra2.core.EDeleteSemantics;
import org.eclipse.viatra2.core.ICoreNotificationListener;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.core.IUndoManager;
import org.eclipse.viatra2.core.notification.ICoreNotificationObject;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateEntity;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateInstanceOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectCreateSupertypeOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteContainment;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteEntity;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteInstanceOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteRelation;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectDeleteSupertypeOf;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectMoveTo;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetName;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetRelationFrom;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetRelationTo;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetValue;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectSetViewInfo;
import org.eclipse.viatra2.core.notification.ICoreNotificationObjectUserMark;
import org.eclipse.viatra2.core.notification.NotificationType;
import org.eclipse.viatra2.core.simple.SimpleEntity;
import org.eclipse.viatra2.core.simple.SimpleModelElement;
import org.eclipse.viatra2.core.simple.SimpleModelManager;
import org.eclipse.viatra2.core.simple.SimpleRelation;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectAtomicStepReady;
import org.eclipse.viatra2.core.simple.notification.NotificationObjectUserMark;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.errors.VPMCoreNullParameterException;
import org.eclipse.viatra2.errors.VPMCoreRuntimeException;
import org.eclipse.viatra2.errors.VPMRuntimeException;
import org.eclipse.viatra2.logger.Logger;

public class SimpleUndoManager
implements IUndoManager,
ICoreNotificationListener {
    IModelSpace modelSpace;
    SimpleModelManager mManager;
    Logger logger;
    private Stack<ICoreNotificationObject> undoStack = new Stack();
    boolean underUndo = false;
    boolean checkConsistencyOn = false;

    @Override
    public void init(Logger l, IModelSpace m) throws VPMRuntimeException {
        this.logger = l;
        this.modelSpace = m;
        this.mManager = (SimpleModelManager)this.modelSpace.getModelManager();
    }

    @Override
    public void nextUndoBlock(String name) {
        NotificationObjectUserMark no = new NotificationObjectUserMark(name);
        this.undoStack.push(no);
    }

    @Override
    public boolean canUndo() {
        return !this.undoStack.empty();
    }

    @Override
    public void flushUndoBuffer() {
        this.undoStack = new Stack();
    }

    @Override
    public void undo() {
        this.underUndo = true;
        boolean empty = false;
        boolean wasChange = false;
        ICoreNotificationObject note = null;
        do {
            if (this.undoStack.isEmpty()) {
                empty = true;
                break;
            }
            note = this.undoStack.pop();
            try {
                wasChange = this.undoStep(note) || wasChange;
            }
            catch (VPMCoreException e) {
                this.logger.fatal("Error performing undo; message: " + e.getMessage());
            }
        } while (note.getActionTypeEnum() != NotificationType.ACTION_ATOMIC_STEP_READY || !wasChange);
        if (!empty) {
            this.undoStack.push(note);
        }
        this.underUndo = false;
    }

    @Override
    public void undo(String markName) {
        this.underUndo = true;
        boolean wasChange = false;
        boolean toLeave = false;
        ICoreNotificationObject note = null;
        while (!this.undoStack.isEmpty()) {
            note = this.undoStack.pop();
            try {
                wasChange = this.undoStep(note) || wasChange;
            }
            catch (VPMCoreException e) {
                this.logger.fatal("Error performing undo; message: " + e.getMessage());
            }
            switch (note.getActionTypeEnum()) {
                case ACTION_ATOMIC_STEP_READY: {
                    wasChange = false;
                    break;
                }
                case USER_MARK: {
                    ICoreNotificationObjectUserMark _note = (ICoreNotificationObjectUserMark)((Object)note);
                    String name = _note.getMarkName();
                    if (!name.equals(markName)) break;
                    toLeave = true;
                }
            }
            if (!toLeave || wasChange) continue;
        }
        this.undoStack.push(new NotificationObjectAtomicStepReady());
        this.underUndo = false;
    }

    @Override
    public void undo(String markName, int n) {
        int i = 0;
        while (i < n) {
            this.undo(markName);
            ++i;
        }
    }

    @Override
    public void undo(int n) {
        int i = 0;
        while (i < n) {
            this.undo();
            ++i;
        }
    }

    private boolean undoStep(ICoreNotificationObject note) throws VPMCoreException {
        NotificationType action = note.getActionTypeEnum();
        switch (action) {
            case ACTION_ATOMIC_STEP_READY: {
                return false;
            }
            case ACTION_CREATE_ENTITY: {
                ICoreNotificationObjectCreateEntity _note = (ICoreNotificationObjectCreateEntity)note;
                IEntity ent = _note.getCreated();
                try {
                    this.mManager.deleteEntity(ent, EDeleteSemantics.DELETE_SEMANTICS_FORCE);
                }
                catch (Exception e) {
                    throw new VPMCoreRuntimeException("undo step failed" + e.toString() + e.getStackTrace());
                }
                return true;
            }
            case ACTION_DELETE_ENTITY: {
                ICoreNotificationObjectDeleteEntity _note1 = (ICoreNotificationObjectDeleteEntity)note;
                IEntity ent1 = _note1.getDeleted();
                IEntity parent = _note1.getParent();
                this.mManager.undoCreateEntity((SimpleEntity)ent1, (SimpleEntity)parent);
                return true;
            }
            case ACTION_CREATE_RELATION: {
                ICoreNotificationObjectCreateRelation _note2 = (ICoreNotificationObjectCreateRelation)note;
                IRelation rel = _note2.getNewRelation();
                try {
                    this.mManager.deleteRelation(rel, EDeleteSemantics.DELETE_SEMANTICS_FORCE);
                }
                catch (Exception e) {
                    throw new VPMCoreRuntimeException("undo step failed" + e.toString() + e.getStackTrace());
                }
                return true;
            }
            case ACTION_DELETE_RELATION: {
                ICoreNotificationObjectDeleteRelation _note3 = (ICoreNotificationObjectDeleteRelation)note;
                this.mManager.undoCreateRelation((SimpleRelation)_note3.getDeleted(), (SimpleModelElement)_note3.getFrom(), (SimpleModelElement)_note3.getTo());
                return true;
            }
            case ACTION_CREATE_INSTANCEOF: {
                ICoreNotificationObjectCreateInstanceOf _note4 = (ICoreNotificationObjectCreateInstanceOf)note;
                SimpleModelElement sup = (SimpleModelElement)_note4.getType();
                SimpleModelElement sub = (SimpleModelElement)_note4.getInstance();
                try {
                    this.mManager.deleteInstanceOfEditor(sup, sub);
                }
                catch (VPMCoreNullParameterException e) {
                    this.logger.fatal("Error performing undo; message: " + e.getMessage());
                }
                return true;
            }
            case ACTION_DELETE_INSTANCEOF: {
                ICoreNotificationObjectDeleteInstanceOf _note5 = (ICoreNotificationObjectDeleteInstanceOf)note;
                SimpleModelElement sup = (SimpleModelElement)_note5.getType();
                SimpleModelElement sub = (SimpleModelElement)_note5.getInstance();
                try {
                    this.mManager.newInstanceOfEditor(sup, sub);
                }
                catch (Exception e) {
                    this.logger.fatal("Error performing undo; message: " + e.getMessage());
                }
                return true;
            }
            case ACTION_CREATE_SUPERTYPEOF: {
                ICoreNotificationObjectCreateSupertypeOf _note6 = (ICoreNotificationObjectCreateSupertypeOf)note;
                SimpleModelElement sup = (SimpleModelElement)_note6.getSuper();
                SimpleModelElement sub = (SimpleModelElement)_note6.getSub();
                try {
                    this.mManager.deleteSupertypeOfEditor(sup, sub);
                }
                catch (VPMCoreNullParameterException e) {
                    this.logger.fatal("Error performing undo; message: " + e.getMessage());
                }
                return true;
            }
            case ACTION_DELETE_SUPERTYPEOF: {
                ICoreNotificationObjectDeleteSupertypeOf _note7 = (ICoreNotificationObjectDeleteSupertypeOf)note;
                SimpleModelElement sup = (SimpleModelElement)_note7.getSuper();
                SimpleModelElement sub = (SimpleModelElement)_note7.getSub();
                try {
                    this.mManager.newSupertypeOfEditor(sup, sub);
                }
                catch (VPMCoreException e) {
                    this.logger.fatal("Error performing undo; message: " + e.getMessage());
                }
                return true;
            }
            case ACTION_DELETE_CONTAINMENT: {
                ICoreNotificationObjectDeleteContainment _note8 = (ICoreNotificationObjectDeleteContainment)note;
                SimpleEntity container = (SimpleEntity)_note8.getParent();
                SimpleEntity child = (SimpleEntity)_note8.getChild();
                try {
                    this.mManager.undoCreateContainment(container, child);
                }
                catch (VPMCoreNullParameterException e) {
                    this.logger.fatal("Error performing undo; message: " + e.getMessage());
                }
                return true;
            }
            case ACTION_SET_VALUE: {
                ICoreNotificationObjectSetValue _note9 = (ICoreNotificationObjectSetValue)note;
                SimpleEntity ent = (SimpleEntity)_note9.getEntity();
                String oldValue = _note9.getOldValue();
                try {
                    this.mManager.setValue(ent, oldValue);
                }
                catch (VPMCoreNullParameterException e) {
                    this.logger.fatal("Error performing undo; message: " + e.getMessage());
                }
                return true;
            }
            case ACTION_SET_NAME: {
                ICoreNotificationObjectSetName _note10 = (ICoreNotificationObjectSetName)note;
                SimpleModelElement elem = (SimpleModelElement)_note10.getElement();
                String oldName = _note10.getOldName();
                try {
                    this.mManager.setName(elem, oldName);
                }
                catch (VPMCoreNullParameterException e) {
                    this.logger.fatal("Error performing undo; message: " + e.getMessage());
                }
                return true;
            }
            case ACTION_MOVE_ELEMENT_TO: {
                ICoreNotificationObjectMoveTo _note11 = (ICoreNotificationObjectMoveTo)note;
                SimpleEntity ent = (SimpleEntity)_note11.getElement();
                SimpleEntity from = (SimpleEntity)_note11.getOldContainer();
                try {
                    this.mManager.moveEntityTo(ent, from);
                }
                catch (VPMCoreNullParameterException e) {
                    this.logger.fatal("Error performing undo; message: " + e.getMessage());
                }
                return true;
            }
            case ACTION_SET_RELATION_FROM: {
                ICoreNotificationObjectSetRelationFrom _note12 = (ICoreNotificationObjectSetRelationFrom)note;
                SimpleRelation rel = (SimpleRelation)_note12.getRelation();
                SimpleModelElement oldFrom = (SimpleModelElement)_note12.getOldFrom();
                try {
                    this.mManager.setRelationFrom(rel, oldFrom);
                }
                catch (VPMCoreNullParameterException e) {
                    this.logger.fatal("Error performing undo; message: " + e.getMessage());
                }
                return true;
            }
            case ACTION_SET_RELATION_TO: {
                ICoreNotificationObjectSetRelationTo _note13 = (ICoreNotificationObjectSetRelationTo)note;
                SimpleRelation rel = (SimpleRelation)_note13.getRelation();
                SimpleModelElement oldTo = (SimpleModelElement)_note13.getOldTo();
                try {
                    this.mManager.setRelationTo(rel, oldTo);
                }
                catch (VPMCoreNullParameterException e) {
                    this.logger.fatal("Error performing undo; message: " + e.getMessage());
                }
                return true;
            }
            case ACTION_SET_VIEW_INFO: {
                this.undoSetViewInfo((ICoreNotificationObjectSetViewInfo)note);
                return true;
            }
            case USER_MARK: {
                return false;
            }
        }
        return false;
    }

    void undoSetViewInfo(ICoreNotificationObjectSetViewInfo note) {
        IModelElement me = note.getElement();
        String oldViewInfo = note.getOldViewInfo();
        try {
            this.mManager.setViewInfo(me, oldViewInfo);
        }
        catch (VPMCoreException e) {
            this.logger.fatal("Error performing undo; message: " + e.getMessage());
        }
    }

    @Override
    public List<String> getUndoableList() {
        ArrayList<String> undoList = new ArrayList<String>();
        for (ICoreNotificationObject note : this.undoStack) {
            undoList.add(note.toString());
        }
        return undoList;
    }

    @Override
    public void actionPerformed(ICoreNotificationObject notification) {
        NotificationType type = notification.getActionTypeEnum();
        switch (type) {
            case TA_UNDOABLE_TRANSACTION_BEGIN: 
            case TA_TRANSACTION_BEGIN: 
            case TA_SUBTRANSACTION_BEGIN: 
            case TA_SUBTRANSACTION_END: 
            case TA_TRANSACTION_END: {
                return;
            }
        }
        if (!this.underUndo) {
            this.undoStack.add(notification);
        }
    }

    @Override
    public int getListenerCategory() {
        return 0;
    }

    @Override
    public List<String> getUndoList(int n) {
        int count = 0;
        ArrayList<String> ret = new ArrayList<String>();
        int last = this.undoStack.size();
        while (count < n) {
            ICoreNotificationObject note;
            if ((note = (ICoreNotificationObject)this.undoStack.get(--last)).getActionTypeEnum().equals((Object)NotificationType.USER_MARK)) {
                ret.add(((ICoreNotificationObjectUserMark)((Object)note)).getMarkName());
                ++count;
            }
            if (last == 0) break;
        }
        return ret;
    }
}

