/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.modelChecker;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.modelChecker.EProblemType;
import org.eclipse.viatra2.modelChecker.IProblem;
import org.eclipse.viatra2.tags.InfoTag;
import org.eclipse.viatra2.tags.TagKind;

public class Problem
extends InfoTag
implements IProblem {
    IModelElement endPoint;
    IRelation rel;
    IRelation relType;
    IEntity otherEntity;
    EProblemType problemType;

    public Problem(IModelElement point, IRelation rel, IRelation type, EProblemType problemType) {
        super("", null, 3, 1);
        this.endPoint = point;
        this.rel = rel;
        this.relType = type;
        this.otherEntity = null;
        this.problemType = problemType;
        this.generateErrorMessage();
    }

    public Problem(IModelElement point, IRelation rel, IEntity otherEntity, EProblemType problemType) {
        super("", null, 3, 1);
        this.endPoint = point;
        this.rel = rel;
        this.relType = null;
        this.otherEntity = otherEntity;
        this.problemType = problemType;
        this.generateErrorMessage();
    }

    @Override
    public IModelElement getEndPoint() {
        return this.endPoint;
    }

    @Override
    public IRelation getRelation() {
        return this.rel;
    }

    @Override
    public IRelation getRelationType() {
        return this.relType;
    }

    @Override
    public EProblemType getProblemType() {
        return this.problemType;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    protected void generateErrorMessage() {
        if (this.problemType.compareTo(EProblemType.INVALID_RELATION_SOURCE_TYPE) == 0) {
            this.message = "The source end '{1}' of relation '{2}' is not properly typed: expecting an element of type '{3}' according to the relation type '{4}'.";
            String[] context = new String[]{this.endPoint.getFullyQualifiedName(), this.rel.getFullyQualifiedName(), this.relType.getFrom().getFullyQualifiedName(), this.relType.getFullyQualifiedName()};
            this.bind(context);
        } else if (this.problemType.compareTo(EProblemType.INVALID_RELATION_TARGET_TYPE) == 0) {
            this.message = "The target end '{1}' of relation '{2}' is not properly typed: expecting an element of type '{3}' according to the relation type '{4}'.";
            String[] context = new String[]{this.endPoint.getFullyQualifiedName(), this.rel.getFullyQualifiedName(), this.relType.getTo().getFullyQualifiedName(), this.relType.getFullyQualifiedName()};
            this.bind(context);
        } else if (this.problemType.compareTo(EProblemType.AGGREGATION_INVALID) == 0) {
            this.message = "The type '{1}' of relation '{2}' prescribes aggregation, thus its target end '{3}' is required to be a child of '{4}'.";
            String[] context = new String[]{this.relType.getFullyQualifiedName(), this.rel.getFullyQualifiedName(), this.rel.getTo().getFullyQualifiedName(), this.endPoint.getFullyQualifiedName()};
            this.bind(context);
        } else if (this.problemType.compareTo(EProblemType.INVALID_RELATION_SOURCE) == 0) {
            this.message = "The source end of relation '{1} is not a valid model element.";
            String[] context = new String[]{this.rel.getFullyQualifiedName()};
            this.bind(context);
        } else if (this.problemType.compareTo(EProblemType.INVALID_RELATION_TARGET) == 0) {
            this.message = "The target end of relation '{1}' is not a valid model element.";
            String[] context = new String[]{this.rel.getFullyQualifiedName()};
            this.bind(context);
        } else if (this.problemType.compareTo(EProblemType.OUTGOING_MULTIPLICITY_CONSTRAINT_VIOLATED) == 0) {
            this.message = "The multiplicity of relation '{1}' is '{2}', but there are more than one outgoing edges from '{3}'.";
            String[] context = new String[]{this.rel.getFullyQualifiedName(), this.relType.getMultiplicity().toString(), this.endPoint.getFullyQualifiedName()};
            this.bind(context);
        } else if (this.problemType.compareTo(EProblemType.INCOMING_MULTIPLICITY_CONSTRAINT_VIOLATED) == 0) {
            this.message = "The multiplicity of relation '{1}' is '{2}', but there are more than one incoming edges to '{3}'.";
            String[] context = new String[]{this.rel.getFullyQualifiedName(), this.relType.getMultiplicity().toString(), this.endPoint.getFullyQualifiedName()};
            this.bind(context);
        } else if (this.problemType.compareTo(EProblemType.MULTIPLICITY_REFINEMENT_INVALID) == 0) {
            this.message = "The multiplicity of relation '{1}' is '{2}' while the multiplicity of its supertype '{3}' is '{4}' \n In case of relation refinement, the multiplicity of the subtype should always be a more restrictive than the multiplicity of the supertype.";
            String[] context = new String[]{this.rel.getFullyQualifiedName(), this.rel.getMultiplicity().toString(), this.relType.getFullyQualifiedName(), this.relType.getMultiplicity().toString()};
            this.bind(context);
        } else if (this.problemType.compareTo(EProblemType.AGGREGATION_REFINEMENT_INVALID) == 0) {
            this.message = "The 'isAggregation' parameter of relation '{1}' is set to false, while its supertype '{2}' prescribes 'isAggregation' to be true for all subtypes";
            String[] context = new String[]{this.rel.getFullyQualifiedName(), this.relType.getFullyQualifiedName()};
            this.bind(context);
        } else if (this.problemType.compareTo(EProblemType.INVALID_REFINEMENT_SOURCE_TYPE) == 0) {
            this.message = "Relation '{2}' is not a valid subtype of relation '{1}' as the refinement of source ends is invalid.";
            String[] context = new String[]{this.rel.getFullyQualifiedName(), this.relType.getFullyQualifiedName()};
            this.bind(context);
        } else if (this.problemType.compareTo(EProblemType.INVALID_REFINEMENT_TARGET_TYPE) == 0) {
            this.message = "Relation '{2}' is not a valid subtype of relation '{1}' as the refinement of target ends is invalid.";
            String[] context = new String[]{this.rel.getFullyQualifiedName(), this.relType.getFullyQualifiedName()};
            this.bind(context);
        } else if (this.problemType.compareTo(EProblemType.INVALID_REFINEMENT) == 0) {
            this.message = "Relation '{1}' has an invalid refinement to an entity '{2}'.";
            String[] context = new String[]{this.rel.getFullyQualifiedName(), this.otherEntity.getFullyQualifiedName()};
            this.bind(context);
        }
    }

    public void bind(String[] context) {
        if (context.length >= 1) {
            this.message = this.message.replace("{1}", context[0]);
        }
        if (context.length >= 2) {
            this.message = this.message.replace("{2}", context[1]);
        }
        if (context.length >= 3) {
            this.message = this.message.replace("{3}", context[2]);
        }
        if (context.length >= 4) {
            this.message = this.message.replace("{4}", context[3]);
        }
    }

    @Override
    public Set<IModelElement> getAssociatedElements() {
        HashSet<IModelElement> r = new HashSet<IModelElement>();
        if (this.endPoint != null) {
            r.add(this.endPoint);
        }
        if (this.rel != null) {
            r.add(this.rel);
        }
        if (this.relType != null) {
            r.add(this.relType);
        }
        return r;
    }

    @Override
    public TagKind getKind() {
        return TagKind.MODELING_PROBLEM;
    }
}

