/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.tags.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.modelChecker.impl.ProblemManager;
import org.eclipse.viatra2.tags.ITag;
import org.eclipse.viatra2.tags.ITagManager;
import org.eclipse.viatra2.tags.TagKind;

public class TagManager
implements ITagManager {
    private HashMap<IModelElement, HashSet<ITag>> mE_tags = new HashMap();
    private HashSet<ITag> allTags = new HashSet();
    private IFile iFile;
    private IFramework fw;
    private ProblemManager problemManager;

    @Override
    public void addTag(ITag tag) {
        this.allTags.add(tag);
        for (IModelElement me : tag.getAssociatedElements()) {
            HashSet<ITag> me_tags = this.mE_tags.get(me);
            if (me_tags == null) {
                me_tags = new HashSet();
                this.mE_tags.put(me, me_tags);
            }
            me_tags.add(tag);
        }
        try {
            int markerSeverity;
            String markerType;
            if (tag.getKind().equals((Object)TagKind.MODELING_PROBLEM)) {
                markerType = "org.eclipse.core.resources.problemmarker";
                markerSeverity = 2;
            } else {
                markerType = "org.eclipse.core.resources.problemmarker";
                markerSeverity = 0;
            }
            String affectedFQNs = "";
            for (IModelElement me : tag.getAssociatedElements()) {
                affectedFQNs = String.valueOf(affectedFQNs) + me.getFullyQualifiedName() + ";";
            }
            IMarker marker = this.iFile.createMarker(markerType);
            marker.setAttribute("priority", 1);
            marker.setAttribute("severity", markerSeverity);
            marker.setAttribute("message", (Object)tag.getMessage());
            marker.setAttribute("userEditable", false);
            marker.setAttribute("location", (Object)affectedFQNs);
            tag.setMarker(marker);
        }
        catch (CoreException e) {
            this.fw.getLogger().error("[TagManager::clearAddTag()]" + e.getMessage());
        }
    }

    @Override
    public void clearAllTags() {
        this.fw.getTopmodel().getTransactionManager().beginTransaction();
        this.allTags.clear();
        for (IModelElement me : this.mE_tags.keySet()) {
            this.mE_tags.get(me).clear();
        }
        try {
            this.iFile.deleteMarkers("org.eclipse.core.resources.marker", true, 2);
        }
        catch (CoreException e) {
            this.fw.getLogger().error("[TagManager::clearAllTags()]" + e.getMessage());
        }
        this.fw.getTopmodel().getTransactionManager().commitTransaction();
    }

    private void clearAllProblemTags() {
        this.fw.getTopmodel().getTransactionManager().beginTransaction();
        try {
            if (this.iFile != null) {
                this.iFile.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            }
        }
        catch (CoreException e) {
            this.fw.getLogger().error("[TagManager::clearAllProblemTags()]" + e.getMessage());
        }
        this.fw.getTopmodel().getTransactionManager().commitTransaction();
    }

    @Override
    public void clearTag(ITag t) {
        if (t != null) {
            try {
                t.getMarker().delete();
            }
            catch (CoreException e) {
                this.fw.getLogger().error("[TagManager::clearTag(t)]" + e.getMessage());
            }
            this.allTags.remove(t);
            for (IModelElement _me : t.getAssociatedElements()) {
                this.mE_tags.get(_me).remove(t);
            }
        }
    }

    @Override
    public void clearTags(IModelElement me) {
        HashSet<ITag> t = this.mE_tags.get(me);
        HashSet<ITag> filter = new HashSet<ITag>();
        if (t != null) {
            for (ITag tt : t) {
                if (tt.getMarker() != null) {
                    try {
                        tt.getMarker().delete();
                    }
                    catch (CoreException e) {
                        this.fw.getLogger().error("[TagManager::clearTags(me)]" + e.getMessage());
                    }
                }
                filter.add(tt);
                this.allTags.remove(tt);
            }
            t.clear();
            for (ITag _t : filter) {
                for (IModelElement _me : _t.getAssociatedElements()) {
                    this.mE_tags.get(_me).remove(_t);
                }
            }
        }
    }

    @Override
    public void clearTags(TagKind kind) {
        HashSet<ITag> filter = new HashSet<ITag>();
        for (ITag t : this.allTags) {
            if (!t.getKind().equals((Object)kind)) continue;
            filter.add(t);
        }
        this.allTags.removeAll(filter);
        filter.clear();
        for (IModelElement me : this.mE_tags.keySet()) {
            for (ITag tt : this.mE_tags.get(me)) {
                if (!tt.getKind().equals((Object)kind)) continue;
                filter.add(tt);
            }
            this.mE_tags.get(me).removeAll(filter);
        }
        for (ITag ttt : filter) {
            try {
                if (!ttt.getMarker().exists()) continue;
                ttt.getMarker().delete();
            }
            catch (CoreException e) {
                this.fw.getLogger().error("[TagManager::clearTags(tagKind)] " + e.getMessage());
            }
        }
    }

    @Override
    public Set<ITag> getAllTags() {
        return this.allTags;
    }

    @Override
    public Set<ITag> getTagsForModelElement(IModelElement me) {
        return this.mE_tags.get(me);
    }

    @Override
    public void init(IFramework fw) {
        this.fw = fw;
        this.iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fw.getCurrentFilename()));
        this.clearAllProblemTags();
        this.problemManager = new ProblemManager();
        this.problemManager.init(fw);
    }

    @Override
    public void resetProblemManager() {
        this.problemManager.fullCheck();
    }
}

