/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelSpace;
import org.eclipse.viatra2.framework.FrameworkManager;
import org.eclipse.viatra2.framework.FrameworkManagerException;
import org.eclipse.viatra2.framework.IFramework;
import org.eclipse.viatra2.framework.properties.IViatraPropertyChangedListener;
import org.eclipse.viatra2.treeeditor.Plugin;
import org.eclipse.viatra2.treeeditor.actions.ExportToVTMLAction;
import org.eclipse.viatra2.treeeditor.actions.LocalDeleteAction;
import org.eclipse.viatra2.treeeditor.actions.NavigateRelationAction;
import org.eclipse.viatra2.treeeditor.actions.NavigateRelationSourceAction;
import org.eclipse.viatra2.treeeditor.actions.NewEntityAction;
import org.eclipse.viatra2.treeeditor.actions.NewRelationAction;
import org.eclipse.viatra2.treeeditor.actions.RenameAction;
import org.eclipse.viatra2.treeeditor.actions.ViatraDeleteAction;
import org.eclipse.viatra2.treeeditor.actions.ViatraRedoAction;
import org.eclipse.viatra2.treeeditor.actions.ViatraTreeEditorSelectionAction;
import org.eclipse.viatra2.treeeditor.actions.ViatraUndoAction;
import org.eclipse.viatra2.treeeditor.commands.ViatraEditorCommandStack;
import org.eclipse.viatra2.treeeditor.menu.ViatraTreeEditorActionBarContributor;
import org.eclipse.viatra2.treeeditor.menu.ViatraTreeEditorMenuListener;
import org.eclipse.viatra2.treeeditor.properties.VPMPropertySheetPage;
import org.eclipse.viatra2.treeeditor.providers.IDirtyFlagChangedListener;
import org.eclipse.viatra2.treeeditor.providers.IMessageDialogProvider;
import org.eclipse.viatra2.treeeditor.providers.ViatraContentProvider;
import org.eclipse.viatra2.treeeditor.providers.ViatraLabelProvider;
import org.eclipse.viatra2.treeeditor.providers.ViatraRootProvider;
import org.eclipse.viatra2.treeeditor.providers.ViatraTreeMouseListener;
import org.eclipse.viatra2.treeeditor.providers.ViatraTreeviewSorter;
import org.eclipse.viatra2.treeeditor.resource.FrameworkEditorInput;
import org.eclipse.viatra2.treeeditor.transfer.ViatraEditorDragSourceListener;
import org.eclipse.viatra2.treeeditor.transfer.ViatraEditorDropTargetAdapter;

public class ViatraTreeEditor
extends EditorPart
implements ISelectionChangedListener,
IDirtyFlagChangedListener,
IMessageDialogProvider,
IViatraPropertyChangedListener {
    private ResourceTracker resourceTracker;
    private TreeViewer treeViewer;
    private NewEntityAction iNewEntityAction;
    private NewRelationAction iNewRelationAction;
    private NavigateRelationAction iNavigateAction;
    private NavigateRelationSourceAction iNavigateSourceAction;
    private ExportToVTMLAction iExportAction;
    private RenameAction iRenameAction;
    private LocalDeleteAction iLocalDeleteAction;
    private Map<String, List<ViatraTreeEditorSelectionAction>> contributedActions;
    private ViatraDeleteAction iDeleteAction;
    private ViatraUndoAction iUndoAction;
    private ViatraRedoAction iRedoAction;
    private final ViatraEditorCommandStack iCommandStack = new ViatraEditorCommandStack(this);
    private boolean isDirty = false;
    private FrameworkManager iFrameWorkManager;
    private IFramework iFramework;
    private String iShortFilename;
    private String iFilename;
    private IModelSpace iModelSpace;
    VPMPropertySheetPage iPropsPage;
    IGotoMarker gotoMarker;

    protected void setInput(IEditorInput input) {
        IFile file;
        if (this.getEditorInput() != null && this.getEditorInput() instanceof FileEditorInput) {
            file = ((FileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
        }
        super.setInput(input);
        this.manageInputChange();
        if (this.getEditorInput() != null && this.getEditorInput() instanceof FileEditorInput) {
            file = ((FileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
        }
    }

    void closeEditor(final boolean save) {
        this.getSite().getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ViatraTreeEditor.this.getSite().getPage().closeEditor((IEditorPart)ViatraTreeEditor.this, save);
            }
        });
    }

    private ResourceTracker getResourceTracker() {
        if (this.resourceTracker == null) {
            this.resourceTracker = new ResourceTracker();
        }
        return this.resourceTracker;
    }

    public LocalDeleteAction getLocalDeleteAction() {
        return this.iLocalDeleteAction;
    }

    public RenameAction getRenameAction() {
        return this.iRenameAction;
    }

    public ExportToVTMLAction getExportAction() {
        return this.iExportAction;
    }

    public NewEntityAction getNewEntityAction() {
        return this.iNewEntityAction;
    }

    public NewRelationAction getNewRelationAction() {
        return this.iNewRelationAction;
    }

    public NavigateRelationAction getNavigateRelationAction() {
        return this.iNavigateAction;
    }

    public ViatraDeleteAction getDeleteAction() {
        return this.iDeleteAction;
    }

    public ViatraRedoAction getRedoAction() {
        return this.iRedoAction;
    }

    public ViatraUndoAction getUndoAction() {
        return this.iUndoAction;
    }

    public ViatraEditorCommandStack getCommandStack() {
        return this.iCommandStack;
    }

    public IFramework getFramework() {
        return this.iFramework;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void setTreeViewer(TreeViewer viewer) {
        this.treeViewer = viewer;
    }

    public void doSave(IProgressMonitor monitor) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor _monitor) throws InvocationTargetException, InterruptedException {
                try {
                    ViatraTreeEditor.this.iFramework.saveFile(ViatraTreeEditor.this.iFilename);
                    ((FileEditorInput)ViatraTreeEditor.this.getEditorInput()).getFile().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        this.runLongTransaction(runnable);
        this.iFramework.getLogger().info("Saved " + this.iFilename);
        this.iCommandStack.markSave();
        this.isDirty = false;
        this.updateActions();
        this.firePropertyChange(257);
        this.firePropertyChange(1);
    }

    public void doSaveAs() {
        SaveAsDialog dd = new SaveAsDialog(this.getEditorSite().getShell());
        dd.setBlockOnOpen(true);
        dd.setTitle("Select new file");
        dd.setOriginalName(this.iShortFilename);
        if (dd.open() == 0) {
            IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFile(dd.getResult());
            this.iFilename = ifile.getLocation().toOSString();
            this.iShortFilename = ifile.getLocation().lastSegment();
            this.doSave(null);
            this.setInput((IEditorInput)new FileEditorInput(ifile));
            this.manageInputChange();
        }
    }

    public boolean isDirty() {
        return this.isDirty || this.iCommandStack.isDirty();
    }

    @Override
    public void setDirty() {
        this.isDirty = true;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ViatraTreeEditor.this.firePropertyChange(257);
            }
        });
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void createPartControl(Composite parent) {
        TreeViewer treeviewer = new TreeViewer(parent, 770);
        this.setTreeViewer(treeviewer);
        this.getTreeViewer().addDropSupport(7, ViatraEditorDropTargetAdapter.getTransfers(), (DropTargetListener)new ViatraEditorDropTargetAdapter(this));
        this.getTreeViewer().addDragSupport(7, ViatraEditorDropTargetAdapter.getTransfers(), (DragSourceListener)new ViatraEditorDragSourceListener(this));
        this.getTreeViewer().getTree().addMouseListener((MouseListener)new ViatraTreeMouseListener(this, this.getTreeViewer().getTree()));
        this.getTreeViewer().setUseHashlookup(true);
        this.createActions();
        this.contributeToActionBars();
        this.initializeContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.getTreeViewer());
        this.initializeTreeViewer();
    }

    private void manageInputChange() {
        IEditorInput element = this.getEditorInput();
        this.iShortFilename = element.getName();
        this.iFilename = null;
        if (element instanceof IPathEditorInput) {
            this.iFilename = ((IPathEditorInput)element).getPath().toOSString();
        } else if (element instanceof FrameworkEditorInput) {
            this.iFramework = ((FrameworkEditorInput)element).getFramework();
            this.iFilename = this.iFramework.getCurrentFilename();
        } else {
            this.showMessage("Invalid input received for Viatra Tree Editor");
            return;
        }
        if (this.iFramework != null) {
            if (this.iFilename != null) {
                this.iFramework.setCurrentFileName(this.iFilename);
            } else {
                this.iFramework.setCurrentFileName(this.iShortFilename);
            }
        }
        this.firePropertyChange(1);
    }

    public void runLongTransaction(final IRunnableWithProgress runnable) {
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ProgressMonitorDialog d = new ProgressMonitorDialog(display.getActiveShell());
                try {
                    d.run(true, false, runnable);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ViatraTreeEditor.this.showMessage(e.getMessage());
                    ViatraTreeEditor.this.iFramework.getLogger().fatal("Error executing operation (" + e.getClass().getCanonicalName() + ") [" + e.getMessage() + "]");
                }
            }
        });
    }

    protected void initializeTreeViewer() {
        this.iFrameWorkManager = FrameworkManager.getInstance();
        this.manageInputChange();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (ViatraTreeEditor.this.iFramework == null && ViatraTreeEditor.this.getEditorInput() instanceof IPathEditorInput) {
                    try {
                        monitor.beginTask("Loading VPM modelspace", 3);
                        monitor.worked(2);
                        ViatraTreeEditor.this.iFramework = ViatraTreeEditor.this.iFrameWorkManager.createFramework(ViatraTreeEditor.this.iFilename);
                        monitor.done();
                    }
                    catch (FrameworkManagerException e) {
                        e.printStackTrace();
                        ViatraTreeEditor.this.showMessage(e.getMessage());
                    }
                }
            }
        };
        this.runLongTransaction(runnable);
        if (this.iFramework != null) {
            this.iModelSpace = this.iFramework.getTopmodel();
            this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
            this.getTreeViewer().setContentProvider((IContentProvider)new ViatraContentProvider(this.getTreeViewer(), this));
            this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new ViatraLabelProvider(this));
            this.getTreeViewer().setSorter((ViewerSorter)new ViatraTreeviewSorter());
            this.getTreeViewer().setComparer(new IElementComparer(){

                public boolean equals(Object a, Object b) {
                    if (a == null && b == null) {
                        return true;
                    }
                    if (a == null || b == null) {
                        return false;
                    }
                    if (a instanceof IModelElement && b instanceof IModelElement) {
                        return a.equals(b);
                    }
                    if (a instanceof ViatraRootProvider && b instanceof ViatraRootProvider) {
                        return a == b;
                    }
                    return false;
                }

                public int hashCode(Object element) {
                    return element == null ? 0 : element.hashCode();
                }
            });
            this.getTreeViewer().setInput((Object)new ViatraRootProvider(this.iModelSpace.getModelManager().getRoot()));
            this.firePropertyChange(1);
            this.iFramework.getProperties().getProvider("VIATRA2 Tree Editor").addListener((IViatraPropertyChangedListener)this);
        }
    }

    public String getTitle() {
        return this.iShortFilename;
    }

    public String getTitleToolTip() {
        return this.iFilename;
    }

    public void dispose() {
        if (this.iFrameWorkManager != null && this.iFramework != null) {
            this.iFramework.getProperties().getProvider("VIATRA2 Tree Editor").removeListener((IViatraPropertyChangedListener)this);
            try {
                this.iFrameWorkManager.disposeFramework(this.iFramework.getId());
            }
            catch (Exception e) {
                this.showMessage(e.getMessage());
            }
        }
        if (this.getEditorInput() != null && this.getEditorInput() instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
        }
        super.dispose();
    }

    public void updateLabels() {
        if (this.treeViewer != null) {
            this.treeViewer.refresh(true);
        }
    }

    private VPMPropertySheetPage getPropsPage() {
        if (this.iPropsPage == null) {
            this.iPropsPage = new VPMPropertySheetPage(this);
        }
        return this.iPropsPage;
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            return this.getPropsPage();
        }
        if (type == IGotoMarker.class) {
            if (this.gotoMarker == null) {
                this.gotoMarker = new IGotoMarker(){

                    public void gotoMarker(IMarker marker) {
                        if (marker.exists()) {
                            try {
                                Map attrs = marker.getAttributes();
                                if (attrs != null && attrs.containsKey("location")) {
                                    String[] fqn;
                                    String fqns = attrs.get("location").toString();
                                    String[] stringArray = fqn = fqns.split(";");
                                    int n = fqn.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        final String _fqn = stringArray[n2];
                                        Display.getDefault().asyncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                ViatraTreeEditor.this.getTreeViewer().reveal((Object)ViatraTreeEditor.this.iFramework.getTopmodel().getModelManager().getElementByName(_fqn));
                                            }
                                        });
                                        ++n2;
                                    }
                                }
                            }
                            catch (CoreException e) {
                                ViatraTreeEditor.this.iFramework.getLogger().info("[gotoMarker()] " + e.getMessage());
                            }
                        }
                    }
                };
            }
            return this.gotoMarker;
        }
        return super.getAdapter(type);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    protected void initializeContextMenu() {
        MenuManager menuMgr = new MenuManager("ViatraTreeEditorPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        ViatraTreeEditorMenuListener menuListener = new ViatraTreeEditorMenuListener(this);
        menuMgr.addMenuListener((IMenuListener)menuListener);
        Menu menu = menuMgr.createContextMenu(this.getTreeViewer().getControl());
        this.getTreeViewer().getControl().setMenu(menu);
    }

    protected void createActions() {
        this.iLocalDeleteAction = new LocalDeleteAction((IWorkbenchPart)this);
        this.iNewEntityAction = new NewEntityAction((IWorkbenchPart)this);
        this.iNavigateAction = new NavigateRelationAction((IWorkbenchPart)this);
        this.iNavigateSourceAction = new NavigateRelationSourceAction((IWorkbenchPart)this);
        this.iNewRelationAction = new NewRelationAction((IWorkbenchPart)this);
        this.iExportAction = new ExportToVTMLAction((IWorkbenchPart)this);
        this.iRenameAction = new RenameAction((IWorkbenchPart)this);
        if (this.getEditorSite().getActionBarContributor() != null && this.getEditorSite().getActionBarContributor() instanceof ViatraTreeEditorActionBarContributor) {
            this.iDeleteAction = ((ViatraTreeEditorActionBarContributor)this.getEditorSite().getActionBarContributor()).getDeleteAction();
            this.iUndoAction = ((ViatraTreeEditorActionBarContributor)this.getEditorSite().getActionBarContributor()).getUndoAction();
            this.iRedoAction = ((ViatraTreeEditorActionBarContributor)this.getEditorSite().getActionBarContributor()).getRedoAction();
        }
        this.contributedActions = Plugin.getDefault().getContributedActions();
        for (List<ViatraTreeEditorSelectionAction> cAs : this.contributedActions.values()) {
            for (ViatraTreeEditorSelectionAction a : cAs) {
                a.setWorkbenchPart((IWorkbenchPart)this);
            }
            Collections.sort(cAs, new Comparator<ViatraTreeEditorSelectionAction>(){

                @Override
                public int compare(ViatraTreeEditorSelectionAction arg0, ViatraTreeEditorSelectionAction arg1) {
                    return arg0.getOrderNumber().compareTo(arg1.getOrderNumber());
                }
            });
        }
    }

    public void setFocus() {
        this.getTreeViewer().getControl().setFocus();
        this.updateActions();
    }

    public void updateActions() {
        if (this.iDeleteAction != null) {
            this.iDeleteAction.updateSelf(this);
        }
        if (this.iUndoAction != null) {
            this.iUndoAction.updateSelf(this);
        }
        if (this.iRedoAction != null) {
            this.iRedoAction.updateSelf(this);
        }
        this.getEditorSite().getActionBars().getToolBarManager().update(true);
        this.iLocalDeleteAction.updateSelf();
        this.iNewEntityAction.updateSelf();
        this.iNewRelationAction.updateSelf();
        this.iExportAction.updateSelf();
        this.iNavigateAction.updateSelf();
        this.iRenameAction.updateSelf();
        for (List<ViatraTreeEditorSelectionAction> as : this.getContributedActions().values()) {
            for (ViatraTreeEditorSelectionAction a : as) {
                a.updateSelf();
            }
        }
    }

    @Override
    public void showMessage(final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)ViatraTreeEditor.this.getSite().getShell(), (String)"Viatra Tree Editor", (String)message);
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getEditorSite().getActionBars();
        this.registerGlobalActions(bars);
        this.fillLocalPullDown(bars.getMenuManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void registerGlobalActions(IActionBars bars) {
        if (this.iDeleteAction != null) {
            bars.setGlobalActionHandler(this.iDeleteAction.getId(), (IAction)this.iDeleteAction);
        }
        if (this.iUndoAction != null) {
            bars.setGlobalActionHandler(this.iUndoAction.getId(), (IAction)this.iUndoAction);
        }
        if (this.iRedoAction != null) {
            bars.setGlobalActionHandler(this.iRedoAction.getId(), (IAction)this.iRedoAction);
        }
    }

    public void propertyChanged(String providerID, String propertyID, String oldVal, String newVal) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ViatraTreeEditor.this.updateLabels();
            }
        });
    }

    public Map<String, List<ViatraTreeEditorSelectionAction>> getContributedActions() {
        return this.contributedActions;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateActions();
    }

    public IAction getNavigateRelationSourceAction() {
        return this.iNavigateSourceAction;
    }

    private class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !delta.getResource().equals((Object)((IFileEditorInput)ViatraTreeEditor.this.getEditorInput()).getFile())) {
                return true;
            }
            if (delta.getKind() == 2) {
                if ((0x2000 & delta.getFlags()) == 0) {
                    if (!ViatraTreeEditor.this.isDirty()) {
                        ViatraTreeEditor.this.closeEditor(false);
                    }
                } else {
                    final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    Display display = ViatraTreeEditor.this.getSite().getShell().getDisplay();
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ViatraTreeEditor.this.setInput((IEditorInput)new FileEditorInput(newFile));
                        }
                    });
                }
            } else if (delta.getKind() == 4) {
                IMarkerDelta[] iMarkerDeltaArray = delta.getMarkerDeltas();
                int n = iMarkerDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarkerDelta md = iMarkerDeltaArray[n2];
                    IMarker marker = md.getMarker();
                    if (ViatraTreeEditor.this.iFramework != null) {
                        try {
                            Map attrs = marker.getAttributes();
                            if (attrs != null && attrs.containsKey("location")) {
                                String[] fqn;
                                String fqns = attrs.get("location").toString();
                                String[] stringArray = fqn = fqns.split(";");
                                int n3 = fqn.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    final String _fqn = stringArray[n4];
                                    Display.getDefault().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (ViatraTreeEditor.this.getTreeViewer() != null) {
                                                ViatraTreeEditor.this.getTreeViewer().refresh((Object)ViatraTreeEditor.this.iFramework.getTopmodel().getModelManager().getElementByName(_fqn));
                                            }
                                        }
                                    });
                                    ++n4;
                                }
                            }
                        }
                        catch (CoreException e) {
                            ViatraTreeEditor.this.iFramework.getLogger().error("[ResourceTracker::visit()] " + e.getMessage());
                        }
                    }
                    ++n2;
                }
            }
            return false;
        }
    }
}

