/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.treeeditor.commands;

import java.util.Vector;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.treeeditor.ViatraTreeEditor;
import org.eclipse.viatra2.treeeditor.commands.ViatraEditorCommand;

public class ViatraEditorCommandStack {
    private Vector<ViatraEditorCommand> iCommands = new Vector();
    private ViatraTreeEditor iVTE;
    private int iCurrentIndex = 0;

    public ViatraEditorCommandStack(ViatraTreeEditor vte) {
        this.iCommands.add(new SaveMark());
        this.iVTE = vte;
    }

    public void execute(ViatraEditorCommand cmd) {
        try {
            cmd.execute();
            int i = this.iCurrentIndex + 1;
            while (i < this.iCommands.size()) {
                this.iCommands.remove(i);
                ++i;
            }
            this.iCommands.add(cmd);
            ++this.iCurrentIndex;
        }
        catch (VPMCoreException e) {
            this.iVTE.getFramework().getLogger().fatal(e.toString());
            this.iVTE.getFramework().getTopmodel().getTransactionManager().abortTransaction();
        }
    }

    public void undo() {
        try {
            this.iCommands.get(this.iCurrentIndex).undo();
            --this.iCurrentIndex;
        }
        catch (VPMCoreException e) {
            this.iVTE.getFramework().getLogger().fatal(e.toString());
        }
        this.iVTE.updateActions();
    }

    public void redo() {
        try {
            this.iCommands.get(this.iCurrentIndex + 1).execute();
            ++this.iCurrentIndex;
        }
        catch (VPMCoreException e) {
            this.iVTE.getFramework().getLogger().fatal(e.toString());
        }
        this.iVTE.updateActions();
    }

    private void debugmsg() {
        this.iVTE.getFramework().getLogger().debug("[VECommandStack] currindex is " + this.iCurrentIndex + ", element at currindex is " + this.iCommands.get(this.iCurrentIndex).toString());
    }

    public boolean isUndoable() {
        return this.isDirty();
    }

    public boolean isRedoable() {
        return this.iCurrentIndex < this.iCommands.size() - 1;
    }

    public void markSave() {
        this.execute(new SaveMark());
    }

    public boolean isDirty() {
        return !(this.iCommands.get(this.iCurrentIndex) instanceof SaveMark);
    }

    private class SaveMark
    extends ViatraEditorCommand {
        private SaveMark() {
        }

        @Override
        public void execute() throws VPMCoreException {
        }

        @Override
        public void undo() throws VPMCoreException {
        }
    }
}

