/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.interpreter.impl.rules;

import org.eclipse.viatra2.core.EDeleteSemantics;
import org.eclipse.viatra2.core.EMultiplicityKind;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.interpreter.executionEnvironment.IExecutionEnvironment;
import org.eclipse.viatra2.gtasm.interpreter.impl.machine.ASMInterpreterException;
import org.eclipse.viatra2.gtasm.interpreter.impl.rules.RuleInterpreter;
import org.eclipse.viatra2.gtasm.interpreter.term.rules.TermEvaluator;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.Annotation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.CopySemantics;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.DeleteSemantics;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.MultiplicityKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.simpleRules.ASMRuleInvocation;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.terms.VariableReference;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.copymove.ModelCopyRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.copymove.MoveRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.creation.CreateInstanceOf;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.creation.CreateSupertypeOf;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.creation.EntityCreateRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.creation.RelationCreateRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.deletion.DeleteInstanceOf;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.deletion.DeleteSupertypeOf;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.deletion.ElementDeleteRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.update.RenameRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.update.SetAggregationRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.update.SetAnySourceRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.update.SetAnyTargetRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.update.SetInverseRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.update.SetMultiplicityRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.update.SetRelationFrom;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.update.SetRelationTo;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.update.SetRule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.modelmanagement.manipulationRules.update.SetValueRule;
import org.eclipse.viatra2.interpreters.IProgressReport;

public class ModelManipulationRuleInterpreter
extends RuleInterpreter {
    private static ModelManipulationRuleInterpreter _instance = new ModelManipulationRuleInterpreter();

    private ModelManipulationRuleInterpreter() {
    }

    public static ModelManipulationRuleInterpreter getInstance() {
        return _instance;
    }

    @Override
    public Boolean interpretRule(IExecutionEnvironment executionEnvironment, ASMRuleInvocation ruleToBeInterpreted, IProgressReport pr) throws ViatraTransformationException {
        IModelManager manager = executionEnvironment.getFramework().getTopmodel().getModelManager();
        TermEvaluator termEvaluator = TermEvaluator.getInstance();
        if (ruleToBeInterpreted instanceof RenameRule) {
            Object name = termEvaluator.evaluate(executionEnvironment, ((RenameRule)ruleToBeInterpreted).getValue());
            if (ValueKind.UNDEF_LITERAL.equals(name)) {
                String[] context = new String[]{"Name", ruleToBeInterpreted.getName()};
                throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            if (name instanceof String) {
                Object modelElement = termEvaluator.evaluate(executionEnvironment, ((RenameRule)ruleToBeInterpreted).getElement());
                if (ValueKind.UNDEF_LITERAL.equals(modelElement)) {
                    String[] context = new String[]{"ModelElement", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                if (modelElement instanceof IModelElement) {
                    try {
                        manager.setName((IModelElement)modelElement, (String)name);
                        return Boolean.TRUE;
                    }
                    catch (VPMCoreException e) {
                        String[] context = new String[]{e.getMessage()};
                        throw new ASMInterpreterException("[INTERNAL ERROR] VPM Core exception caught: {1}", context, (AnnotatedElement)ruleToBeInterpreted);
                    }
                }
                String[] context = new String[]{"ModelElement", "ModelElementToSet", ruleToBeInterpreted.getName(), this.convertToJavaType(modelElement)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            String[] context = new String[]{"String", "Name", ruleToBeInterpreted.getName(), this.convertToJavaType(name)};
            throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
        }
        if (ruleToBeInterpreted instanceof SetValueRule) {
            Object value = termEvaluator.evaluate(executionEnvironment, ((SetRule)ruleToBeInterpreted).getValue());
            if (ValueKind.UNDEF_LITERAL.equals(value)) {
                String[] context = new String[]{"Value", ruleToBeInterpreted.getName()};
                throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            if (!(value instanceof String || value instanceof Integer || value instanceof Double)) {
                String[] context = new String[]{"String", "Value", ruleToBeInterpreted.getName(), this.convertToJavaType(value)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            Object modelElement = termEvaluator.evaluate(executionEnvironment, ((SetRule)ruleToBeInterpreted).getElement());
            if (modelElement instanceof IEntity) {
                try {
                    manager.setValue((IEntity)modelElement, value.toString());
                    return Boolean.TRUE;
                }
                catch (VPMCoreException e) {
                    String[] context = new String[]{e.getMessage()};
                    throw new ASMInterpreterException("[INTERNAL ERROR] VPM Core exception caught: {1}", context, (AnnotatedElement)ruleToBeInterpreted);
                }
            }
            if (ValueKind.UNDEF_LITERAL.equals(modelElement)) {
                String[] context = new String[]{"ModelElement", ruleToBeInterpreted.getName()};
                throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            String[] context = new String[]{"Entity", "EntityToSet", ruleToBeInterpreted.getName(), this.convertToJavaType(modelElement)};
            throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
        }
        if (ruleToBeInterpreted instanceof SetRelationTo) {
            Object relation = termEvaluator.evaluate(executionEnvironment, ((SetRule)ruleToBeInterpreted).getElement());
            Object modelElement = termEvaluator.evaluate(executionEnvironment, ((SetRule)ruleToBeInterpreted).getValue());
            if (!(relation instanceof IRelation)) {
                if (ValueKind.UNDEF_LITERAL.equals(relation)) {
                    String[] context = new String[]{"RelationToSet", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"Relation", "RelationToSet", ruleToBeInterpreted.getName(), this.convertToJavaType(modelElement)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            if (!(modelElement instanceof IModelElement)) {
                if (ValueKind.UNDEF_LITERAL.equals(modelElement)) {
                    String[] context = new String[]{"To", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"Entity", "To", ruleToBeInterpreted.getName(), this.convertToJavaType(modelElement)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            try {
                manager.setRelationTo((IRelation)relation, (IModelElement)modelElement);
                return Boolean.TRUE;
            }
            catch (VPMCoreException e) {
                String[] context = new String[]{e.getMessage()};
                throw new ASMInterpreterException("[INTERNAL ERROR] VPM Core exception caught: {1}", context, (AnnotatedElement)ruleToBeInterpreted);
            }
        }
        if (ruleToBeInterpreted instanceof SetRelationFrom) {
            Object relation = termEvaluator.evaluate(executionEnvironment, ((SetRule)ruleToBeInterpreted).getElement());
            Object modelElement = termEvaluator.evaluate(executionEnvironment, ((SetRule)ruleToBeInterpreted).getValue());
            if (!(relation instanceof IRelation) && ValueKind.UNDEF_LITERAL.equals(relation)) {
                if (ValueKind.UNDEF_LITERAL.equals(relation)) {
                    String[] context = new String[]{"RelationToSet", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"Relation", "RelationToSet", ruleToBeInterpreted.getName(), this.convertToJavaType(modelElement)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            if (!(modelElement instanceof IModelElement)) {
                if (ValueKind.UNDEF_LITERAL.equals(modelElement)) {
                    String[] context = new String[]{"From", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"Entity", "From", ruleToBeInterpreted.getName(), this.convertToJavaType(modelElement)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            try {
                manager.setRelationFrom((IRelation)relation, (IModelElement)modelElement);
                return Boolean.TRUE;
            }
            catch (VPMCoreException e) {
                String[] context = new String[]{e.getMessage()};
                throw new ASMInterpreterException("[INTERNAL ERROR] VPM Core exception caught: {1}", context, (AnnotatedElement)ruleToBeInterpreted);
            }
        }
        if (ruleToBeInterpreted instanceof SetMultiplicityRule) {
            Object relation = termEvaluator.evaluate(executionEnvironment, ((SetRule)ruleToBeInterpreted).getElement());
            Object multiplicity = termEvaluator.evaluate(executionEnvironment, ((SetRule)ruleToBeInterpreted).getValue());
            if (!(relation instanceof IRelation)) {
                if (ValueKind.UNDEF_LITERAL.equals(relation)) {
                    String[] context = new String[]{"RelationToSet", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"Relation", "RelationToSet", ruleToBeInterpreted.getName(), this.convertToJavaType(relation)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            if (!(multiplicity instanceof MultiplicityKind)) {
                String[] context = new String[]{"Multiplicity", "MultiplicityTobeSet", ruleToBeInterpreted.getName(), this.convertToJavaType(multiplicity)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            try {
                manager.setRelationMultiplicity((IRelation)relation, (EMultiplicityKind)multiplicity);
                return Boolean.TRUE;
            }
            catch (VPMCoreException e) {
                String[] context = new String[]{e.getMessage()};
                throw new ASMInterpreterException("[INTERNAL ERROR] VPM Core exception caught: {1}", context, (AnnotatedElement)ruleToBeInterpreted);
            }
        }
        if (ruleToBeInterpreted instanceof SetInverseRule) {
            Object relation1 = termEvaluator.evaluate(executionEnvironment, ((SetRule)ruleToBeInterpreted).getElement());
            Object relation2 = termEvaluator.evaluate(executionEnvironment, ((SetRule)ruleToBeInterpreted).getValue());
            if (!(relation1 instanceof IRelation)) {
                if (ValueKind.UNDEF_LITERAL.equals(relation1)) {
                    String[] context = new String[]{"RelationToSet", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"Relation", "RelationToSet", ruleToBeInterpreted.getName(), this.convertToJavaType(relation1)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            if (!(relation2 instanceof IRelation)) {
                if (ValueKind.UNDEF_LITERAL.equals(relation2)) {
                    String[] context = new String[]{"InverseRelation", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"Relation", "InverseRelation", ruleToBeInterpreted.getName(), this.convertToJavaType(relation2)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            try {
                manager.setRelationInverse((IRelation)relation1, (IRelation)relation2);
            }
            catch (VPMCoreException e) {
                String[] context = new String[]{e.getMessage()};
                throw new ASMInterpreterException("[INTERNAL ERROR] VPM Core exception caught: {1}", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            return Boolean.TRUE;
        }
        if (ruleToBeInterpreted instanceof SetAnyTargetRule) {
            Object relation = termEvaluator.evaluate(executionEnvironment, ((SetRule)ruleToBeInterpreted).getElement());
            Object bool = termEvaluator.evaluate(executionEnvironment, ((SetRule)ruleToBeInterpreted).getValue());
            if (!(relation instanceof IRelation)) {
                if (ValueKind.UNDEF_LITERAL.equals(relation)) {
                    String[] context = new String[]{"RelationToSet", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"Relation", "RelationToSet", ruleToBeInterpreted.getName(), this.convertToJavaType(relation)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            if (!(bool instanceof Boolean)) {
                if (ValueKind.UNDEF_LITERAL.equals(relation)) {
                    String[] context = new String[]{"isAnyTarget", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"Boolean", "isAnyTarget", ruleToBeInterpreted.getName(), this.convertToJavaType(relation)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            try {
                manager.setIsAnyTo((IRelation)relation, ((Boolean)bool).booleanValue());
            }
            catch (VPMCoreException e) {
                String[] context = new String[]{e.getMessage()};
                throw new ASMInterpreterException("[INTERNAL ERROR] VPM Core exception caught: {1}", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            return Boolean.TRUE;
        }
        if (ruleToBeInterpreted instanceof SetAnySourceRule) {
            Object relation = termEvaluator.evaluate(executionEnvironment, ((SetRule)ruleToBeInterpreted).getElement());
            Object bool = termEvaluator.evaluate(executionEnvironment, ((SetRule)ruleToBeInterpreted).getValue());
            if (!(relation instanceof IRelation)) {
                if (ValueKind.UNDEF_LITERAL.equals(relation)) {
                    String[] context = new String[]{"RelationToSet", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"Relation", "RelationToSet", ruleToBeInterpreted.getName(), this.convertToJavaType(relation)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            if (!(bool instanceof Boolean)) {
                if (ValueKind.UNDEF_LITERAL.equals(relation)) {
                    String[] context = new String[]{"isAnySource", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"Boolean", "isAnySource", ruleToBeInterpreted.getName(), this.convertToJavaType(relation)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            try {
                manager.setIsAnyFrom((IRelation)relation, ((Boolean)bool).booleanValue());
            }
            catch (VPMCoreException e) {
                String[] context = new String[]{e.getMessage()};
                throw new ASMInterpreterException("[INTERNAL ERROR] VPM Core exception caught: {1}", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            return Boolean.TRUE;
        }
        if (ruleToBeInterpreted instanceof SetAggregationRule) {
            Object relation = termEvaluator.evaluate(executionEnvironment, ((SetRule)ruleToBeInterpreted).getElement());
            Object bool = termEvaluator.evaluate(executionEnvironment, ((SetRule)ruleToBeInterpreted).getValue());
            if (!(relation instanceof IRelation)) {
                if (ValueKind.UNDEF_LITERAL.equals(relation)) {
                    String[] context = new String[]{"RelationToSet", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"Relation", "RelationToSet", ruleToBeInterpreted.getName(), this.convertToJavaType(relation)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            if (!(bool instanceof Boolean)) {
                if (ValueKind.UNDEF_LITERAL.equals(relation)) {
                    String[] context = new String[]{"isAggregation", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"Boolean", "isAggregation", ruleToBeInterpreted.getName(), this.convertToJavaType(relation)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            try {
                manager.setRelationIsAggregation((IRelation)relation, ((Boolean)bool).booleanValue());
            }
            catch (VPMCoreException e) {
                String[] context = new String[]{e.getMessage()};
                throw new ASMInterpreterException("[INTERNAL ERROR] VPM Core exception caught: {1}", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            return Boolean.TRUE;
        }
        if (ruleToBeInterpreted instanceof CreateSupertypeOf) {
            Object sup = termEvaluator.evaluate(executionEnvironment, ((CreateSupertypeOf)ruleToBeInterpreted).getSuper());
            Object sub = termEvaluator.evaluate(executionEnvironment, ((CreateSupertypeOf)ruleToBeInterpreted).getSub());
            if (!(sup instanceof IModelElement)) {
                if (ValueKind.UNDEF_LITERAL.equals(sup)) {
                    String[] context = new String[]{"Supertype", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"ModelElement (Entity or Relation)", "Supertype", ruleToBeInterpreted.getName(), this.convertToJavaType(sup)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            if (!(sub instanceof IModelElement)) {
                if (ValueKind.UNDEF_LITERAL.equals(sub)) {
                    String[] context = new String[]{"Subtype", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"ModelElement (Entity or Relation)", "Subtype", ruleToBeInterpreted.getName(), this.convertToJavaType(sub)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            try {
                manager.newSupertypeOf((IModelElement)sup, (IModelElement)sub);
            }
            catch (VPMCoreException e) {
                String[] context = new String[]{e.getMessage()};
                throw new ASMInterpreterException("[INTERNAL ERROR] VPM Core exception caught: {1}", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            return Boolean.TRUE;
        }
        if (ruleToBeInterpreted instanceof CreateInstanceOf) {
            Object type = termEvaluator.evaluate(executionEnvironment, ((CreateInstanceOf)ruleToBeInterpreted).getSuper());
            Object inst = termEvaluator.evaluate(executionEnvironment, ((CreateInstanceOf)ruleToBeInterpreted).getSub());
            if (!(type instanceof IModelElement)) {
                if (ValueKind.UNDEF_LITERAL.equals(type)) {
                    String[] context = new String[]{"Type", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"ModelElement (Entity or Relation)", "Type", ruleToBeInterpreted.getName(), this.convertToJavaType(type)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            if (!(inst instanceof IModelElement)) {
                if (ValueKind.UNDEF_LITERAL.equals(inst)) {
                    String[] context = new String[]{"Instance", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"ModelElement (Entity or Relation)", "Instance", ruleToBeInterpreted.getName(), this.convertToJavaType(inst)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            try {
                manager.newInstanceOf((IModelElement)type, (IModelElement)inst);
            }
            catch (VPMCoreException e) {
                String[] context = new String[]{e.getMessage()};
                throw new ASMInterpreterException("[INTERNAL ERROR] VPM Core exception caught: {1}", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            return Boolean.TRUE;
        }
        if (ruleToBeInterpreted instanceof RelationCreateRule) {
            block136: {
                RelationCreateRule relationCreateRule = (RelationCreateRule)ruleToBeInterpreted;
                Object source = termEvaluator.evaluate(executionEnvironment, relationCreateRule.getSource());
                Object target = termEvaluator.evaluate(executionEnvironment, relationCreateRule.getTarget());
                if (!(source instanceof IModelElement)) {
                    if (ValueKind.UNDEF_LITERAL.equals(source)) {
                        String[] context = new String[]{"Source", ruleToBeInterpreted.getName()};
                        throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                    }
                    String[] context = new String[]{"ModelElement (Entity or Relation)", "Source", ruleToBeInterpreted.getName(), this.convertToJavaType(source)};
                    throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                if (!(target instanceof IModelElement)) {
                    if (ValueKind.UNDEF_LITERAL.equals(target)) {
                        String[] context = new String[]{"Target", ruleToBeInterpreted.getName()};
                        throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                    }
                    String[] context = new String[]{"ModelElement (Entity or Relation)", "Target", ruleToBeInterpreted.getName(), this.convertToJavaType(target)};
                    throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                IRelation newRelation = null;
                try {
                    newRelation = manager.newRelation((IModelElement)source, (IModelElement)target);
                    try {
                        executionEnvironment.setVariableValue(relationCreateRule.getTargetVariable().getVariable(), (Object)newRelation);
                    }
                    catch (ViatraTransformationException e) {
                        String[] context = new String[]{relationCreateRule.getTargetVariable().getVariable().getName(), relationCreateRule.getName(), e.getMessage()};
                        throw new ASMInterpreterException("Error at setting the value of the {1} variable by the {2} model manipulation rule: {3}", context, (AnnotatedElement)relationCreateRule);
                    }
                    if (relationCreateRule.getType() == null) break block136;
                    Object type = termEvaluator.evaluate(executionEnvironment, relationCreateRule.getType());
                    if (type instanceof IModelElement) {
                        manager.newInstanceOf((IModelElement)type, (IModelElement)newRelation);
                        break block136;
                    }
                    String[] context = new String[]{ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("TYPE (instanceof) Element of the {1} model manipulation operation does not exit in the modelspace", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                catch (VPMCoreException e) {
                    String[] context = new String[]{e.getMessage()};
                    throw new ASMInterpreterException("[INTERNAL ERROR] VPM Core exception caught: {1}", context, (AnnotatedElement)ruleToBeInterpreted);
                }
            }
            return Boolean.TRUE;
        }
        if (ruleToBeInterpreted instanceof EntityCreateRule) {
            block137: {
                IEntity newEntity = null;
                EntityCreateRule entityCreateRule = (EntityCreateRule)ruleToBeInterpreted;
                try {
                    if (entityCreateRule.getParent() == null) {
                        newEntity = manager.newEntity();
                        try {
                            executionEnvironment.setVariableValue(entityCreateRule.getTargetVariable().getVariable(), (Object)newEntity);
                        }
                        catch (ViatraTransformationException e) {
                            String[] context = new String[]{entityCreateRule.getTargetVariable().getVariable().getName(), entityCreateRule.getName(), e.getMessage()};
                            throw new ASMInterpreterException("Error at setting the value of the {1} variable by the {2} model manipulation rule: {3}", context, (AnnotatedElement)entityCreateRule);
                        }
                    }
                    Object parent = termEvaluator.evaluate(executionEnvironment, entityCreateRule.getParent());
                    if (!(parent instanceof IEntity)) {
                        if (ValueKind.UNDEF_LITERAL.equals(parent)) {
                            String[] context = new String[]{"Container", ruleToBeInterpreted.getName()};
                            throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                        }
                        String[] context = new String[]{"Entity", "Container", ruleToBeInterpreted.getName(), this.convertToJavaType(parent)};
                        throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
                    }
                    newEntity = manager.newEntity((IEntity)parent);
                    try {
                        executionEnvironment.setVariableValue(entityCreateRule.getTargetVariable().getVariable(), (Object)newEntity);
                    }
                    catch (ViatraTransformationException e) {
                        String[] context = new String[]{entityCreateRule.getTargetVariable().getVariable().getName(), entityCreateRule.getName(), e.getMessage()};
                        throw new ASMInterpreterException("Error at setting the value of the {1} variable by the {2} model manipulation rule: {3}", context, (AnnotatedElement)entityCreateRule);
                    }
                    if (entityCreateRule.getType() == null) break block137;
                    Object type = termEvaluator.evaluate(executionEnvironment, entityCreateRule.getType());
                    if (type instanceof IModelElement) {
                        manager.newInstanceOf((IModelElement)type, (IModelElement)newEntity);
                        break block137;
                    }
                    String[] context = new String[]{ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("TYPE (instanceof) Element of the {1} model manipulation operation does not exit in the modelspace", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                catch (VPMCoreException e) {
                    String[] context = new String[]{e.getMessage()};
                    throw new ASMInterpreterException("[INTERNAL ERROR] VPM Core exception caught: {1}", context, (AnnotatedElement)ruleToBeInterpreted);
                }
            }
            return Boolean.TRUE;
        }
        if (ruleToBeInterpreted instanceof DeleteInstanceOf) {
            Object type = termEvaluator.evaluate(executionEnvironment, ((DeleteInstanceOf)ruleToBeInterpreted).getSuper());
            Object inst = termEvaluator.evaluate(executionEnvironment, ((DeleteInstanceOf)ruleToBeInterpreted).getSub());
            if (!(type instanceof IModelElement)) {
                if (ValueKind.UNDEF_LITERAL.equals(type)) {
                    String[] context = new String[]{"Type", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"ModelElement (Entity or Relation)", "Type", ruleToBeInterpreted.getName(), this.convertToJavaType(type)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            if (!(inst instanceof IModelElement)) {
                if (ValueKind.UNDEF_LITERAL.equals(inst)) {
                    String[] context = new String[]{"Instance", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"ModelElement (Entity or Relation)", "Instance", ruleToBeInterpreted.getName(), this.convertToJavaType(inst)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            try {
                manager.deleteInstanceOf((IModelElement)type, (IModelElement)inst);
            }
            catch (VPMCoreException e) {
                String[] context = new String[]{e.getMessage()};
                throw new ASMInterpreterException("[INTERNAL ERROR] VPM Core exception caught: {1}", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            return Boolean.TRUE;
        }
        if (ruleToBeInterpreted instanceof DeleteSupertypeOf) {
            Object sup = termEvaluator.evaluate(executionEnvironment, ((DeleteSupertypeOf)ruleToBeInterpreted).getSuper());
            Object sub = termEvaluator.evaluate(executionEnvironment, ((DeleteSupertypeOf)ruleToBeInterpreted).getSub());
            if (!(sup instanceof IModelElement)) {
                if (ValueKind.UNDEF_LITERAL.equals(sup)) {
                    String[] context = new String[]{"Supertype", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"ModelElement (Entity or Relation)", "Supertype", ruleToBeInterpreted.getName(), this.convertToJavaType(sup)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            if (!(sub instanceof IModelElement)) {
                if (ValueKind.UNDEF_LITERAL.equals(sub)) {
                    String[] context = new String[]{"Subtype", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"ModelElement (Entity or Relation)", "Subtype", ruleToBeInterpreted.getName(), this.convertToJavaType(sub)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            try {
                manager.deleteSupertypeOf((IModelElement)sup, (IModelElement)sub);
            }
            catch (VPMCoreException e) {
                String[] context = new String[]{e.getMessage()};
                throw new ASMInterpreterException("[INTERNAL ERROR] VPM Core exception caught: {1}", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            return Boolean.TRUE;
        }
        if (ruleToBeInterpreted instanceof ElementDeleteRule) {
            EDeleteSemantics deleteSemantics = EDeleteSemantics.DELETE_SEMANTICS_BRANCH_FORCE;
            ElementDeleteRule elementDeleteRule = (ElementDeleteRule)ruleToBeInterpreted;
            if (elementDeleteRule.getSemantics().equals((Object)DeleteSemantics.MOVE_CONTENT_LITERAL)) {
                deleteSemantics = EDeleteSemantics.DELETE_SEMANTICS_FORCE;
            }
            try {
                Object elementToBeDeleted = termEvaluator.evaluate(executionEnvironment, elementDeleteRule.getElement());
                if (ValueKind.UNDEF_LITERAL.equals(elementToBeDeleted)) {
                    String sourceLine = "";
                    String sourceFile = "";
                    int i = 0;
                    while (i < elementDeleteRule.getAnnotations().size()) {
                        if ("sourceline".equals(((Annotation)elementDeleteRule.getAnnotations().get(i)).getKey())) {
                            sourceLine = ((Annotation)elementDeleteRule.getAnnotations().get(i)).getValue();
                        } else if ("sourcefile".equals(((Annotation)elementDeleteRule.getAnnotations().get(i)).getKey())) {
                            sourceFile = ((Annotation)elementDeleteRule.getAnnotations().get(i)).getValue();
                        }
                        ++i;
                    }
                    executionEnvironment.getFramework().getLogger().message(1, "File: \"" + sourceFile + "\", line: " + sourceLine + ": Element Delete called for undefined argument!");
                    return Boolean.TRUE;
                }
                manager.deleteElement((IModelElement)elementToBeDeleted, deleteSemantics);
                if (elementDeleteRule.getElement() instanceof VariableReference) {
                    executionEnvironment.setVariableValue(((VariableReference)elementDeleteRule.getElement()).getVariable(), (Object)ValueKind.UNDEF_LITERAL);
                }
            }
            catch (VPMCoreException e) {
                String[] context = new String[]{e.getMessage()};
                throw new ASMInterpreterException("[INTERNAL ERROR] VPM Core exception caught: {1}", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            return Boolean.TRUE;
        }
        if (ruleToBeInterpreted instanceof MoveRule) {
            Object srcRoot = termEvaluator.evaluate(executionEnvironment, ((MoveRule)ruleToBeInterpreted).getSrcRoot());
            Object trgContainer = termEvaluator.evaluate(executionEnvironment, ((MoveRule)ruleToBeInterpreted).getTrgContainer());
            if (!(srcRoot instanceof IModelElement)) {
                if (ValueKind.UNDEF_LITERAL.equals(srcRoot)) {
                    String[] context = new String[]{"Source", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"ModelElement (Entity or Relation)", "Source", ruleToBeInterpreted.getName(), this.convertToJavaType(srcRoot)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            if (!(trgContainer instanceof IModelElement)) {
                if (ValueKind.UNDEF_LITERAL.equals(trgContainer)) {
                    String[] context = new String[]{"Target", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"ModelElement (Entity or Relation)", "Target", ruleToBeInterpreted.getName(), this.convertToJavaType(trgContainer)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            try {
                manager.moveEntityTo((IEntity)srcRoot, (IEntity)trgContainer);
            }
            catch (VPMCoreException e) {
                String[] context = new String[]{e.getMessage()};
                throw new ASMInterpreterException("[INTERNAL ERROR] VPM Core exception caught: {1}", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            return Boolean.TRUE;
        }
        if (ruleToBeInterpreted instanceof ModelCopyRule) {
            Object srcRoot = termEvaluator.evaluate(executionEnvironment, ((ModelCopyRule)ruleToBeInterpreted).getSrcRoot());
            Object trgContainer = termEvaluator.evaluate(executionEnvironment, ((ModelCopyRule)ruleToBeInterpreted).getTrgContainer());
            if (!(srcRoot instanceof IModelElement)) {
                if (ValueKind.UNDEF_LITERAL.equals(srcRoot)) {
                    String[] context = new String[]{"Source", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"ModelElement (Entity or Relation)", "Source", ruleToBeInterpreted.getName(), this.convertToJavaType(srcRoot)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            if (!(trgContainer instanceof IModelElement)) {
                if (ValueKind.UNDEF_LITERAL.equals(trgContainer)) {
                    String[] context = new String[]{"Target", ruleToBeInterpreted.getName()};
                    throw new ASMInterpreterException("The '{1}' parameter of the {2} rule can not be UNDEF", context, (AnnotatedElement)ruleToBeInterpreted);
                }
                String[] context = new String[]{"ModelElement (Entity or Relation)", "Target", ruleToBeInterpreted.getName(), this.convertToJavaType(trgContainer)};
                throw new ASMInterpreterException("{1} excepted as the {2} parameter of the {3} rule instead of {4}.", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            try {
                executionEnvironment.setVariableValue(((ModelCopyRule)ruleToBeInterpreted).getTargetVariable().getVariable(), (Object)manager.copyModelElement((IModelElement)srcRoot, (IModelElement)trgContainer, ((ModelCopyRule)ruleToBeInterpreted).getSemantics() == CopySemantics.DROP_OUTER_EDGES_LITERAL));
            }
            catch (VPMCoreException e) {
                String[] context = new String[]{e.getMessage()};
                throw new ASMInterpreterException("[INTERNAL ERROR] VPM Core exception caught: {1}", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            catch (ViatraTransformationException e) {
                String[] context = new String[]{((ModelCopyRule)ruleToBeInterpreted).getTargetVariable().getVariable().getName(), ruleToBeInterpreted.getName(), e.getMessage()};
                throw new ASMInterpreterException("Error at setting the value of the {1} variable by the {2} model manipulation rule: {3}", context, (AnnotatedElement)ruleToBeInterpreted);
            }
            return Boolean.TRUE;
        }
        return null;
    }

    public static /* bridge */ /* synthetic */ RuleInterpreter getInstance() {
        return ModelManipulationRuleInterpreter.getInstance();
    }
}

