/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ValueKind implements Enumerator
{
    UNDEF_LITERAL(0, "undef", "undef"),
    BOOLEAN_LITERAL(1, "boolean", "boolean"),
    STRING_LITERAL(2, "string", "string"),
    INTEGER_LITERAL(3, "integer", "integer"),
    DOUBLE_LITERAL(4, "double", "double"),
    MODELELEMENT_LITERAL(5, "modelelement", "modelelement"),
    MULTIPLICITY_LITERAL(6, "multiplicity", "multiplicity"),
    ERROR_LITERAL(7, "error", "error");

    public static final String copyright = " * Copyright (c) 2006-2010 Istvan Rath and Daniel Varro\r\n * All rights reserved. This program and the accompanying materials\r\n * are made available under the terms of the Eclipse Public License v1.0\r\n * which accompanies this distribution, and is available at\r\n * http://www.eclipse.org/legal/epl-v10.html\r\n *\r\n * Contributors:\r\n *    Istvan Rath, Daniel Varro - initial API and implementation\r\n";
    public static final int UNDEF = 0;
    public static final int BOOLEAN = 1;
    public static final int STRING = 2;
    public static final int INTEGER = 3;
    public static final int DOUBLE = 4;
    public static final int MODELELEMENT = 5;
    public static final int MULTIPLICITY = 6;
    public static final int ERROR = 7;
    private static final ValueKind[] VALUES_ARRAY;
    public static final List<ValueKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ValueKind[]{UNDEF_LITERAL, BOOLEAN_LITERAL, STRING_LITERAL, INTEGER_LITERAL, DOUBLE_LITERAL, MODELELEMENT_LITERAL, MULTIPLICITY_LITERAL, ERROR_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ValueKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValueKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ValueKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ValueKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ValueKind get(int value) {
        switch (value) {
            case 0: {
                return UNDEF_LITERAL;
            }
            case 1: {
                return BOOLEAN_LITERAL;
            }
            case 2: {
                return STRING_LITERAL;
            }
            case 3: {
                return INTEGER_LITERAL;
            }
            case 4: {
                return DOUBLE_LITERAL;
            }
            case 5: {
                return MODELELEMENT_LITERAL;
            }
            case 6: {
                return MULTIPLICITY_LITERAL;
            }
            case 7: {
                return ERROR_LITERAL;
            }
        }
        return null;
    }

    private ValueKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

