/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra2.core.IEntity;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.gtasm.interpreter.exception.ViatraTransformationException;
import org.eclipse.viatra2.gtasm.patternmatcher.ExecutionMode;
import org.eclipse.viatra2.gtasm.patternmatcher.IMatching;
import org.eclipse.viatra2.gtasm.patternmatcher.ParameterMode;
import org.eclipse.viatra2.gtasm.patternmatcher.PatternCallSignature;
import org.eclipse.viatra2.gtasm.patternmatcher.Scope;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherCompileTimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.IKeyGenerator;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingKey;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingTable;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.PatternNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.RemoteGoal;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.term.ITermHandler;
import org.eclipse.viatra2.gtasm.patternmatcher.patterns.IPatternMatcher;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.enums.ValueKind;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.gt.GTPattern;
import org.eclipse.viatra2.logger.Logger;

public class PatternMatcher
implements IPatternMatcher {
    protected Logger logger;
    protected IModelManager manager;
    protected ITermHandler termHandler;
    protected PatternNode root;
    protected Map<String, Map<String, RemoteGoal>> rggMapping;
    protected Random random = null;

    public PatternMatcher(Logger logger, IModelManager manager, ITermHandler termHandler) throws PatternMatcherCompileTimeException {
        this.logger = logger;
        this.manager = manager;
        this.termHandler = termHandler;
    }

    public PatternMatcher(GTPattern pattern, Logger logger, IModelManager manager, ITermHandler termHandler) throws PatternMatcherCompileTimeException {
        this.logger = logger;
        this.manager = manager;
        this.termHandler = termHandler;
        this.root = new PatternNode(this, pattern);
        this.rggMapping = new HashMap<String, Map<String, RemoteGoal>>();
    }

    public boolean match(Object[] inputMapping) throws ViatraTransformationException {
        PatternCallSignature[] signature = new PatternCallSignature[inputMapping.length];
        int i = 0;
        while (i < inputMapping.length) {
            signature[i] = new PatternCallSignature();
            signature[i].setExecutionMode(ExecutionMode.SINGLE_RESULT);
            if (inputMapping[i] == null || inputMapping[i].equals(ValueKind.UNDEF_LITERAL)) {
                signature[i].setParameterMode(ParameterMode.OUTPUT);
            } else {
                signature[i].setParameterMode(ParameterMode.INPUT);
            }
            Scope scope = new Scope(Scope.DEFAULT_MODE, (IModelElement)this.manager.getRoot());
            signature[i].setParameterScope(scope);
            ++i;
        }
        return this.match(inputMapping, signature) != null;
    }

    public IMatching match(Object[] inputMapping, PatternCallSignature[] signature) throws ViatraTransformationException {
        int i = 0;
        while (i < signature.length) {
            if (signature[i].getExecutionMode() == ExecutionMode.MULTIPLE_RESULTS) {
                String[] context = new String[]{this.root.getPattern().getName()};
                throw new PatternMatcherRuntimeException("[INTERNAL ERROR] An error happened during the evaluation of the {1} pattern. It was invoked in a single result mode but its input parameters are marked to be multiple results.", context, (AnnotatedElement)this.root.getPattern());
            }
            ++i;
        }
        Integer[] quantificationOrder = new Integer[signature.length];
        int i2 = 0;
        while (i2 < quantificationOrder.length) {
            quantificationOrder[i2] = i2;
            ++i2;
        }
        Collection<IMatching> solutions = this.matchAll(inputMapping, signature, quantificationOrder);
        Iterator<IMatching> iterator = solutions.iterator();
        if (iterator.hasNext()) {
            IMatching matching = iterator.next();
            return matching;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<IMatching> matchAll(Object[] inputMapping, PatternCallSignature[] signature, Integer[] quantificationOrder) throws ViatraTransformationException {
        block36: {
            block35: {
                block31: {
                    try {
                        if (signature.length != quantificationOrder.length) {
                            context = new String[]{this.root.getPattern().getName()};
                            throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The number of signatures and quantification orders for the {1} pattern call do not match.", context, (AnnotatedElement)this.root.getPattern());
                        }
                        multipleUpperBound = 0;
                        vector = new Vector<Integer>();
                        i = 0;
                        while (true) {
                            if (i >= quantificationOrder.length) {
                                keys = new Integer[vector.size()];
                                vector.toArray(keys);
                                resultKeyGenerator = new IKeyGenerator<MatchingKey, MatchingFrame>(){

                                    @Override
                                    public MatchingKey calculateKey(MatchingFrame value) {
                                        Object[] matchingKey = new Object[keys.length];
                                        int i = 0;
                                        while (i < keys.length) {
                                            matchingKey[i] = value.getValue(keys[i]);
                                            ++i;
                                        }
                                        return new MatchingKey(matchingKey);
                                    }

                                    @Override
                                    public int size() {
                                        return keys.length;
                                    }
                                };
                                result = new MatchingTable();
                                if (signature.length != 0) break;
                                return result;
                            }
                            index = quantificationOrder[i];
                            if (index >= signature.length) {
                                context = new String[]{this.root.getPattern().getName()};
                                throw new PatternMatcherRuntimeException("[INETRNAL ERROR] Error in the quantification order of the {1}'s pattern call.", context, (AnnotatedElement)this.root.getPattern());
                            }
                            if (signature[index].getExecutionMode() == ExecutionMode.MULTIPLE_RESULTS) {
                                if (i > multipleUpperBound) {
                                    context = new String[]{this.root.getPattern().getName()};
                                    throw new PatternMatcherRuntimeException("[INETRNAL ERROR] Error in the quantification order of the {1}'s pattern call.", context, (AnnotatedElement)this.root.getPattern());
                                }
                                vector.add(index);
                                ++multipleUpperBound;
                            }
                            ++i;
                        }
                        adornment = new Boolean[signature.length];
                        vec = new Vector<Object>();
                        i = 0;
                        while (true) {
                            block32: {
                                if (i < signature.length) break block32;
                                strongestConstraint = 0;
                                if (vec.size() != 0) break block31;
                                largestDistance = 0;
                                hasInConstraint = false;
                                i = 0;
                                if (true) ** GOTO lbl77
                            }
                            if (signature[i].getParameterMode() == ParameterMode.INPUT) {
                                adornment[i] = true;
                                vec.add(inputMapping[i]);
                            } else {
                                adornment[i] = false;
                            }
                            ++i;
                        }
                    }
                    catch (PatternMatcherRuntimeException e) {
                        throw e.addNewStackElement((EObject)this.root.getPattern());
                    }
                    do {
                        block34: {
                            block33: {
                                s = signature[i].getParameterScope();
                                distance = 0;
                                parent = (IEntity)s.getParent();
                                distance = 0;
                                while (!parent.equals(this.manager.getRoot())) {
                                    parent = parent.getParent();
                                    ++distance;
                                }
                                if (s.getContainmentMode() != 0) break block33;
                                if (hasInConstraint && distance > largestDistance) {
                                    largestDistance = distance;
                                    strongestConstraint = i;
                                    break block34;
                                } else if (!hasInConstraint) {
                                    hasInConstraint = true;
                                    largestDistance = distance;
                                    strongestConstraint = i;
                                }
                                break block34;
                            }
                            if (s.getContainmentMode() == 1 && !hasInConstraint && distance > largestDistance) {
                                largestDistance = distance;
                                strongestConstraint = i;
                            }
                        }
                        ++i;
lbl77:
                        // 2 sources

                    } while (i < signature.length);
                    adornment[strongestConstraint] = true;
                }
                if ((rggRoots = this.rggMapping.get(adornmentString = Arrays.deepToString(adornment))) == null) {
                    rggRoots = new HashMap<String, RemoteGoal>();
                    this.root.buildRuleGoalGraph((Boolean[])adornment, rggRoots);
                    this.rggMapping.put(adornmentString, rggRoots);
                }
                main = rggRoots.get(RemoteGoal.generateID(this.root, (Boolean[])adornment));
                if (vec.size() != 0) break block35;
                ms = main.getMagicSet();
                s = signature[strongestConstraint].getParameterScope();
                parent = (IEntity)s.getParent();
                i = s.getContainmentMode() == 0 ? parent.getElementsInNamespace().iterator() : parent.getAllElementsInNamespace().iterator();
                if (true) ** GOTO lbl102
            }
            input = new Object[vec.size()];
            vec.toArray(input);
            main.getMagicSet().addArray(new MatchingKey(input));
            break block36;
            do {
                input = new Object[]{i.next()};
                ms.addArray(new MatchingKey(input));
lbl102:
                // 2 sources

            } while (i.hasNext());
        }
        isModified = false;
        for (RemoteGoal goal : rggRoots.values()) {
            v0 = isModified = goal.synchronize() != false ? true : isModified;
        }
        while (isModified) {
            isModified = false;
            for (RemoteGoal goal : rggRoots.values()) {
                goal.matchAll();
            }
            for (RemoteGoal goal : rggRoots.values()) {
                v1 = isModified = goal.synchronize() != false ? true : isModified;
            }
        }
        for (MatchingFrame frame : main) {
            constraintsFulfilled = true;
            i = 0;
            while (constraintsFulfilled && i < signature.length) {
                if (signature[i].getParameterMode() == ParameterMode.OUTPUT) {
                    s = signature[i].getParameterScope();
                    container = (IEntity)s.getParent();
                    obj = frame.getValue(i);
                    if (obj instanceof IModelElement) {
                        me = (IModelElement)obj;
                        if (s.getContainmentMode() == 0) {
                            constraintsFulfilled = me.getNamespace().compareTo((Object)container) == 0;
                        } else if (s.getContainmentMode() == 1) {
                            constraintsFulfilled = me.isBelowNamespace((IModelElement)container);
                        }
                    }
                }
                ++i;
            }
            if (!constraintsFulfilled) continue;
            result.put((MatchingKey)resultKeyGenerator.calculateKey(frame), frame);
        }
        for (RemoteGoal rg : rggRoots.values()) {
            rg.init();
        }
        return result;
    }

    public IMatching matchRandomly(Object[] inputMapping, PatternCallSignature[] signature) throws ViatraTransformationException {
        if (this.random == null) {
            this.random = new Random();
        }
        Integer[] quantificationOrder = new Integer[inputMapping.length];
        int quantificationOrderMultipleIndex = 0;
        int quantificationOrderNonMultipleIndex = signature.length - 1;
        int j = 0;
        while (j < signature.length) {
            if (signature[j].getParameterMode() == ParameterMode.OUTPUT) {
                signature[j].setExecutionMode(ExecutionMode.MULTIPLE_RESULTS);
                quantificationOrder[quantificationOrderMultipleIndex] = j;
                ++quantificationOrderMultipleIndex;
            } else {
                quantificationOrder[quantificationOrderNonMultipleIndex] = j;
                --quantificationOrderNonMultipleIndex;
            }
            ++j;
        }
        Collection<IMatching> allMatches = this.matchAll(inputMapping, signature, quantificationOrder);
        if (allMatches == null || allMatches.isEmpty()) {
            return null;
        }
        return (IMatching)allMatches.toArray()[this.random.nextInt(allMatches.size())];
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ITermHandler getTermHandler() {
        return this.termHandler;
    }

    public IModelManager getModelManager() {
        return this.manager;
    }
}

