/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.IKeyGenerator;

public class HistoryList<KeyType, ValueType>
extends LinkedList<ValueType> {
    private static final long serialVersionUID = 4033836249907829630L;
    private IKeyGenerator<KeyType, ValueType> keyGenerator;
    private Map<KeyType, List<ValueType>> map;

    public HistoryList(IKeyGenerator<KeyType, ValueType> keyGenerator) {
        this.keyGenerator = keyGenerator;
        this.map = new HashMap<KeyType, List<ValueType>>();
    }

    public List<ValueType> get(KeyType key) {
        return this.map.get(key);
    }

    public void init() {
        this.clear();
        this.map.clear();
    }

    @Override
    public Iterator<ValueType> iterator() {
        return new Itr(super.iterator());
    }

    private class Itr
    implements Iterator<ValueType> {
        private Iterator<ValueType> backingIterator;
        private ValueType lastReturned;

        private Itr(Iterator<ValueType> i) {
            this.backingIterator = i;
            this.lastReturned = null;
        }

        @Override
        public boolean hasNext() {
            return this.backingIterator.hasNext();
        }

        @Override
        public ValueType next() {
            try {
                this.lastReturned = this.backingIterator.next();
                return this.lastReturned;
            }
            catch (NoSuchElementException e) {
                this.lastReturned = null;
                throw e;
            }
        }

        @Override
        public void remove() {
            LinkedList list;
            Object key;
            if (this.lastReturned != null) {
                key = HistoryList.this.keyGenerator.calculateKey(this.lastReturned);
                list = (LinkedList)HistoryList.this.map.get(key);
                if (list == null) {
                    list = new LinkedList();
                }
            } else {
                throw new IllegalStateException();
            }
            list.add(this.lastReturned);
            HistoryList.this.map.put(key, list);
            this.backingIterator.remove();
            this.lastReturned = null;
        }
    }
}

