/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PConstraint;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.tuple.Tuple;

public class Stub<HandleType> {
    private HandleType handle;
    private Tuple variablesTuple;
    private Map<Object, Integer> variablesIndex;
    private Set<PConstraint> constraints;
    private Stub<HandleType> primaryParentStub;
    private Stub<HandleType> secondaryParentStub;

    private Stub(Map<Object, Integer> variablesIndex, Tuple variablesTuple, HandleType handle) {
        this.variablesIndex = variablesIndex;
        this.variablesTuple = variablesTuple;
        this.handle = handle;
        this.constraints = new HashSet<PConstraint>();
    }

    public Stub(Tuple variablesTuple, HandleType handle) {
        this(variablesTuple.invertIndex(), variablesTuple, handle);
    }

    public Stub(Stub<HandleType> primaryParent, HandleType handle) {
        this(primaryParent.variablesIndex, primaryParent.variablesTuple, handle);
        this.primaryParentStub = primaryParent;
        this.constraints.addAll(primaryParent.getAllEnforcedConstraints());
    }

    public Stub(Stub<HandleType> primaryParent, Tuple variablesTuple, HandleType handle) {
        this(variablesTuple.invertIndex(), variablesTuple, handle);
        this.primaryParentStub = primaryParent;
        this.constraints.addAll(primaryParent.getAllEnforcedConstraints());
    }

    public Stub(Stub<HandleType> primaryParent, Stub<HandleType> secondaryParent, Tuple variablesTuple, HandleType handle) {
        this(variablesTuple.invertIndex(), variablesTuple, handle);
        this.primaryParentStub = primaryParent;
        this.secondaryParentStub = secondaryParent;
        this.constraints.addAll(primaryParent.getAllEnforcedConstraints());
        this.constraints.addAll(secondaryParent.getAllEnforcedConstraints());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Stub(" + this.getVariablesTuple() + "@" + this.getHandle() + "|");
        for (PConstraint constraint : this.constraints) {
            sb.append(String.valueOf(constraint.toString()) + "&");
        }
        sb.append(")");
        return sb.toString();
    }

    public Tuple getVariablesTuple() {
        return this.variablesTuple;
    }

    public HandleType getHandle() {
        return this.handle;
    }

    public Map<Object, Integer> getVariablesIndex() {
        return this.variablesIndex;
    }

    public Set<Object> getVariablesSet() {
        return this.variablesIndex.keySet();
    }

    public Set<PConstraint> getAllEnforcedConstraints() {
        return this.constraints;
    }

    public Set<PConstraint> getDeltaEnforcedConstraints() {
        HashSet<PConstraint> result = new HashSet<PConstraint>(this.constraints);
        if (this.primaryParentStub != null) {
            result.removeAll(this.primaryParentStub.getAllEnforcedConstraints());
        }
        if (this.secondaryParentStub != null) {
            result.removeAll(this.secondaryParentStub.getAllEnforcedConstraints());
        }
        return result;
    }

    public void addConstraint(PConstraint constraint) {
        this.constraints.add(constraint);
    }

    public Stub<HandleType> getPrimaryParentStub() {
        return this.primaryParentStub;
    }

    public Stub<HandleType> getSecondaryParentStub() {
        return this.secondaryParentStub;
    }
}

