/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.Buildable;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.RetePatternBuildException;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PConstraint;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PSystem;
import org.eclipse.viatra2.gtasm.patternmatcher.incremental.rete.construction.psystem.PVariable;

public abstract class BasePConstraint<PatternDescription, StubHandle>
implements PConstraint {
    protected PSystem<PatternDescription, StubHandle, ?> pSystem;
    protected Buildable<PatternDescription, StubHandle, ?> buildable;
    private Set<PVariable> affectedVariables;

    public BasePConstraint(PSystem<PatternDescription, StubHandle, ?> pSystem, Set<PVariable> affectedVariables) {
        this.pSystem = pSystem;
        this.buildable = pSystem.getBuildable();
        this.affectedVariables = new HashSet<PVariable>(affectedVariables);
        for (PVariable pVariable : affectedVariables) {
            pVariable.refer(this);
        }
        pSystem.registerConstraint(this);
    }

    public String toString() {
        return "PC[" + this.getClass().getSimpleName() + ":" + this.toStringRest() + "]";
    }

    protected abstract String toStringRest();

    @Override
    public Set<PVariable> getAffectedVariables() {
        return this.affectedVariables;
    }

    @Override
    public void replaceVariable(PVariable obsolete, PVariable replacement) {
        if (this.affectedVariables.remove(obsolete)) {
            this.affectedVariables.add(replacement);
            obsolete.unrefer(this);
            replacement.refer(this);
            this.doReplaceVariable(obsolete, replacement);
        }
    }

    protected abstract void doReplaceVariable(PVariable var1, PVariable var2);

    @Override
    public void delete() {
        for (PVariable pVariable : this.affectedVariables) {
            pVariable.unrefer(this);
        }
        this.pSystem.unregisterConstraint(this);
    }

    @Override
    public void checkSanity() throws RetePatternBuildException {
    }
}

